#include "widget/HighlightButtonView.hpp"
#include "mof/mofGraphics.hpp"
#include "mof/Sprite.hpp"
#include "mof/widget/Effect.hpp"
#include "mof/utilities.hpp"
#include "mof/widgets.hpp"
#include "mof/streams.hpp"
#include "resource.hpp"

using mof::widget::WidgetView;

namespace 
{
    const mof::Color4f HIGHLIGHT_COLOR( 0.8f , 0.4f , 0.6f , 1  );
    const mof::Color4f HIGHLIGHT_COLOR2( 1 , 0.6f , 0.8f , 1  );
    const mof::Color4f NORMAL_COLOR( 0 , 0.4f , 0.6f , 1  );
    const mof::Color4f HIGHLIGHT_TEXT_COLOR_FASE1( 1 , 1 , 1 , 0.5f );
    const mof::Color4f HIGHLIGHT_TEXT_COLOR_FASE2( 1 , 0.5f , 1 , 0.7f );
    const mof::Color4f HIGHLIGHT_TEXT_COLOR_FASE3( 1 , 0.8f , 1 , 0.9f );
    const mof::Color4f NORMAL_TEXT_COLOR( 1 , 1 , 1 , 1  );
}
//{{{ struct Impl
struct HighlightButtonView::Impl
{
    mof::Effect* pEffect;
    WidgetView* pView;
	mof::Vector2D preferredSize;
    mof::ReferenceWrapper<mof::Color4f> imageColorWrapper;
    mof::ReferenceWrapper<mof::Color4f> bgColorWrapper;
	bool visible_;
	bool is_disable_;

    Impl( WidgetView* pView_, bool is_disable )
    : visible_(true), pEffect( NULL ) , pView( pView_ ), is_disable_(is_disable)
    {
    }

    ~Impl()
    {
        delete pEffect;
        delete pView;
    }

};
//}}}
//{{{ constructor
HighlightButtonView::HighlightButtonView
(
	const boost::function<WidgetView*(void)>& viewFactory,
	bool  is_disable 
)
: m_pImpl( new Impl( viewFactory(), is_disable ) ) 
{
    m_pImpl->pEffect = new mof::Effect( );
    {  
        m_pImpl->pView->getPositionStream()
            << getPositionStream()
            << mof::Vector2D( 0 , 0 )
            << mof::Vector2D( 0 , 0 );
        m_pImpl->pView->getColorStream() 
            << getColorStream() 
            << m_pImpl->imageColorWrapper.makeRef(mof::Color4f(1 , 1 , 1 , 1))
            << m_pImpl->imageColorWrapper.makeRef(NORMAL_TEXT_COLOR);
        m_pImpl->preferredSize = m_pImpl->pView->getSizeStream().value(); 
        m_sizeStream << m_pImpl->preferredSize; 
    }
    { // 背景の生成
        mof::Sprite* pSprite = new mof::Sprite
        (
            ::getTextureResourceManager( SYSTEM )->getResource( "image/fill.png" ) , 
            mof::Rectangle<mof::real>( 0 , 0 , 1 , 1 ) 
        );
        m_pImpl->pEffect->addSprite(_T("bg") , pSprite);
        
        pSprite->getPositionStream() << getPositionStream( ) << mof::Vector2D( 0 , 0 ) << mof::Vector2D( 0 , 0 );
        pSprite->getColorStream() 
            << getColorStream() 
            << m_pImpl->bgColorWrapper.makeRef(mof::Color4f(0 , 1 , 1 , 1))
            << m_pImpl->bgColorWrapper.makeRef(NORMAL_COLOR);
        pSprite->setSizeStream( m_sizeStream );//背景のサイズはビューのサイズに依存
    }

    
}
//}}}
//{{{ destructor
HighlightButtonView::~HighlightButtonView()
{
}
//}}}
//{{{ update
void HighlightButtonView::update( )
{
    m_positionStream.update( );
    m_sizeStream.update( );
    m_colorStream.update( );
    m_pImpl->pEffect->update( );
    m_pImpl->pView->update( );
}
//}}}
//{{{ draw
void HighlightButtonView::draw( ) const
{
	if (!m_pImpl->visible_) return;  
    m_pImpl->pEffect->draw( );
    m_pImpl->pView->draw( );
}
//}}}
//{{{ setVisible
void HighlightButtonView::setVisible(bool visible)
{
	m_pImpl->visible_ = visible;
}
//}}}
//{{{ show
mof::FrameNumber HighlightButtonView::show( bool imidiately ) 
{
    m_pImpl->pView->show( imidiately );
    if( imidiately )
    {
        m_pImpl->imageColorWrapper.replace(0 , mof::Color4f(1 , 1 , 1 , 1));
        m_pImpl->bgColorWrapper.replace(0 , mof::Color4f(1 , 1 , 1 , 1));
        return 0;
    }
    
    { //Text更新
        m_pImpl->imageColorWrapper.replace
        (
            0 , m_colorStream ,
            mof::makeKeyFrameAnimationHandler
            ( 
                0 , mof::Color4f(0 , 1, 1 , 1) ,
                30 , mof::Color4f(1 , 1, 1 , 1) 
            ) 
        );
    }
    { //背景更新(透明度)
        m_pImpl->bgColorWrapper.replace
        (
            0 , m_colorStream , 
            mof::makeKeyFrameAnimationHandler
            ( 
                0 , mof::Color4f(0 , 1, 1 , 1) ,
                30 , mof::Color4f(1 , 1, 1 , 1) 
            ) 
        );
    }

    return 30;
}
//}}}
//{{{ hide
mof::FrameNumber HighlightButtonView::hide( bool imidiately )
{
    m_pImpl->pView->hide( imidiately );
    if( imidiately )
    {
        m_pImpl->imageColorWrapper.replace(0 , mof::Color4f( 0 , 1 , 1 , 1)); 
        m_pImpl->bgColorWrapper.replace(0 , mof::makeConstantHandler( mof::Color4f( 0 , 1 , 1 , 1 ) ));
        return 0;
    }
    
    { //Text更新
        m_pImpl->imageColorWrapper.replace
        ( 
            0 , m_colorStream ,
            mof::makeKeyFrameAnimationHandler
            ( 
                0 , mof::Color4f(1 , 1, 1 , 1) ,
                30 , mof::Color4f(0 , 1, 1 , 1) 
            ) 
        );
    }
    { //背景更新
        m_pImpl->bgColorWrapper.replace
        (
            0 , m_colorStream ,
            mof::makeKeyFrameAnimationHandler
            ( 
                0 , mof::Color4f(1 , 1, 1 , 1) ,
                30 , mof::Color4f(0 , 1, 1 , 1) 
            ) 
        );
    }

    return 30;
}
//}}}
//{{{ focus
mof::FrameNumber HighlightButtonView::focus( bool imidiately ) 
{
    m_pImpl->pView->focus( imidiately );
  
    //TODO imidiately , shared
    static mof::Manipulator<mof::Color4f>::Handler manip;
    static bool isInitialized = false;
    if(!isInitialized)
    {
        mof::KeyFrameAnimation<mof::Color4f>::KeyFrame keyFrames[] = {
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(0 , HIGHLIGHT_TEXT_COLOR_FASE2) ,
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(30 , HIGHLIGHT_TEXT_COLOR_FASE2) ,
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(50 , HIGHLIGHT_TEXT_COLOR_FASE1) ,
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(70 , HIGHLIGHT_TEXT_COLOR_FASE1) ,
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(120 , HIGHLIGHT_TEXT_COLOR_FASE2) ,
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(170 , HIGHLIGHT_TEXT_COLOR_FASE2) ,
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(220 , HIGHLIGHT_TEXT_COLOR_FASE3) ,
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(270 , HIGHLIGHT_TEXT_COLOR_FASE2) ,
        };
        manip = mof::makeKeyFrameAnimationHandler<mof::Color4f>
        (
            keyFrames[0] , mof::lastOf(keyFrames)
        );
        isInitialized = true;
    }
    {
        if (!m_pImpl->is_disable_) m_pImpl->imageColorWrapper.replace(1 , m_colorStream , manip);
        m_pImpl->bgColorWrapper.replace(1 , HIGHLIGHT_COLOR);
        return 30;
    }
    
}
//}}}
//{{{ blur
mof::FrameNumber HighlightButtonView::blur( bool imidiately )
{
    m_pImpl->pView->blur( imidiately );
    {
        if (!m_pImpl->is_disable_) m_pImpl->imageColorWrapper.replace(1 , NORMAL_TEXT_COLOR);
        m_pImpl->bgColorWrapper.replace(1 , NORMAL_COLOR);
        return 0;
    }

}
//}}}
//{{{ click 
mof::FrameNumber HighlightButtonView::click(bool)
{
    static mof::Manipulator<mof::Color4f>::Handler manip1;
    static mof::Manipulator<mof::Color4f>::Handler manip2;
    static bool isInitialized = false;
	if(!isInitialized)
    {
		mof::KeyFrameAnimation<mof::Color4f>::KeyFrame keyFrames1[] = {
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(0 , HIGHLIGHT_TEXT_COLOR_FASE2) ,
        };
        manip1 = mof::makeKeyFrameAnimationHandler<mof::Color4f>
        (
            keyFrames1[0] , mof::lastOf(keyFrames1)
        );

        mof::KeyFrameAnimation<mof::Color4f>::KeyFrame keyFrames2[] = {
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(0 , HIGHLIGHT_COLOR) ,
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(5 , HIGHLIGHT_COLOR2) ,
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(10 , HIGHLIGHT_COLOR) ,
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(15 , HIGHLIGHT_COLOR2) ,
            mof::KeyFrameAnimation<mof::Color4f>::KeyFrame(20 , HIGHLIGHT_COLOR) ,
        };
        manip2 = mof::makeKeyFrameAnimationHandler<mof::Color4f>
        (
            keyFrames2[0] , mof::lastOf(keyFrames2)
        );
        isInitialized = true;
    }
    {
        m_pImpl->imageColorWrapper.replace(1 , m_colorStream , manip1);
        m_pImpl->bgColorWrapper.replace(1, m_colorStream, manip2);
        return 10;
    }
}
//}}}
//{{{ getPreferredSize
mof::Vector2D HighlightButtonView::getPreferredSize() const
{
    return m_pImpl->preferredSize;
}
//}}}

