#pragma once
#include <mof/math/basic_vector.hpp>

namespace mof
{
namespace math
{
	/**
	 * @brief 2次元同次座標ベクトルクラス
	 */
	class vector2 : public basic_vector<2, vector2>
	{
	public:
//{{{ constructor
		/**
		 * @brief デフォルトコンストラクタ．
		 * @note  効率のためは初期化されない
		 */
		vector2()
		{
		}

		/**
		 * @brief 指定した値で初期化する．
		 * @param[in] x x座標成分
		 * @param[in] y y座標成分
		 */
		vector2(float x, float y)
		{
			components_[0] = x;
			components_[1] = y;
		}
		
		/**
		 * @brief 指定した値で初期化する．
		 * @tparam    T   配列型（operator[]をオーバーロードしていること）
		 * @param[in] arr 初期化用配列
		 */
		template <class T>
		vector2(const T& arr)
		{
			components_[0] = arr[0];
			components_[1] = arr[1];
		}
//}}}
//{{{ accessers
		float x() const { return components_[0]; }
		float y() const { return components_[1]; }
		float z() const { return 1; }// 第3要素は常に1
//}}}
	};

}// namespace math
}// namespace mof
