#pragma once
#include <memory>
#include <mof/widget/Layout.hpp>

namespace mof
{
namespace widget
{

	class OverlapLayout : public Layout
    {
	public:

		OverlapLayout( const mof::Vector2D& size );
		virtual ~OverlapLayout();
		virtual void add(std::shared_ptr<WidgetView> pView);
        virtual Vector2D getPreferredSize() const;
        virtual void connect(WidgetView* pParentView);
        virtual size_t getLength( ) const;
        virtual int getAdjacencyAsUp(int index) const;
        virtual int getAdjacencyAsDown(int index) const;
        virtual int getAdjacencyAsLeft(int index) const;
        virtual int getAdjacencyAsRight(int index) const;

    private:
        struct Impl;
		std::unique_ptr<Impl> m_pImpl;
	};

}
} // namepsace mof

