#pragma once
#include <boost/scoped_ptr.hpp>
#include <memory>
#include <mof/widget/Widget.hpp>
#include <mof/FactoryMethod.hpp>
#include <mof/widget/AbstractTextCompiler.hpp>

namespace mof
{
    class Font;

namespace widget
{

    class Frame : public Widget
    {
    public:
		enum BehaviorTarget
		{
			FRAME_OPEN,
			FRAME_CLOSE,
		};


        Frame
        (
            const tstring& title ,
            std::shared_ptr<WidgetView> content ,
            const FactoryMethod<WidgetView>& contentBackground ,
            const FactoryMethod<WidgetView>& titleBackground,
			const FactoryMethod<AbstractTextCompiler>& text_compiler
        );
        virtual ~Frame();
		virtual FrameNumber show(bool imidiately = false);
		virtual FrameNumber hide(bool imidiately = false);
        virtual const std::shared_ptr<WidgetView> getView( ) const;
        virtual std::shared_ptr<WidgetView> getView( );
		virtual void update();
        
        void setCaption(const tstring& title);
		void setBehaviorOnPosition(BehaviorTarget, mof::Manipulator<mof::Vector2D>::Handler position, FrameNumber period);
		void setBehaviorOnSize(BehaviorTarget, mof::Manipulator<mof::Vector2D>::Handler size, FrameNumber period);
		void setBehaviorOnColor(BehaviorTarget, mof::Manipulator<mof::Color4f>::Handler color, FrameNumber period);

        
    protected:
        struct Impl;
        boost::scoped_ptr<Impl> m_pImpl;

    };


} // namespace widget
} // namespace mof
