#pragma once
#include <boost/scoped_ptr.hpp>
#include <boost/utility.hpp>
#include "mof/tstring.hpp"

namespace mof{
	class Sprite;
	class Drawable;

	class Effect : boost::noncopyable{
		struct Impl;
		boost::scoped_ptr<Impl> m_pImpl;
	public:
		Effect();
		~Effect();
		mof::Sprite* getSpriteByName(const mof::tstring& name);
		void addSprite(const mof::tstring& name , mof::Sprite* pSprite);
		void addDrawable( const mof::tstring& name , mof::Drawable* pDrawable );
		void remove(const mof::tstring& name);
		void deleteAll();

		void draw() const;
		void update();
	};

	
}
