#pragma once
#include "mof/Animation.hpp"
#include "mof/Vector3D.hpp"
	
namespace mof{

	class UniformAnimation : public mof::Animation<mof::Vector3D>
    {
	
	    mof::Vector3D m_initialValue;
	    mof::Vector3D m_targetValue;	
		double m_speed;	
	    public:
	
		UniformAnimation
        (
		    const mof::Vector3D& initialValue	,
		    const mof::Vector3D& targetValue	,
            double speed 
	    ) 
        : m_initialValue(initialValue) , m_targetValue(targetValue) , m_speed(speed)
		{
		}
	
	
		virtual mof::Vector3D getValue( mof::FrameNumber frame) const
        {
            
			mof::Vector3D direction = ( m_targetValue - m_initialValue );
            direction.normalize();
            mof::Vector3D result = m_initialValue + direction * m_speed * frame;// 
            if( direction.x > 0 && result.x > m_targetValue.x )result.x = m_targetValue.x; 
            else if( direction.x < 0 && result.x < m_targetValue.x )result.x = m_targetValue.x; 
            if( direction.y > 0 && result.y > m_targetValue.y )result.y = m_targetValue.y; 
            else if( direction.y < 0 && result.y < m_targetValue.y )result.y = m_targetValue.y; 
            if( direction.z > 0 && result.z > m_targetValue.z )result.z = m_targetValue.z; 
            else if( direction.z < 0 && result.z < m_targetValue.z )result.z = m_targetValue.z; 
            
            return result;
        }

        		 
	};
	
	
	
} //namespace mof
	
