#pragma once
#include <mof/stream/Manipulator.hpp>
#include <mof/stream/Cache.hpp>

namespace mof
{
    template< typename T > class Reference;

    template< typename T > 
    std::shared_ptr< Reference<T> >
    makeReferenceHandler(const typename Manipulator<T>::Handler&);

//{{{ Reference
	template<typename T>
	class Reference : public Manipulator<T>
    {
	public:
        typedef typename std::shared_ptr<Reference> Handler;
        
        virtual ~Reference(){}	
       	
        virtual T value(FrameNumber fn) const
        {
            return m_body->value(fn);
        }

        void replace(const typename Manipulator<T>::Handler& body)
        {
            m_body = body;
			mof::state_changed();
        }

    private:
        Manipulator<T>::Handler m_body;

        Reference(const Manipulator<T>::Handler& body) : m_body(body)
        {}
        
        template< typename T >
        friend typename std::shared_ptr< Reference<T> > 
        makeReferenceHandler(const typename Manipulator<T>::Handler&);

	};
//}}}
//{{{ ヘルパ関数
    template<typename T>
    std::shared_ptr< Reference<T> >
    makeReferenceHandler(const typename Manipulator<T>::Handler& body)
    {
	    return typename Reference<T>::Handler(new Reference<T>(body));
    }
//}}}

} // namespace mof
