#pragma once
#include "mof/stream/Manipulator.hpp"

namespace mof{

	template< typename T >
	class Offset : public Manipulator< T >
    {
			
	public:
        typedef typename std::shared_ptr< Offset > Handler;
        
        virtual ~Offset( ){}

		virtual T value( FrameNumber frame ) const
        {
            if( m_offset + frame < 0)return m_pBody->value( 0 );
            else return m_pBody->value( frame + m_offset );
		}


    private:
        typename Manipulator<T>::Handler m_pBody;
		int m_offset;


		Offset( const typename Manipulator<T>::Handler& pBody , int offset )
		: m_pBody(pBody) , m_offset(offset) 
		{
		}

        template<typename T > friend
	    typename std::shared_ptr< Offset< T > > makeOffsetHandler
        (
	    	const typename Manipulator<T>::Handler& pBody ,
	    	int offset
        );

	};


	template< typename T >
	std::shared_ptr< Offset< T > > makeOffsetHandler
    (
		const typename Manipulator< T >::Handler& pBody ,
		int offset
    )
    {
		return typename Offset< T >::Handler(
		        new Offset< T >( pBody , offset )
	        );
	}


} //namespace mof

