#pragma once
#include "mof/KeyFrameAnimation.hpp"
#include "mof/Rectangle.hpp"
#include "mof/Vector2D.hpp"

namespace mof
{
    class BoundsAnimation : public mof::Animation< mof::Rectangle<int> >
    {
    public:

        BoundsAnimation
        (
            const mof::Animation<mof::Vector2D>::Handler& position ,
            const mof::Animation<mof::Vector2D>::Handler& scale 
        )
        : m_position( position) , m_scale( scale )
        {
        }

        mof::Rectangle<int> getValue( mof::FrameNumber frame ) const
        {
            mof::Vector2D position = m_position->getValue( frame );
            mof::Vector2D scale = m_scale->getValue( frame );
            return mof::Rectangle<int>
            (
                position.x , position.y ,
                position.x + scale.x ,
                position.y + scale.y 
            );
        }

    private:

        mof::Animation<mof::Vector2D>::Handler m_position;
        mof::Animation<mof::Vector2D>::Handler m_scale;
    };
}
