#pragma once
#include <dsound.h>
#include "mof/sound/SoundFile.hpp"
#include <boost/thread.hpp>

namespace mof{
	class StreamingSoundLoader
	{
		LPDIRECTSOUNDBUFFER8 m_pBuffer;
		DWORD m_bufferSize;
		HANDLE* m_hEvents;
		SoundFile* m_pResource;
		boost::mutex m_mutex;

	
		//pϐ
		LPDIRECTSOUNDNOTIFY8 m_pNotify;
		void copyBlock(int blockID);
	public:
		StreamingSoundLoader(LPDIRECTSOUNDBUFFER8 m_pBuffer , LPDIRECTSOUNDNOTIFY8 pNotify , SoundFile* pResource );
		StreamingSoundLoader(const StreamingSoundLoader& obj);
		~StreamingSoundLoader(void);
		bool initialize( );
		boost::mutex& getMutex(){return m_mutex;}
		
		void operator()();
	
	};


};
