#ifndef VECTOR2D_HPP
#define VECTOR2D_HPP
#include <mof/real.hpp>
#include <iostream>

namespace mof{

	struct Vector2D
	{
		real x , y;
	
		Vector2D(real x_ , real y_);
		Vector2D(int x_ , int y_);
		Vector2D();
		~Vector2D(void);
	
		mof::Vector2D operator +(const mof::Vector2D& rhs) const;
		mof::Vector2D operator -(const mof::Vector2D& rhs) const;
		mof::Vector2D operator *(float rhs) const;
		mof::Vector2D operator /(float rhs) const;

		bool operator ==(const mof::Vector2D& obj) const;
		bool operator !=(const mof::Vector2D& obj) const;
        mof::Vector2D operator -( ) const;

		friend mof::Vector2D operator *(const mof::Vector2D& vec , real f);
		friend mof::Vector2D operator *(real f ,  const mof::Vector2D & vec);
	    friend std::ostream& operator <<(std::ostream& os , const Vector2D& obj );

	};

}

#endif
