#ifndef MOF_ANIMATION
#define MOF_ANIMATION
#include <boost/utility.hpp>
#include "mof/Color.hpp"
#include "mof/streams.hpp"

namespace mof{

class Light : public  boost::noncopyable{
		
protected:
	mof::Manipulator<mof::Color4f>::Handler m_diffuseColor;
	FrameNumber m_frame;
public:
	typedef std::shared_ptr<Light> ptr;
	Light();
	virtual ~Light();
	virtual void update(){m_frame++;}
	void setDiffuseColor(mof::Color4f color);
	void setDiffuseColor(const mof::Manipulator<mof::Color4f>::Handler& f);

	virtual void setEnable(bool enable) = 0;

};

};

#endif
