#pragma once
#include "mof/Light.hpp"
#include "mof/Color.hpp"
#include "mof/Vector3D.hpp"
#include <mof/stream/Manipulator.hpp>

namespace mof{

	class DirectionalLight : public Light{
		mof::Color m_diffuse;
		mof::Color m_ambient;
		mof::Manipulator<mof::Vector3D>::ptr m_direction;
		mof::frame_t frame_direction_;
	public:
		DirectionalLight();
		DirectionalLight(mof::Color diffuse , mof::Color ambient , mof::Vector3D& direction);
		void setDiffuseColor(mof::Color diffuse){m_diffuse = diffuse;}
		void setAmbientColor(mof::Color ambient){m_ambient = ambient;}
		void setDirection(const mof::Manipulator<mof::Vector3D>::ptr direction)
		{
			m_direction = direction;
			frame_direction_ = 0;
		}
		
		virtual void setEnable(bool enable);
		virtual void update();
		virtual void reflect();

	};

};
