#pragma once
#include "mof/stream/utilities.hpp"
#include <memory>

namespace mof
{
	class Matrix3D;

	class Component3D 
	{
	
	public:
		typedef std::shared_ptr<Component3D> ptr;
		virtual ~Component3D(){}

		virtual const Matrix3DStream& world_transform() const {return world_transform_;}
		virtual Matrix3DStream& world_transform() {return world_transform_;}

	protected:
		Matrix3DStream world_transform_;
		
		Component3D( )
        : 
            world_transform_(makeConstantHandler(Matrix3D::createIdentity()))
        {
        }

	};

}

