#ifndef MOF_CAMERA_HPP
#define mOF_CAMERA_HPP
#include "mof/Vector3D.hpp"
#include "mof/stream/Manipulator.hpp"
#include <boost/scoped_ptr.hpp>
#include "mof/Matrix3D.hpp"


namespace mof{


	class Camera
	{
		struct Impl;
		boost::scoped_ptr<Impl> m_pImpl;

	public:
		typedef std::shared_ptr<Camera> ptr;
		Camera(
			const mof::Manipulator<mof::Vector3D>::Handler& eye , 
			const mof::Manipulator<mof::Vector3D>::Handler& center ,
			const mof::Manipulator<mof::Vector3D>::Handler& up );
		Camera(const mof::Vector3D& eye , const mof::Vector3D& center , const mof::Vector3D& up);
		virtual ~Camera();

		mof::Matrix3D getViewMatrix() const;

		// TODO TypeStreamベースに
		void setEye(const mof::Manipulator<mof::Vector3D>::Handler& eye);
		void setEye(const mof::Vector3D& eye);
		void setCenter(const mof::Manipulator<mof::Vector3D>::Handler& center);
		void setCenter(const mof::Vector3D& center);
		void setUp(const mof::Manipulator<mof::Vector3D>::Handler& up);
		void setUp(const mof::Vector3D& up);

		mof::Vector3D getEye() const; 
		mof::Vector3D getCenter() const; 
		mof::Vector3D getUp() const; 

		virtual void setFrameNumber(mof::FrameNumber frame);
		virtual void update();

	};

}

#endif
