<?php
/**
 * Filename:       includes/lang/japanese-utf8.inc.php
 * Function:       Language file.
 * Encoding:       UTF8
 * Author:         MODx CMS JAPAN
 * Date:           2009/07/31
 * Version:        2.0.3
 * MODx version:   Evolution 1.0
*/
$modx_lang_attribute = 'ja'; // Manager HTML and XML Language Attribute
$modx_manager_charset = 'UTF-8';
define('MAGPIE_OUTPUT_ENCODING', 'UTF-8');

$_lang["about_msg"] = '<p>MODx(モドエックスまたはモッドエックス)は <a href="http://ja.wikipedia.org/wiki/MODx" target="_blank">PHP アプリケーション フレームワーク・コンテンツ管理システム</a>です。<a href="../assets/docs/license.txt">GNU GPL</a> に基づいて使用が許諾されます。</p>';
$_lang["about_title"] = 'MODx について';
$_lang["access_permission_denied"] = 'このリソースにアクセスする権限がありません。';
$_lang["access_permission_parent_denied"] = 'ここにリソースを作成する権限がありません。';
$_lang["access_permissions"] = 'アクセス許可';
$_lang["access_permissions_add_document_group"] = 'リソースグループの作成';
$_lang["access_permissions_add_user_group"] = 'ユーザーグループの作成';
$_lang["access_permissions_docs_collision"] = 'ウェブユーザーグループとマネージャーユーザーグループの設定問題があるため、このリソースは公開されます。詳細については管理者へお問い合わせください。';
$_lang["access_permissions_docs_message"] = 'このリソースを所属させたいリソースグループを選択してください。アクセスを制限する必要がなければ「全リソースグループ」にチェックを入れておきます。';
$_lang["access_permissions_document_groups"] = 'リソースグループ';
$_lang["access_permissions_documents_in_group"] = '<strong>グループ内リソース:</strong> ';
$_lang["access_permissions_documents_tab"] = 'リソースグループの設定を一覧することができます。グループの作成・リネーム・削除もここで操作します。 また、リソースがどのグループに属しているかを閲覧することもできます(リソース名を表示するには、idの上にマウスポインタを乗せてください)。 リソースをグループに追加したり、グループから削除するには、リソースを直接編集してください。';
$_lang["access_permissions_group_link"] = 'グループリンクを新規作成';
$_lang["access_permissions_introtext"] = 'ユーザーグループとリソースグループを管理します。ここでユーザーグループまたはリソースグループを作ると、ユーザ編集画面またはリソース編集画面で所属グループを選択できるようになります。また、ユーザーグループとリソースグループをここで関連付けることができます。つまり誰がどのリソースをという関連付けをここで行ないます。利用できる機能を制限・管理する「ロール」と違い、当機能ではコンテンツ(リソース)対象の権限を管理します。<br /><a href="index.php?a=86">ロール管理</a>とは区別されているため、同じユーザーグループ内に「強い権限を持つユーザー」や「限定された権限を持つユーザー」を自由に混在させることができます。<br />※「ツール」→「グローバル設定」→「詳細設定」の「アクセス権限設定の使用」を「いいえ」にすると、グループ設定を経由しない運用になります。信用できる少数のメンバーでシンプルにサイトを管理運用したい場合は参考にしてください。';
$_lang["access_permissions_link_to_group"] = 'リソースグループ';
$_lang["access_permissions_link_user_group"] = 'ユーザーグループ';
$_lang["access_permissions_links"] = 'グループリンク';
$_lang["access_permissions_links_tab"] = 'リソースグループとユーザーグループを関連付けます。';
$_lang["access_permissions_no_documents_in_group"] = '無し';
$_lang["access_permissions_no_users_in_group"] = '無し';
$_lang["access_permissions_off"] = '<span class="warning">アクセス権限設定(グローバル設定→詳細設定)が無効になっています。</span> This means any changes made here will not have any effect until Access Permissions are activated.';
$_lang["access_permissions_user_groups"] = 'ユーザーグループ:';
$_lang["access_permissions_user_message"] = 'このユーザーを所属させたいユーザーグループを選択してください:';
$_lang["access_permissions_users_in_group"] = '<strong>グループ内ユーザー:</strong> ';
$_lang["access_permissions_users_tab"] = 'ユーザーグループの設定一覧を表示します。グループの作成・リネーム・削除もここで操作します。また、ユーザーがどのグループのメンバーになっているかを閲覧することができます。ユーザーをグループに追加したり、グループから削除するには、個々のユーザー設定を直接編集してください。<br />※管理者(ロールID 1が割り当てられているユーザー)は常に全てのリソースにアクセスすることができるため、管理者をグループに追加する必要はありません。';
$_lang["account_email"] = 'メールアドレス';
$_lang["actioncomplete"] = '<strong>処理が正常に完了しました。</strong><br /> - クリーンアップ処理中です。お待ちください。';
$_lang["activity_message"] = '最近作成または編集したリソース一覧を表示しています:';
$_lang["activity_title"] = '最近編集/作成されたリソース';
$_lang["add"] = '追加';
$_lang["add_chunk"] = 'チャンクの追加';
$_lang["add_doc"] = 'リソースの追加';
$_lang["add_document"] = 'リソースの作成';
$_lang["add_folder"] = 'ディレクトリの作成';
$_lang["add_plugin"] = 'プラグインの追加';
$_lang["add_snippet"] = 'スニペットの追加';
$_lang["add_tag"] = 'タグ追加';
$_lang["add_template"] = 'テンプレートの追加';
$_lang["add_tv"] = 'テンプレート変数の追加';
$_lang["add_weblink"] = 'ウェブリンクの作成';
$_lang["administrator_role_message"] = 'このロールは編集、削除できません。';
$_lang["after_saving"] = '保存後は';
$_lang["alert_delete_self"] = '自分自身を削除することはできません。';
$_lang["alias"] = 'エイリアス';
$_lang["all_doc_groups"] = '全リソースグループ (Public)';
$_lang["all_events"] = '全てのイベント';
$_lang["all_usr_groups"] = '全ユーザーグループ(Public)';
$_lang["allow_mgr_access"] = '管理画面へのアクセス';
$_lang["allow_mgr_access_message"] = 'このオプションは管理画面へのアクセスをユーザーに許可するかしないかを選択するものです。<strong>注意: このオプションを「いいえ」に設定すると、ユーザーは上記の「管理画面ログイン開始ページ」か、それが空白ならサイトスタートのページへリダイレクトされます。</strong>';
$_lang["already_deleted"] = 'は既に削除されています';
$_lang["attachment"] = 'Attachment';
$_lang["automatic_alias_message"] = '「はい」を選択すると、リソースの保存のときリソースのタイトルを元にシステムが自動的にエイリアスを作成します。<br />※日本語環境での使用は推奨しません。';
$_lang["automatic_alias_title"] = 'エイリアス自動生成<br />(日本語環境では推奨しません):';
$_lang["backup"] = 'バックアップ';
$_lang["bk_manager"] = 'バックアップマネージャー';
$_lang["block_message"] = 'データを保存した後、このユーザーのアクセスは拒否されます。';
$_lang["blocked_minutes_message"] = '上記の「ログイン失敗の回数」で指定した回数ログインに失敗したユーザーのアカウントをロックする期間を分単位で指定します。必ず数字のみを入力してください。カンマやスペースも使えません。(※必ず動作確認してください)';
$_lang["blocked_minutes_title"] = 'アカウントロックの時間:';
$_lang["cache_files_deleted"] = '次のファイルが削除されました:';
$_lang["cancel"] = 'キャンセル';
$_lang["captcha_code"] = 'セキュリティコード';
$_lang["captcha_message"] = 'この設定を行うと、機械的(およびscriptkiddyなハッキングスクリプト)に読み取ることのできないコードをユーザーに入力させることで、セキュリティを強化することができます。';
$_lang["captcha_title"] = 'CAPTCHAコードの使用:';
$_lang["captcha_words_message"] = '「CAPTCHAコードの使用」を「はい」にした場合に使用されるCAPTCHAワードリストを入力してください。CAPTCHAワードはカンマで区切って入力します。このフィールドには、255文字まで入力することができます。';
$_lang["captcha_words_title"] = 'CAPTCHA用ワード';
$_lang["captcha_words_default"] = 'isono,fuguta,sazae,masuo,katsuo,wakame,tarao,namihei,fune,tama,mokuzu,umihei,norisuke,taiko,ikura,sakeo,norio,isasaka,hanazawa,hanako,anago';
$_lang["category_heading"] = 'カテゴリー';
$_lang["category_msg"] = '<h3 style="font-weight:bold;">全エレメントの一覧</h3><p>このページではカテゴリーでグループ化したエレメントを一覧・編集できます。</p>';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = '名前の変更';
$_lang["change_password"] = 'パスワードの変更';
$_lang["change_password_confirm"] = 'パスワードをもう一度';
$_lang["change_password_message"] = 'パスワードの長さは6～15文字の間にしてください。';
$_lang["change_password_new"] = '新しいパスワード';
$_lang["charset_message"] = '管理画面で使用したいエンコードを選択できます。この設定は、各種エンコードの扱いとMODxの言語管理構造に習熟しているGeekなユーザ向けに開放しています。設定を変更すると、すでに日本語で入力されているコンテンツや設定は失われる可能性があるため念入りなバックアップをおすすめします。';
$_lang["charset_title"] = 'エンコード:';
$_lang["chunk"] = 'チャンク';
$_lang["chunk_code"] = 'チャンク コード (html)';
$_lang["chunk_multiple_id"] = 'エラー: 複数のチャンクが一つのユニークIDを利用しています。';
$_lang["chunk_no_exist"] = 'チャンクが存在しません。';
$_lang["cleaningup"] = 'クリーンアップ処理中';
$_lang["clear_log"] = 'ログをクリア';
$_lang["click_to_context"] = 'クリックするとコンテキストメニュー';
$_lang["click_to_edit_title"] = '編集はここをクリック';
$_lang["click_to_view_details"] = '詳細を見る';
$_lang["close"] = '閉じる';
$_lang["collapse_tree"] = 'サイトツリーを縮小';
$_lang["comment"] = 'コメント';
$_lang["configcheck_admin"] = 'このメッセージをシステム管理者に報告してください';
$_lang["configcheck_cache"] = 'キャッシュディレクトリに書き込みができません';
$_lang["configcheck_cache_msg"] = 'キャッシュディレクトリにキャッシュファイルを保存できませんでした。MODxは動作しますが、キャッシュが利用できないため、軽快なレスポンスを得られません。この問題を解消するには、 /_cache/ ディレクトリを書き込み可能にしてください。';
$_lang["configcheck_configinc"] = '設定ファイルがまだ書き込み可能になっています';
$_lang["configcheck_configinc_msg"] = '今の状態では、悪意ある人がこのサイトを壊すことができてしまいます。設定ファイル (/manager/includes/config.inc.php)のパーミッションを404などに設定し、書込み不可にしてください。';
$_lang["configcheck_default_msg"] = '不明な警告が見つかりました。';
$_lang["configcheck_errorpage_unavailable"] = '設定した「エラーページ」は利用できません';
$_lang["configcheck_errorpage_unavailable_msg"] = '設定した「エラーページ」が一般的なエンドユーザーからアクセスできないページ（private）かあるいは存在しないことを意味しています。この場合、システムがループ状態に陥り、多くのエラーメッセージをエラーログに記録してしまいます。「エラーページ」には存在するページでかつ、公開ページ、かつ「public」なページを指定してください。';
$_lang["configcheck_errorpage_unpublished"] = 'グローバル設定で設定されたエラーページは公開されていません。';
$_lang["configcheck_errorpage_unpublished_msg"] = '設定したエラーページが誰でも見られるようにはなっていないことを意味します。エラーページは全ての人(Public)に公開するようにしてください。';
$_lang["configcheck_images"] = 'イメージディレクトリに書き込みができません';
$_lang["configcheck_images_msg"] = 'イメージディレクトリが書き込み可能でないか、またはイメージディレクトリが存在していません。エディターの画像管理機能が動作しません';
$_lang["configcheck_installer"] = 'インストーラーが残されています';
$_lang["configcheck_installer_msg"] = 'install/ ディレクトリにMODxのインストーラーが残されています。悪意ある攻撃を受ける可能性がありますので、早急にこのディレクトリを削除してください';
$_lang["configcheck_lang_difference"] = '言語ファイルのエントリー数が異なります';
$_lang["configcheck_lang_difference_msg"] = '現在選択されている言語ファイルのエントリー数がデフォルト言語ファイル(英語)のエントリー数と異なるため、一部が英語で表示されます。日本語で表示したい場合は、最新の言語ファイルを入手しアップデートする必要があります。';
$_lang["configcheck_notok"] = '動作環境に問題があります。';
$_lang["configcheck_ok"] = '確認OK - 警告はありません。';
$_lang["configcheck_register_globals"] = '"register_globals" が "ON" に設定されておりセキュリティ上問題があります。';
$_lang["configcheck_register_globals_msg"] = 'この状態は、クロスサイトスクリプティング攻撃(XSS)を受けやすい脆弱性があります。XSS攻撃はMODx本体に限らず、サードパーティによって開発されるスニペットやプラグインも攻撃対象となります。register_globals on の環境を特に必要としない場合は、.htaccessまたはphp.iniによって OFF にすることを強くおすすめします。';
$_lang["configcheck_title"] = '設定チェック';
$_lang["configcheck_unauthorizedpage_unavailable"] = '「権限外告知のページ」は公開されていないか、存在しません';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = '設定した「権限外告知のページ」が一般的なエンドユーザーからアクセスできないページ（private）かあるいは存在しないことを意味しています。システムがループ状態に陥り、多くのエラーメッセージをエラーログに刻むでしょう。「権限外告知のページ」には存在するページでかつ、公開ページ、かつ「public」なページを指定してください。';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'グローバル設定で設定された権限外告知のページは公開されていません。';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = '設定した権限外告知のページが誰でも見られるようにはなっていないことを意味します。権限外告知ページは全ての人「Public」に公開するようにしてください。';
$_lang["configcheck_warning"] = '警告:';
$_lang["configcheck_what"] = 'どういう意味ですか?';
$_lang["confirm_block"] = 'このユーザーをアクセス拒否してもよろしいですか?';
$_lang["confirm_delete_document"] = 'このリソースを削除してもよろしいですか?\n同時にサブリソースも全て削除されます。';
$_lang["confirm_delete_eventlog"] = 'このログエントリーを削除してもよろしいですか?';
$_lang["confirm_delete_file"] = 'このファイルを削除してもよろしいですか?\n\n削除することでサイトが正常に動作しない場合もあります! 他に影響を及ぼさないことを理解している場合のみ削除してください。';
$_lang["confirm_delete_htmlsnippet"] = 'このチャンクを削除してもよろしいですか?';
$_lang["confirm_delete_keywords"] = 'これらのキーワードを削除してもよろしいですか?';
$_lang["confirm_delete_module"] = 'このモジュールを削除してもよろしいですか?';
$_lang["confirm_delete_plugin"] = 'このプラグインを削除してもよろしいですか?';
$_lang["confirm_delete_record"] = 'このレコードを削除してもよろしいですか?';
$_lang["confirm_delete_role"] = 'このロールを削除してもよろしいですか?';
$_lang["confirm_delete_snippet"] = 'このスニペットを削除してもよろしいですか?';
$_lang["confirm_delete_tags"] = 'このMETAタグを削除してもよろしいですか?';
$_lang["confirm_delete_template"] = 'このテンプレートを削除してもよろしいですか?';
$_lang["confirm_delete_tmplvars"] = 'このテンプレート変数と格納されている値を全て削除してもよろしいですか?';
$_lang["confirm_delete_user"] = 'このユーザーを削除してもよろしいですか?';
$_lang["confirm_duplicate_document"] = 'このリソースを複製してもよろしいですか？配下のリソースも複製されます。';
$_lang["confirm_duplicate_record"] = 'このレコードを複製してもよろしいですか?';
$_lang["confirm_empty_trash"] = '全ての削除済みリソースを完全に消去しますか?\n\n続けますか?';
$_lang["confirm_load_depends"] = '変更を保存せずに「関連付けの管理」画面をロードしてもよろしいですか?';
$_lang["confirm_name_change"] = 'ユーザー名を変更するとMODxにリンクする他のアプリケーションに影響が及ぶ場合があります。 \n\n ほんとうにユーザー名を変更してよろしいですか?';
$_lang["confirm_publish"] = '\n\nこのリソースを公開することで、設定された公開/公開取消日時は上書きされます。公開・公開取消日時をそのままにしたい場合は代わりに「リソースの編集」を選択してください。\n\n続けますか?';
$_lang["confirm_remove_locks"] = '他ユーザーが編集操作を正常に終了しなかったため残されたロックを全て解除します。\n\n続けますか?';
$_lang["confirm_setting_language_change"] = 'You have modified the default value and will lose the changes. Proceed?';
$_lang["confirm_unblock"] = 'このユーザーのアクセス拒否を解除します。';
$_lang["confirm_undelete"] = '\n\nこのリソースと同時に削除されたサブリソースの削除が取り消されます。このリソースの削除以前に削除されたサブリソースは削除されたままです。';
$_lang["confirm_unpublish"] = '\n\nこのリソースの公開を取り消すことで、設定された公開/公開取消日時は上書きされます。公開・公開取消日時をそのままにしたい場合は「リソースの編集」を選択してください。\n\n続けますか?';
$_lang["confirm_unzip_file"] = 'このファイルを解凍してよろしいですか?\n\nすでにあるファイルは上書きされます。';
$_lang["could_not_find_user"] = 'ユーザーが見つかりません';
$_lang["create_document_here"] = 'リソースの作成';
$_lang["create_folder_here"] = 'コンテナの作成';
$_lang["create_resource_title"] = 'リソースの作成';
$_lang["create_weblink_here"] = 'ウェブリンクの作成';
$_lang["createdon"] = '作成日時';
$_lang["credits"] = '著作権表示/謝辞';
$_lang["credits_shouts_msg"] = '<p>MODx is managed and maintained at <a href="http://modxcms.com/about/" target="_blank">MODxCMS.com</a>.</p>';
$_lang["custom_contenttype_message"] = 'リソースが使用するコンテントタイプに独自のタイプを追加できます。新しいタイプを追加するにはテキストボックスに入力して「追加」ボタンをクリックします。';
$_lang["custom_contenttype_title"] = 'カスタムコンテントタイプ:';
$_lang["database_charset"] = 'データベース文字コード';
$_lang["database_collation"] = '文字セット照合順序';
$_lang["database_name"] = 'データベース名';
$_lang["database_overhead"] = '<strong style=\'color:#990033\'>注:</strong>オーバーヘッドとは、確保されているが使われていない領域のことです。オーバーヘッドの数字をクリックすると、この領域を開放します';
$_lang["database_server"] = 'データベースサーバー';
$_lang["database_table_clickbackup"] = '選択したテーブルをバックアップ・ダウンロード';
$_lang["database_table_clickhere"] = 'ここをクリック';
$_lang["database_table_datasize"] = 'データサイズ';
$_lang["database_table_droptablestatements"] = 'DROP文を生成';
$_lang["database_table_effectivesize"] = '有効サイズ';
$_lang["database_table_indexsize"] = 'インデックス';
$_lang["database_table_overhead"] = 'オーバーヘッド';
$_lang["database_table_records"] = '件数';
$_lang["database_table_tablename"] = 'テーブル名';
$_lang["database_table_totals"] = '総計:';
$_lang["database_table_totalsize"] = '合計サイズ';
$_lang["database_tables"] = 'テーブル一覧';
$_lang["database_version"] = 'データベースのバージョン:';
$_lang["date"] = '日付';
$_lang["datechanged"] = '編集日時';
$_lang["datepicker_offset"] = 'デートピッカーオフセット: ';
$_lang["datepicker_offset_message"] = 'デートピッカー(カレンダー)で参照・選択できる過去年数。日付情報は手入力で書き換えることもできるので、この設定は必須ではありません。';
$_lang["datetime_format"] = '日時の書式';
$_lang["datetime_format_message"] = '管理画面内で使用する日時の書式を選択してください。標準のリソース変数では日時情報はUNIXタイムスタンプ値に換算されて格納されるため、当設定は処理結果には影響しません。ただし日時入力タイプのテンプレート変数においては、現在のMODxの仕様ではここで選択した形式のとおりに日時情報が格納されるため注意が必要です。サイトを構築する早い段階で決めておくことをおすすめします。日本国内では通常YYYY/mm/dd形式が利用されます。';
$_lang["defaultcache_message"] = '新しく作成するリソースをデフォルトでキャッシュ可能にする場合は「はい」を選択してください。';
$_lang["defaultcache_title"] = 'キャッシュデフォルト';
$_lang["defaultmenuindex_message"] = 'メニューオーダーを自動的に増分する場合は「はい」を選択してください。';
$_lang["defaultmenuindex_title"] = 'メニューオーダー<br />自動増分';
$_lang["defaultpublish_message"] = '新しく作成するリソースをデフォルトで公開に設定する場合は「はい」を選択してください。';
$_lang["defaultpublish_title"] = '公開デフォルト';
$_lang["defaultsearch_message"] = '新しく作成するリソースをデフォルトで検索対象とする場合は「はい」を選択してください。';
$_lang["defaultsearch_title"] = '検索可能デフォルト';
$_lang["defaulttemplate_message"] = '新規に作成するリソースのデフォルトテンプレートを指定します。テンプレートはリソース単位で自由に選択できます。';
$_lang["defaulttemplate_title"] = 'デフォルトテンプレート';
$_lang["delete"] = '削除';
$_lang["delete_document"] = 'リソースの削除';
$_lang["delete_tags"] = 'タグの削除';
$_lang["deleting_file"] = '「 %s 」の削除: ';
$_lang["description"] = '説明';
$_lang["deselect_keywords"] = 'キーワードの選択解除';
$_lang["deselect_metatags"] = 'METAタグのクリア';
$_lang["disabled"] = '停止';
$_lang["doc_data_title"] = 'リソースの詳細';
$_lang["document"] = 'リソース';
$_lang["document_alias"] = 'エイリアス';
$_lang["document_alias_help"] = "このリソースのエイリアスを指定することができます。フレンドリーURL機能が有効な場合、次のようにリソースにアクセスできます:\n\nhttp://yourserver/エイリアス\n\nリソース変数：[*alias*]";
$_lang["document_content"] = '内容 ( リソース変数：[*content*] )';
$_lang["document_description"] = '説明(description)';
$_lang["document_description_help"] = 'リソースに関する任意の説明をここに入力することができます。リソース変数：[*description*]';
$_lang["document_long_title_help"] = 'ページのタイトルです。titleタグなどで利用します。リソース変数：[*longtitle*]';
$_lang["document_metatag_help"] = 'このリソースに付加したいMETAタグやキーワードを選択してください。CTRLキーを押しながらクリックすると複数のタグやキーワードを選択できます。選択元とするMETAタグ・キーワードの作成・管理は「エレメント」→<a href="index.php?a=81" target="_self">「METAタグとキーワードの管理」</a>で行ないます。';
$_lang["document_opt_contentdispo"] = '内容の配置';
$_lang["document_opt_contentdispo_help"] = 'この内容の配置フィールドを用いてウェブブラウザがこのリソースをどう扱うかを指定できます。「Attachment」を選択するとリソースをダウンロードファイルとみなします。';
$_lang["document_opt_emptycache"] = '更新時にキャッシュをクリア';
$_lang["document_opt_emptycache_help"] = 'このオプションをチェックしておくと、MODxはリソースが保存された直後に自動的にキャッシュをクリアし、次回のアクセスで最新状態を出力します。';
$_lang["document_opt_folder"] = 'コンテナとして扱う';
$_lang["document_opt_folder_help"] = 'このリソースをコンテナとして明示的に扱いたい場合にチェックしてください。通常はサブリソースの有無により自動的に判定されます';
$_lang["document_opt_menu_index"] = 'メニューオーダー';
$_lang["document_opt_menu_index_help"] = 'メニューオーダーは、メニュースニペット内でリソースを並び替えるために使用できます。また、スニペット内で他の目的に使用することもできます。';
$_lang["document_opt_menu_title"] = 'メニュータイトル';
$_lang["document_opt_menu_title_help"] = 'メニュータイトルは、スニペットやモジュールで使用できる短いタイトルです。リソース変数：[*menutitle*]';
$_lang["document_opt_published"] = '公開する';
$_lang["document_opt_published_help"] = '保存後、すぐにリソースを公開する場合はチェックしてください。';
$_lang["document_opt_richtext"] = 'リッチテキストで編集';
$_lang["document_opt_richtext_help"] = '通常の記事を書く場合はここにチェックを入れたままとし、リッチテキストエディターでリソースを編集することをおすすめします。リソースがJavaScriptやフォームを含む場合は、チェックを外してプレーンテキストによる編集を行ってください。';
$_lang["document_opt_show_menu"] = 'メニューに表示';
$_lang["document_opt_show_menu_help"] = 'メニューにこのリソースを表示するにはこのオプションをチェックしてください。メニュー作成スニペットにはこのオプションを無視するものもありますのでご注意ください。';
$_lang["document_opt_trackvisit_help"] = 'このページへの訪問者をログに記録する(対応モジュールが必要)';
$_lang["document_overview"] = 'リソースの詳細';
$_lang["document_parent"] = '親リソース';
$_lang["document_parent_help"] = '上のコンテナアイコンをクリックすると、このリソースの親(コンテナ)を選択できる状態になります。アイコンが点滅している状態で、親にしたいリソースをサイトツリー上でクリックしてください（アイコンの点滅は、再度アイコンをクリックすると元に戻ります）。';
$_lang["document_permissions_error"] = 'このリソースを、少なくともアクセス可能な一つ以上のリソースグループへ割り当ててください。';
$_lang["document_setting"] = 'リソース設定';
$_lang["document_summary"] = '要約（序説）';
$_lang["document_summary_help"] = 'リソースの要約を入力します。リソース変数：[*introtext*]';
$_lang["document_title"] = 'リソース名';
$_lang["document_title_help"] = 'リソースの名称/タイトルを入力してください。バックスラッシュは使用できません。管理画面のサイトツリーで表示されるため短めにするといいでしょう(リソース変数：[*pagetitle*])';
$_lang["document_to_be_moved"] = '移動対象リソース';
$_lang["document_weblink_help"] = 'ウェブリンクで参照したい対象のURLを入力してください。';
$_lang["documents_in_container"] = 'つのサブリソースがあります。';
$_lang["documents_in_container_no"] = 'サブリソースはありません。';
$_lang["duplicate"] = '複製';
$_lang["duplicate_alias_found"] = '\'%s\'というリソースが\'%s\'というエイリアスを既に使用しています。別のエイリアスを入力してください。';
$_lang["duplicate_alias_message"] = '「はい」を選択すると重複するエイリアスを保存できるようになります。エイリアスパス設定を利用する場合はここも「はい」にするのがいいでしょう。';
$_lang["duplicate_alias_title"] = '重複エイリアスを許可:';
$_lang["duplicate_document"] = 'リソースの複製';
$_lang["duplicate_name_found_general"] = '%sには既に\'%s\'という名前が存在しています。ユニークな名前を入力してください。';
$_lang["duplicate_name_found_module"] = 'モジュールには既に\'%s\'という名前が存在しています。ユニークな名前を入力してください。';
$_lang["edit"] = '編集';
$_lang["edit_document"] = 'リソースの編集';
$_lang["edit_document_title"] = 'リソースの作成/編集';
$_lang["edit_settings"] = 'グローバル設定';
$_lang["editedon"] = '編集日時';
$_lang["editing_file"] = 'ファイルの編集: ';
$_lang["editor_css_path_message"] = 'RTE(リッチテキストエディター)で使用するCSSファイルのパスを入力します。例えば「/assets/site/style.css」とします。もしRTEデフォルトの状態でよければ、このフィールドは空白にしておきます。';
$_lang["editor_css_path_title"] = 'CSSファイルへのパス:';
$_lang["email"] = 'メールアドレス';
$_lang["email_sent"] = 'パスワード再発行メールを送信しました。';
$_lang["emailsender_message"] = 'ユーザー名とパスワードを送信時の送信元メールアドレスを指定してください。<br />セッティング変数：[(emailsender)]';
$_lang["emailsender_title"] = '送信者メールアドレス:';
$_lang["emailsubject_default"] = 'ログイン情報のお知らせ';
$_lang["emailsubject_message"] = 'サインアップメールの件名を指定してください。';
$_lang["emailsubject_title"] = 'メール件名:';
$_lang["empty_folder"] = 'このコンテナは空です';
$_lang["empty_recycle_bin"] = '削除済みリソースを消去';
$_lang["empty_recycle_bin_empty"] = '消去するための削除済みリソースがありません。';
$_lang["enable_resource"] = 'エレメントファイルを有効に';//※要確認
$_lang["enable_sharedparams"] = '共有パラメータを使用';
$_lang["enable_sharedparams_msg"] = '<strong>注意:</strong> 上のglobally unique id (GUID)はこのモジュールとその共有パラメータを一意に識別するために用いられます。GUIDは、モジュールと、共有パラメータにアクセスするプラグインやスニペットとの間のリンクにも用いられます。';
$_lang["enabled"] = '有効';
$_lang["error"] = 'エラー';
$_lang["error_sending_email"] = 'メール送信中にエラー';
$_lang["errorpage_message"] = 'リソースが存在しない場合のエラーページ(404 ページ)として表示する、リソースのIDを入力してください。このページは実際にステータスコード404を出力します。<strong>注意: 既に存在するリソースで、かつ公開されている必要があります</strong>';
$_lang["errorpage_title"] = 'エラーページ:';
$_lang["event_id"] = 'イベントID';
$_lang["eventlog"] = 'イベントログ';
$_lang["eventlog_msg"] = 'イベントログはMODxのシステムが出力する告知・警告・エラーの各メッセージを記録するものです。';
$_lang["eventlog_viewer"] = 'イベントログ';
$_lang["existing_category"] = '既存のカテゴリー';
$_lang["expand_tree"] = 'サイトツリーの展開';
$_lang["export_site"] = 'サイトのエクスポート';
$_lang["export_site_cacheable"] = '非キャッシュファイルを含む:';
$_lang["export_site_exporting_document"] = 'エクスポートファイル <strong>%s</strong>個 (<strong>%s</strong>個中)<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = '失敗';
$_lang["export_site_failed_no_open"] = 'ファイルを開けません: ';
$_lang["export_site_failed_no_retrieve"] = 'リソースが見つかりません。';
$_lang["export_site_failed_no_write"] = 'ファイルを書き込めません。';
$_lang["export_site_html"] = 'サイト全体を静的HTMLとしてエクスポート';
$_lang["export_site_maxtime"] = '最大エクスポート時間:';
$_lang["export_site_maxtime_message"] = 'MODxがサイトのエクスポートに使用できる秒数を指定してください(PHPの設定を上書きします)。0の入力で時間無制限に設定します。0または非常に大きな数字を設定することで、サーバーが正常に動作しない場合もありますのでお勧めしません。';
$_lang["export_site_message"] = '<p>サイト全体をHTMLファイルとしてエクスポート(一括書き出し)できます。書き出したファイルをまとめてサーバ上に転送することで、通常のサイトと同様の運用が可能です。この場合、通常の静的サイトの運用と同等になるため、下記の機能が失われます。:</p><ul><li>エクスポートファイルのページ閲覧はログに記録されません。</li><li>エクスポートファイルで動的なスニペットは動作しません。</li><li>通常のリソースのみエクスポートされ、ウェブリンクはエクスポートされません。</li><li>リソースにリダイレクトヘッダを送信するスニペットが含まれている場合、エクスポートプロセスが失敗する場合があります。</li><li>リソース、スタイルシート、イメージの記述方法により、サイトのデザインが崩れる場合があります。これを直すためには、MODxのindex.phpファイルが保存されている同じディレクトリに、エクスポートファイルを保存または移動してください。</li></ul><p>フォームに必要事項を入力して「エクスポートの開始」をクリックすると処理を開始します。作成されたファイルは、リソースエイリアスをファイル名として、指定した場所に保存されます。サイトをエクスポートする場合、グローバル設定で「フレンドリエイリアス」を「はい」にすることをお勧めします。サイトのサイズにより、エクスポートに暫く時間を要する場合もあります。</p><p><em>ファイル名が同じ場合、新しいファイルは既存のファイルに上書きされます</em></p>';
$_lang["export_site_numberdocs"] = '<p><strong>%s 個のエクスポート対象リソースが見つかりました...</strong><p/>';
$_lang["export_site_prefix"] = 'ファイル名の接頭辞:';
$_lang["export_site_start"] = 'エクスポートの開始';
$_lang["export_site_success"] = '成功';
$_lang["export_site_success_skip_dir"] = 'このコンテナをスキップ';
$_lang["export_site_success_skip_doc"] = 'このリソースをスキップ';
$_lang["export_site_suffix"] = 'ファイル名の接尾辞:';
$_lang["export_site_target_unwritable"] = 'ターゲットディレクトリ内に書き込みができません。ディレクトリが書き込み可能であるか確認して、再度処理を行ってください。';
$_lang["export_site_time"] = 'エクスポートが完了しました。エクスポートに要した時間は %s 秒です。';
$_lang["failed_login_message"] = 'ユーザーアカウントがロックされるまで何回ログイン失敗を許すか回数を入力します。';
$_lang["failed_login_title"] = 'ログイン失敗の回数:';
$_lang["fe_editor_lang_message"] = 'フロントエンドエディターとはQuickEdit による内容編集で用いるリッチテキストエディターです。使用するときの言語を選んでください。(※QuickEdit は現在同梱されていません)';
$_lang["fe_editor_lang_title"] = 'フロントエンドエディターの言語:';
$_lang["file_delete_file"] = 'ファイルの削除';
$_lang["file_delete_folder"] = 'ディレクトリの削除';
$_lang["file_deleted"] = '成功';
$_lang["file_download_file"] = 'ファイルのダウンロード';
$_lang["file_download_unzip"] = 'ファイルの解凍';
$_lang["file_folder_chmod_error"] = 'アクセス権の変更が出来ません。MODx 以外の方法でアクセス権を変更してください。';
$_lang["file_folder_created"] = 'ディレクトリを作成しました。';
$_lang["file_folder_deleted"] = 'ディレクトリを削除しました。';
$_lang["file_folder_not_created"] = 'ディレクトリを作成できません';
$_lang["file_folder_not_deleted"] = 'ディレクトリを削除できません。ディレクトリを削除する前に中身が空であることを確認してください。';
$_lang["file_not_deleted"] = '失敗';
$_lang["file_not_saved"] = 'ファイルを保存できません、ターゲットディレクトリが書き込み可能か確認してください。';
$_lang["file_saved"] = 'ファイルが正常に保存されました。';
$_lang["file_unzip"] = '解凍に成功しました。';
$_lang["file_unzip_fail"] = '解凍に失敗しました。';
$_lang["filemanager_path_message"] = 'ここでは<a href="index.php?a=31">「ファイル管理」</a>で扱える範囲を決定します。コンテンツ編集に利用するファイルブラウザと違い、MODxを含めたサイト全体のファイルマネージメントが可能で、デフォルトではドキュメントルートディレクトリの物理パスを指します。IISなど一部のサーバでは物理パスが適切に得られないことがあるためご注意ください。';
$_lang["filemanager_path_title"] = '対象ディレクトリの物理パス:';
$_lang["files_access_denied"] = 'アクセスが拒否されました。';
$_lang["files_data"] = 'データ';
$_lang["files_dir_listing"] = 'ディレクトリ一覧:';
$_lang["files_directories"] = 'ディレクトリ';
$_lang["files_dirwritable"] = 'ディレクトリ書き込み可？';
$_lang["files_editfile"] = 'ファイルの編集';
$_lang["files_file_type"] = 'ファイルタイプ: ';
$_lang["files_filename"] = 'ファイル名';
$_lang["files_fileoptions"] = 'オプション';
$_lang["files_files"] = 'ファイル管理';
$_lang["files_filesize"] = 'ファイルサイズ';
$_lang["files_filetype_notok"] = 'この種類のファイルはアップロードできません。';
$_lang["files_modified"] = '編集日時';
$_lang["files_top_level"] = 'トップレベルへ移動';
$_lang["files_up_level"] = '1レベル上へ移動';
$_lang["files_upload_copyfailed"] = 'アップロード失敗 - コピー先ディレクトリへのファイルコピーが失敗しました';
$_lang["files_upload_error"] = 'エラー';
$_lang["files_upload_error0"] = 'アップロードに問題が発生しました。';
$_lang["files_upload_error1"] = 'アップロードしようとしたファイルは大きすぎます。';
$_lang["files_upload_error2"] = 'アップロードしようとしたファイルは大きすぎます。';
$_lang["files_upload_error3"] = 'アップロードしようとしたファイルは一部分のみアップロードされました。';
$_lang["files_upload_error4"] = 'アップロードするファイルを選択してください';
$_lang["files_upload_error5"] = 'アップロード中に問題が発生しました。';
$_lang["files_upload_inhibited_msg"] = '<strong>アップロード機能が使用できません。</strong> - アップロードがサポートされているか、PHPがディレクトリに書込権を持っているかを確認してください。<br />';
$_lang["files_upload_ok"] = 'ファイルのアップロードが完了しました。';
$_lang["files_upload_permissions_error"] = 'パーミッションエラー - ファイルをアップロードするディレクトリを書き込み可能にしてください。';
$_lang["files_uploadfile"] = 'アップロードを実行';
$_lang["files_uploadfile_msg"] = 'アップロードするファイルを選択してください:';
$_lang["files_uploading"] = '<strong>%s</strong>を<strong>%s/</strong>にアップロードしました。<br />';
$_lang["files_viewfile"] = 'ファイルの表示';
$_lang["folder"] = 'ディレクトリ';
$_lang["forgot_password_email_fine_print"] = '注意：上記のURLは明日あるいは一度パスワード変更をすると無効になります。';
$_lang["forgot_password_email_instructions"] = 'そのページの「私のアカウント」メニューからパスワードを変更することができます。';
$_lang["forgot_password_email_intro"] = 'アカウントへのパスワード変更リクエストを受け付けました。';
$_lang["forgot_password_email_link"] = '処理を完了するためここをクリックしてください。';
$_lang["forgot_your_password"] = 'パスワードを忘れた場合はこちら';
$_lang["friday"] = '金曜';
$_lang["friendly_alias_message"] = 'フレンドリーURLを使用して、かつリソースがエイリアスを持つ場合、エイリアスは常にフレンドリーURLに優先します。このオプションを「はい」に設定することで、フレンドリーURLの接頭辞と接尾辞もエイリアスに適用されます。例えば、リソースのIDが1、エイリアスが「introduction」、接頭辞が「」(空白)、接尾辞が「.html」の場合、このオプションを「はい」にすると、URLは「introduction.html」となります。 エイリアスを設定していない場合は、MODxが「1.html」というリンクを生成します。';
$_lang["friendly_alias_title"] = 'フレンドリエイリアス:';
$_lang["friendlyurls_message"] = '静的URI機能（フレンドリーURL）を有効にします。この機能はMODxがApache上で動作している時のみ有効です。この機能を動作させるためにはMODxインストールディレクトリのht.accessファイルを.htaccessにリネームしてください。動作しない場合は.htaccessを開いて、コメントアウトされている「Options +FollowSymlinks」の記述を有効にしてみてください。';
$_lang["friendlyurls_title"] = 'フレンドリーURLの使用:';
$_lang["friendlyurlsprefix_message"] = 'ユーザーフレンドリーURLの接頭辞を指定してください。例えば接頭辞を「page」に設定した場合、URLの /index.php?id=2 は、 /page2.htmlというユーザーフレンドリーURLに変換されます(接尾辞が .htmlに設定されていると仮定して)。このように、ユーザー(そしてサーチエンジン)が、サイトを閲覧するためのリンクを指定することができます。';
$_lang["friendlyurlsprefix_title"] = 'フレンドリーURLの接頭辞:';
$_lang["friendlyurlsuffix_message"] = 'ユーザーフレンドリーURLの接尾辞を指定してください。例えば「.html」と指定すると、全てのユーザーフレンドリーURLの末尾に .htmlを追加します。';
$_lang["friendlyurlsuffix_title"] = 'フレンドリーURLの接尾辞:';
$_lang["functionnotimpl"] = '未実装の機能';
$_lang["functionnotimpl_message"] = 'この機能は、まだ実装されていません';
$_lang["go"] = '実行';
$_lang["group_access_permissions"] = 'ユーザーグループのアクセス';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'ヘルプ';
$_lang["help_msg"] = '<p><a href="http://modxcms-jp.com/bb/" target="_blank">MODx日本公式フォーラム</a>にてコミュニティによるサポートが得られます。 また、逐次執筆が進められている<a href="http://modxcms.com/documentation" target="_blank">MODxドキュメントとガイド（英語）</a>があり、MODx のほぼすべてに関して記されています。</p> <p>また、MODxの有償サポートサービスの提供が計画されています(※ただし現時点では英語圏)。興味がある方は<a href="mailto:modx@vertexworks.com?subject=MODx Commercial Support Inquiry">email</a>にてお問い合わせください。</p>';
$_lang["help_title"] = 'サポート';
$_lang["hide_tree"] = 'サイトツリーを非表示';
$_lang["home"] = 'ダッシュボード';
$_lang["htmlsnippet_desc"] = 'チャンクの説明';
$_lang["htmlsnippet_management_msg"] = '<h3 style="font-weight:bold;">チャンクの管理</h3><p>編集したいチャンクを選択してください。チャンクは、パーツ感覚で利用できる「生の」HTMLコードです。リソースやテンプレートから手軽に呼び出すことができます。PHPコードを記述する場合はスニペットを利用してください。</p>';
$_lang["htmlsnippet_msg"] = 'チャンクを追加・編集することができます。チャンクは、パーツ感覚で利用できる「生の」HTMLコードです。リソースやテンプレートから手軽に呼び出すことができます。PHPコードを記述する場合はスニペットを利用してください。';
$_lang["htmlsnippet_name"] = 'チャンク名';
$_lang["htmlsnippet_title"] = 'チャンクの作成/編集';
$_lang["icon"] = 'Icon';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = '親の指定:\n\nリソースは選択リソースのサブリソースです。';
$_lang["illegal_parent_self"] = '親の指定:\n\n自分自身を親に割り当てることはできません。';
$_lang["import_files_found"] = '<strong>インポートする %s個のリソースを見つけました...</strong><p/>';
$_lang["import_params"] = '共有パラメータのインポート';
$_lang["import_params_msg"] = 'ドロップダウンメニューからモジュール名を選択することにより、他のモジュールのパラメータや設定をインポートすることができます。 <strong>注意:</strong>メニューにモジュールが表示されるためには、このプラグインやスニペットが該当モジュールの関連付けリストにありモジュールの共有パラメータ使用がONである必要があります。 ';
$_lang["import_parent_document"] = '親リソース:';
$_lang["import_site"] = 'サイトのインポート';
$_lang["import_site_failed"] = '失敗しました';
$_lang["import_site_failed_db_error"] = 'リソースの複製中にデータベースエラーが発生しました: ';
$_lang["import_site_failed_no_open_dir"] = 'ディレクトリを開けませんでした: ';
$_lang["import_site_failed_no_retrieve_file"] = 'ファイルが見つかりませんでした: ';
$_lang["import_site_html"] = 'HTMLからサイトをインポート';
$_lang["import_site_importing_document"] = 'インポート中のファイル <strong>%s</strong> ';
$_lang["import_site_maxtime"] = 'インポート時間の上限:';
$_lang["import_site_maxtime_message"] = 'MODxがサイトのインポート処理に使用できる最大秒数を指定します。（PHPの指定処理秒数を上書きします）0は処理時間の制限なしを意味します。0や大きな数字を指定することはサーバーに負荷をかけ問題を起こしやすくなるため、お勧めできません。';
$_lang["import_site_message"] = 'この機能を使うと、HTMLで記述されたサイトを丸ごとデータベースにインポートすることができます。まずインポートするファイルやディレクトリをassets/importディレクトリにコピーして置きます。<p />「インポート開始」ボタンをクリックすればスタートします。インポートしたファイルのデータはサイトツリーの選択した場所に格納されます。ファイル名はエイリアスになり、ページタイトルはリソースのタイトルになります。';
$_lang["import_site_skip"] = '処理をスキップしました';
$_lang["import_site_start"] = 'インポート開始';
$_lang["import_site_success"] = '成功';
$_lang["import_site_time"] = 'インポート終了。インポートには %s 秒かかりました。';
$_lang["inbox"] = '受信トレイ';
$_lang["info"] = '情報';
$_lang["information"] = '情報';
$_lang["inline"] = 'インライン';
$_lang["insert"] = '挿入';
$_lang["keyword"] = 'キーワード';
$_lang["keywords"] = 'キーワード';
$_lang["keywords_intro"] = 'キーワードを編集するには変更したいキーワードの隣のテキストエリアに新しいキーワードを入力するだけです。キーワードを削除するにはキーワードの削除チェックボックスをチェックします。';
$_lang["language_message"] = '管理画面の使用言語を選択してください。必ず「エンコード」の設定と合わせてください。';
$_lang["language_title"] = '言語:';
$_lang["launch_site"] = 'サイトを表示';
$_lang["link_attributes"] = 'リンク属性';
$_lang["link_attributes_help"] = "このページ内の任意のリンクの属性をまとめて管理できます。\n\n例：target=&quot;_blank&quot; ・rel=&quot;lightbox&quot;\nリソース変数：[*link_attributes*]\n\n※この変数はリンクの属性を管理するための特別な機能を持っていないので、他の用途に流用することもできます。";
$_lang["list_mode"] = 'リストモードのON/OFF - グリッドに全てのレコードをリストするために使われます。';
$_lang["loading_doc_tree"] = 'サイトツリーのローディング中 ...';
$_lang["loading_menu"] = 'メニューのローディング中 ...';
$_lang["loading_page"] = 'MODxはページをロードしています。お待ちください ...';
$_lang["localtime"] = 'ローカル時刻';
$_lang["lock_htmlsnippet"] = 'チャンクの編集をロック';
$_lang["lock_htmlsnippet_msg"] = '管理者(ロールID 1)のみ編集できます。';
$_lang["lock_module"] = 'モジュールをロック';
$_lang["lock_module_msg"] = '管理者(ロールID 1)のみ編集できます。';
$_lang["lock_msg"] = '%s が %s を今編集中です。他のユーザーが終了するまでしばらくお待ちの上再度操作願います。';
$_lang["lock_plugin"] = 'プラグインをロック';
$_lang["lock_plugin_msg"] = '管理者(ロールID 1)のみ編集できます。';
$_lang["lock_settings_msg"] = '%s が設定を編集中です。他のユーザーが終了するまでしばらくお待ちください。';
$_lang["lock_snippet"] = 'スニペットをロック';
$_lang["lock_snippet_msg"] = '管理者(ロールID 1)のみ編集できます。';
$_lang["lock_template"] = 'テンプレートの編集をロック';
$_lang["lock_template_msg"] = '管理者(ロールID 1)のみ編集できます。';
$_lang["lock_tmplvars"] = '変数をロック';
$_lang["lock_tmplvars_msg"] = '管理者(ロールID 1)のみ編集できます。';
$_lang["locked"] = 'ロック';
$_lang["login_allowed_days"] = '曜日制限';
$_lang["login_allowed_days_message"] = 'このユーザーがログインできる曜日を選択してください';
$_lang["login_allowed_ip"] = 'IPアドレス制限';
$_lang["login_allowed_ip_message"] = 'このユーザーがログインできるIPアドレスを入力してください。 <strong>注意: 複数のIPアドレスの場合はカンマ(,)で区切ってください</strong>';
$_lang["login_button"] = 'ログイン';
$_lang["login_cancelled_install_in_progress"] = 'このサイトは、現在アップデートまたはインストール作業中です。<br />申し訳ありませんが、しばらく経ってからもう一度ログインしてください。<br />';
$_lang["login_cancelled_site_was_updated"] = 'このサイトは、アップデートまたはインストールが実行されしまた。申し訳ありませんが、もう一度ログインし直してください。<br />';
$_lang["login_captcha_message"] = '画像で表示されるセキュリティコードを入力してください。セキュリティコードが読めない場合は画像をクリックすると画像は再生成されます。もしくはサイト管理者に連絡をお願います。';
$_lang["login_homepage"] = 'ログインするホームページ';
$_lang["login_homepage_message"] = 'ログインしたウェブユーザーに対して表示するリソースのIDを入力してください。 <strong>注意: 入力するIDは既に存在するリソースのものでないといけません。また公開中でしかもユーザーがアクセス可能であるものに限ります!</strong>';
$_lang["login_message"] = 'MODxへようこそ。ユーザー名とパスワードは大文字・小文字を区別します。';
$_lang["logo_slogan"] = 'MODx Content Manager - \nCreate and do more with less';
$_lang["logout"] = 'ログアウト';
$_lang["long_title"] = 'タイトル';
$_lang["mail_check_timeperiod_message"] = '<a href="index.php?a=10">メッセージ機能</a>のメッセージチェックの間隔を「秒」で指定します';
$_lang["mail_check_timeperiod_title"] = 'メッセージチェックの間隔:';
$_lang["manage_depends"] = '関連付けの管理';
$_lang["manage_files"] = 'ファイル管理';
$_lang["manage_htmlsnippets"] = 'チャンク';
$_lang["manage_metatags"] = 'METAタグとキーワードの管理';
$_lang["manage_modules"] = 'モジュールの管理';
$_lang["manage_plugins"] = 'プラグイン';
$_lang["manage_snippets"] = 'スニペット';
$_lang["manage_templates"] = 'テンプレート';
$_lang["manager"] = '管理画面';
$_lang["manager_lockout_message"] = '管理画面にログインしています。セッションを閉じたいときは「ログアウト」ボタンをクリックしてください。<p />管理画面のホームあるいはスタート画面に行きたいときは「ホーム」ボタンをクリックします。';
$_lang["manager_permissions"] = '管理画面のアクセス許可';
$_lang["manager_theme"] = '管理画面のテーマ:';
$_lang["manager_theme_message"] = '管理画面で使用するデザインテーマを選択してください。この選択肢を増やすには<a href="http://modxcms.com/extras/repository/packages/?repository=7" target="_blank">MODx開発元の配布ページ</a>から入手して /manager/media/style/ ディレクトリに置く必要があります。';
$_lang["messages"] = 'メッセージ';
$_lang["messages_all"] = '全員';
$_lang["messages_compose"] = 'メッセージの作成';
$_lang["messages_forward"] = '転送';
$_lang["messages_from"] = 'From';
$_lang["messages_group"] = 'グループ';
$_lang["messages_inbox"] = '受信トレイ';
$_lang["messages_message"] = 'メッセージ';
$_lang["messages_no_messages"] = '受信トレイにメッセージはありません。';
$_lang["messages_not_allowed_to_read"] = 'このメッセージを読むことはできません。';
$_lang["messages_private"] = 'プライベート';
$_lang["messages_read_message"] = 'メッセージを読む';
$_lang["messages_reply"] = '返信';
$_lang["messages_select_group"] = 'グループを選択';
$_lang["messages_select_user"] = 'ユーザーを選択';
$_lang["messages_send"] = '送信';
$_lang["messages_send_to"] = '送信先';
$_lang["messages_sent"] = '送信日時';
$_lang["messages_subject"] = '件名';
$_lang["messages_system_user"] = '[System]';
$_lang["messages_title"] = 'メッセージ';
$_lang["messages_user"] = 'ユーザー';
$_lang["meta_keywords"] = 'METAタグ';
$_lang["metatag_intro"] = 'METAタグの作成や削除、編集を行います。リソースとMETAタグをリンクするにはリソースの編集中にMETA キーワードタブをクリックします。そして目的とするMETAタグとキーワードを選択します。新しいタグを追加するには、その名前と値を入力して「タグ追加」ボタンをクリックします。タグを編集するにはデータグリッド中のタグ名をクリックします。';
$_lang["metatag_notice"] = 'METAタグに関しての詳細は<a href="http://www.google.com/search?q=%22META%E3%82%BF%E3%82%B0%22" target="_blank">こちら</a>を参照してください。';
$_lang["metatags"] = 'METAタグ';
$_lang["mgr_access_permissions"] = '管理画面へのアクセス許可';
$_lang["mgr_login_start"] = '管理画面ログイン開始ページ';
$_lang["mgr_login_start_message"] = 'ユーザーが管理画面にログインしたとき、リダイレクトしたいリソースのIDを入力します。<strong>注意: 入力するIDは、既に存在するリソースIDであり、リソースは公開されていてこのユーザーがアクセス可能である必要があります!</strong>';
$_lang["mgrlog_action"] = 'アクション';
$_lang["mgrlog_actionid"] = 'ID';
$_lang["mgrlog_anyall"] = '全て';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() で誤りを検出しました。';
$_lang["mgrlog_datefr"] = 'この日付から';
$_lang["mgrlog_dateinvalid"] = '日付の形式が正しくありません。';
$_lang["mgrlog_dateto"] = 'この日付の前';
$_lang["mgrlog_emptysrch"] = 'この問合せの結果は空でした。（マッチするログエントリーが無かったということです）';
$_lang["mgrlog_field"] = '分類';
$_lang["mgrlog_itemid"] = '対象ID';
$_lang["mgrlog_itemname"] = '対象名';
$_lang["mgrlog_msg"] = 'メッセージ';
$_lang["mgrlog_noquery"] = '検索されていません。';
$_lang["mgrlog_qresults"] = '結果';
$_lang["mgrlog_query"] = 'ログの検索';
$_lang["mgrlog_query_msg"] = '管理画面の操作履歴に対する検索条件を指定します。日付の条件指定は、「以上」「未満」です。<br /><br />メッセージとアクションはほぼ同じものです。何かのメッセージを探したいときは、アクションを「全て」のままにしておくとよいでしょう。';
$_lang["mgrlog_results"] = '結果の件数';
$_lang["mgrlog_searchlogs"] = '検索の履歴';
$_lang["mgrlog_sortinst"] = '各列のヘッダをクリックすると表の表示順を変更できます。ログが溜まってきたときには、<a href="index.php?a=55">empty</a> をクリックすることでログを全部消去できます。 この操作は即実行され元に戻せません。';
$_lang["mgrlog_time"] = '時刻';
$_lang["mgrlog_user"] = 'ユーザー';
$_lang["mgrlog_username"] = 'ユーザー名';
$_lang["mgrlog_value"] = '値';
$_lang["mgrlog_view"] = '管理操作ログを見る';
$_lang["module_code"] = 'モジュール コード(php)';
$_lang["module_config"] = 'モジュール設定';
$_lang["module_desc"] = '説明';
$_lang["module_disabled"] = 'モジュールを停止';
$_lang["module_edit_click_title"] = 'このモジュールを編集';
$_lang["module_group_access_msg"] = '管理画面内でこのモジュールを実行できるユーザーグループを選択してください。';
$_lang["module_management"] = 'モジュール管理';
$_lang["module_management_msg"] = '実行や変更をしたいモジュールを選択します。モジュールを実行するにはグリッドの中のアイコンをクリックしてください。モジュールを変更するにはモジュール名をクリックしてください。';
$_lang["module_msg"] = 'ここでモジュールの追加・編集ができます。モジュールは任意のエレメントの機能を管理するためのインターフェイスです。多くの場合、実際の機能はプラグインやスニペット側で実装します。';
$_lang["module_name"] = 'モジュール名';
$_lang["module_resource_msg"] = 'このモジュールに関連付けるエレメントを追加・削除します。新しいエレメントを追加するには下のボタンのひとつをクリックします。';
$_lang["module_resource_title"] = 'モジュール関連付け';
$_lang["module_title"] = 'モジュールの作成/編集';
$_lang["module_viewdepend_msg"] = 'このモジュールが管理するエレメントの状況を見ることができます。関連付けを変更するには「関連付けの管理」ボタンをクリックします';
$_lang["modules"] = 'モジュール';
$_lang["modx_news"] ='MODxの最新情報';
$_lang["modx_news_tab"] ='MODxの最新情報';
$_lang["modx_news_title"] ='MODxの最新情報';
$_lang["modx_security_notices"] ='MODx セキュリティ情報';
$_lang["modx_version"] = 'MODxバージョン';
$_lang["monday"] = '月曜';
$_lang["move"] = '移動';
$_lang["move_document"] = 'リソースの移動';
$_lang["move_document_message"] = 'サイトツリー内の新しい親リソースを選択して、リソースをサブリソースごと移動することができます。コンテナではないリソースを親リソースとして選択した場合、リソースはコンテナに変更されます。 サイトツリー内の新しい親リソースをクリックしてください。';
$_lang["move_document_new_parent"] = '新しい親リソースをサイトツリーから選択してください';
$_lang["move_document_title"] = 'リソースの移動';
$_lang["name"] = '名前';
$_lang["new_category"] = 'カテゴリー作成';
$_lang["new_file_permissions_message"] = '管理画面を通じて新しいファイルをアップロードしたとき、ここで設定したパーミッションに変更します。この機能はIIS上など一部の環境では動作しません。';
$_lang["new_file_permissions_title"] = '新ファイルのアクセス許可';
$_lang["new_folder_permissions_message"] = '管理画面を通じて新しいディレクトリを作成したとき、ここで設定したパーミッションに変更します。この機能はIIS上など一部の環境では動作しません。';
$_lang["new_folder_permissions_title"] = '新ディレクトリのアクセス許可';
$_lang["new_htmlsnippet"] = 'チャンクの作成';
$_lang["new_keyword"] = 'キーワードの追加:';
$_lang["new_module"] = 'モジュールの作成';
$_lang["new_parent"] = '新しい親リソース';
$_lang["new_plugin"] = 'プラグインの作成';
$_lang["new_role"] = 'ロールの作成';
$_lang["new_snippet"] = 'スニペットの作成';
$_lang["new_template"] = 'テンプレートの作成';
$_lang["new_tmplvars"] = 'テンプレート変数の作成';
$_lang["new_user"] = 'ユーザーの作成';
$_lang["new_web_user"] = 'ウェブユーザーの作成';
$_lang["no"] = 'いいえ';
$_lang["no_active_users_found"] = '有効なユーザーが見つかりませんでした。';
$_lang["no_activity_message"] = 'まだリソースを作成または編集していません。';
$_lang["no_category"] = 'カテゴリーなし';
$_lang["no_docs_pending_publishing"] = '公開を予定しているリソースはありません。';
$_lang["no_docs_pending_pubunpub"] = 'イベントはありません';
$_lang["no_docs_pending_unpublishing"] = '公開取り消しを予定しているリソースはありません。';
$_lang["no_edits_creates"] = '最近作成または編集したリソースはありません。';
$_lang["no_groups_found"] = 'グループが見つかりません。';
$_lang["no_keywords_found"] = 'キーワードはありません';
$_lang["no_records_found"] = 'レコードはありません。';
$_lang["no_results"] = '結果がありません';
$_lang["nologentries_message"] = '<a href="index.php?a=13">管理操作ログ</a>閲覧時、1ページあたりに表示されるログエントリー数を入力してください。';
$_lang["nologentries_title"] = 'ログエントリー数:';
$_lang["nomessages_message"] = 'メッセージ閲覧時、受信ボックスに表示されるメッセージ数を入力してください。';
$_lang["nomessages_title"] = 'メッセージ数:';
$_lang["none"] = 'なし';
$_lang["noresults_message"] = 'リスト表示や検索結果の表示の際にデータグリッドに何件表示するかここにその数を入力してください。';
$_lang["noresults_title"] = '結果の件数:';
$_lang["not_deleted"] = 'は削除されていません';
$_lang["not_set"] = '設定なし';
$_lang["offline"] = 'オフライン';
$_lang["online"] = 'オンライン';
$_lang["onlineusers_action"] = 'アクション';
$_lang["onlineusers_actionid"] = 'ID';
$_lang["onlineusers_ipaddress"] = 'IPアドレス';
$_lang["onlineusers_lasthit"] = '最終アクセス';
$_lang["onlineusers_message"] = '直近20分以内のアクティブなユーザー一覧を表示しています。(現在時刻 ';
$_lang["onlineusers_title"] = 'オンラインユーザー';
$_lang["onlineusers_user"] = 'ユーザー';
$_lang["onlineusers_userid"] = 'ユーザーID';
$_lang["optimize_table"] = 'このテーブルを最適化するにはここをクリック';
$_lang["page_data_cacheable"] = 'キャッシュを生成';
$_lang["page_data_cacheable_help"] = 'このフィールドをチェックすることにより、リソースがキャッシュに保存されることを許可します。リソースにスニペットが含まれている場合は、必ずチェックを外してください。または、チェックを入れたままでスニペットコールの書式を[!xxxxx!]とする方法もあります。詳しくはヘルプをご覧ください。';
$_lang["page_data_cached"] = '<strong>キャッシュより抽出したソース:</strong>';
$_lang["page_data_changes"] = '編集履歴';
$_lang["page_data_contentType"] = 'コンテントタイプ';
$_lang["page_data_contentType_help"] = 'このリソースのコンテントタイプを選択してください。コンテントタイプが分からない場合は、通常のWebページを意味するtext/htmlのままにしてください。';
$_lang["page_data_created"] = '作成日時';
$_lang["page_data_edited"] = '編集日時';
$_lang["page_data_editor"] = 'リッチテキストエディターを使用';
$_lang["page_data_folder"] = 'コンテナ';
$_lang["page_data_general"] = '概要';
$_lang["page_data_markup"] = 'マークアップ/構造';
$_lang["page_data_mgr_access"] = '管理画面からアクセス';
$_lang["page_data_notcached"] = 'このリソースは、まだキャッシュされていません。';
$_lang["page_data_publishdate"] = '公開開始日時';
$_lang["page_data_publishdate_help"] = '公開日時を設定した場合、リソースは公開日時の到来と共に公開されます。入力フィールドをクリックして公開日時を選択するか(※カレンダーが表示されますが手入力もできます)、カレンダーアイコンの隣のアイコンをクリックして公開日時を削除してください。公開日時を削除するとリソースは自動的には公開されません。';
$_lang["page_data_published"] = '公開';
$_lang["page_data_searchable"] = '検索対象に含める';
$_lang["page_data_searchable_help"] = 'このフィールドをチェックすることにより、リソースを検索対象にします。このフィールドをスニペット内で別の目的に使用することもできます。';
$_lang["page_data_source"] = 'ソース';
$_lang["page_data_status"] = 'ステータス';
$_lang["page_data_template"] = '使用テンプレート';
$_lang["page_data_template_help"] = 'このリソースが使用するテンプレートを選択してください。';
$_lang["page_data_title"] = 'ページデータ';
$_lang["page_data_unpublishdate"] = '公開取消日時';
$_lang["page_data_unpublishdate_help"] = '非公開日時を設定した場合、非公開日時の到来と共にリソースの公開が取り消されます。カレンダーアイコンをクリックして非公開日時を選択するか、カレンダーアイコンの隣のアイコンをクリックして非公開日時を削除してください。非公開日時を削除すると、リソースの公開取消は自動的には行われません。';
$_lang["page_data_unpublished"] = '非公開';
$_lang["page_data_web_access"] = 'ウェブからアクセス';
$_lang["pagetitle"] = 'リソースタイトル';
$_lang["pagination_table_first"] = '先頭';
$_lang["pagination_table_gotopage"] = 'ページへ';
$_lang["pagination_table_last"] = '最後';
$_lang["paging_first"] = '先頭';
$_lang["paging_last"] = '最後';
$_lang["paging_next"] = '次へ';
$_lang["paging_prev"] = '前へ';
$_lang["paging_showing"] = '表示対象：';
$_lang["paging_to"] = 'から';
$_lang["paging_total"] = '(トータル)';
$_lang["parameter"] = 'パラメータ';
$_lang["password"] = 'パスワード';
$_lang["password_change_request"] = 'パスワード変更リクエスト';
$_lang["password_gen_gen"] = 'MODxにパスワードを生成させる。';
$_lang["password_gen_length"] = 'パスワードは少なくとも6文字以上の長さにしてください。';
$_lang["password_gen_method"] = 'どのようにパスワードを作成しますか?';
$_lang["password_gen_specify"] = 'パスワードを指定する:';
$_lang["password_method"] = 'どのようにパスワードを通知しますか?';
$_lang["password_method_email"] = '新しいパスワードをメールで通知する。';
$_lang["password_method_screen"] = '新しいパスワードを画面に表示する。';
$_lang["password_msg"] = '<strong>%s</strong>の新しいパスワードは<strong>%s</strong>です。';
$_lang["php_version_check"] = 'MODxはPHPバージョン4.0.3またはそれ以上で動作します。インストールされているPHPをアップグレードしてください。';
$_lang["plugin"] = 'プラグイン';
$_lang["plugin_code"] = 'プラグイン コード (php)';
$_lang["plugin_config"] = 'プラグイン設定';
$_lang["plugin_desc"] = '説明';
$_lang["plugin_disabled"] = 'プラグインの停止';
$_lang["plugin_event_msg"] = 'このプラグインが使用するイベントを選択してください。';
$_lang["plugin_management_msg"] = '<h3 style="font-weight:bold;">プラグインの管理</h3><p>編集したいプラグインを選択します。</p>';
$_lang["plugin_msg"] = 'プラグインの追加や編集をすることができます。プラグインは選択したシステムイベントの発生時に実行されるPHPのコード群です。';
$_lang["plugin_name"] = 'プラグイン名';
$_lang["plugin_priority"] = 'イベント発生時のプラグインの実行順を編集';
$_lang["plugin_priority_instructions"] = 'プラグインの実行順を変更するには、各イベント名の下にあるプラグインをドラッグしてください。最初に実行するプラグインは最上位にしてください。';
$_lang["plugin_priority_title"] = 'プラグインの実行順';
$_lang["plugin_title"] = 'プラグインの作成/編集';
$_lang["preview"] = 'プレビュー';
$_lang["preview_document"] = 'プレビュー(別窓)';
$_lang["preview_msg"] = 'ここには最後に保存した内容をプレビューしています。<a href="#" onclick="saveRefreshPreview();"><img src="media/images/icons/save.gif" align="absmiddle" height="12"> 保存と再描画</a>を行うにはここをクリックしてください。';
$_lang["private"] = 'プライベート';
$_lang["public"] = 'パブリック';
$_lang["publish_date"] = '公開日付';
$_lang["publish_document"] = 'リソースの公開';
$_lang["publish_events"] = '公開予定リソースの一覧';
$_lang["rb_base_dir_message"] = 'ファイルブラウザディレクトリ(アセットディレクトリ)への物理パスを入力してください。通常この設定は自動的に生成されますが、IISなど一部のサーバでは正常に検出されないことがあります。その場合は手入力で入力してください。';
$_lang["rb_base_dir_title"] = 'ファイルベースパス:';
$_lang["rb_base_url_message"] = 'ファイルディレクトリ(通常はassetsディレクトリ)への仮想パスを入力してください。MODx設置ディレクトリを基準とした相対パスまたはhttp://から始まるフルパスを記述します。通常この設定は自動的に生成されますが、IISなど一部のサーバでは正常に検出されないことがあります。';
$_lang["rb_base_url_title"] = 'ファイルブラウザURL:';
$_lang["rb_message"] = '「はい」を選択するとファイルブラウザを使用できます。ファイルブラウザは投稿画面から呼び出します。サーバー上の画像やFlashなどのファイルをアップロード・選択し、投稿画面に貼り付けることができます。';
$_lang["rb_title"] = 'ファイルブラウザを使用:';
$_lang["rb_webuser_message"] = '<a href="index.php?a=99">ウェブユーザー</a>にファイルブラウザの利用を許可するかどうかを選択します。<br /><strong>警告:</strong> ウェブユーザーにファイルブラウザの利用を許可するということは、管理画面ユーザーが利用するファイルを見せることになります。信用できるウェブユーザーにのみ許可するべきでしょう。';
$_lang["rb_webuser_title"] = 'ウェブユーザーの<br />ファイルブラウザ利用';
$_lang["recent_docs"] = '最近のリソース';
$_lang["refresh_cache"] = 'キャッシュ: キャシュディレクトリに <strong>%s</strong>個のキャッシュファイルが見つかりました。<strong>%d</strong>個のキャッシュファイルが削除されました。<p>ページがリクエストされた時点で、新しいキャッシュファイルが生成されます。';
$_lang["refresh_published"] = '<strong>%s</strong>件のリソースが公開されました。';
$_lang["refresh_site"] = 'キャッシュをクリア';
$_lang["refresh_title"] = 'サイトのリフレッシュ';
$_lang["refresh_tree"] = 'サイトツリーの再描画';
$_lang["refresh_unpublished"] = '<strong>%s</strong>件のリソースの公開が取り消されました。';
$_lang["remember_username"] = 'ログイン情報を記憶する';
$_lang["remove"] = '削除';
$_lang["remove_date"] = '日付を削除';
$_lang["remove_locks"] = 'ロックの解除';
$_lang["rename"] = 'リネーム';
$_lang["reports"] = 'レポート';
$_lang["require_tagname"] = 'タグ名が必要です。';
$_lang["require_tagvalue"] = 'タグの値が必要です';
$_lang["reset"] = 'リセット';
$_lang["reset_failedlogins"] = 'リセット';
$_lang["resolve_hostnames_message"] = '訪問者がこのサイトを訪れた時、MODxでIPアドレスからホスト名への解決を行いますか? ホスト名の解決を行うことによりサーバーの負荷が多少増加します。しかし、ビジターがこのことに気付くことはありません。';
$_lang["resolve_hostnames_title"] = 'ホスト名の解決';
$_lang["resource"] = 'エレメント';
$_lang["resource_categories"] = 'エレメント一覧';
$_lang["resource_management"] = 'エレメント管理';
$_lang["resource_name"] = 'エレメント名';
$_lang["resource_selector_msg"] = '下のリストからエレメントを選択して「挿入」ボタンをクリックします。';
$_lang["resource_selector_title"] = 'エレメントセレクタ';
$_lang["resources"] = 'エレメント';
$_lang["role"] = 'ロール(役割)';
$_lang["role_about"] = '「MODxについて」ページの表示';
$_lang["role_access_persmissions"] = 'アクセス許可';
$_lang["role_actionok"] = '処理完了ページの表示';
$_lang["role_bk_manager"] = 'バックアップマネージャーの使用';
$_lang["role_cache_refresh"] = 'キャッシュをクリア';
$_lang["role_change_password"] = 'パスワードの変更';
$_lang["role_chunk_management"] = 'チャンクの管理';
$_lang["role_config_management"] = '設定管理';
$_lang["role_content_management"] = 'コンテンツ管理';
$_lang["role_create_chunk"] = 'チャンクの作成';
$_lang["role_create_doc"] = 'リソースの作成';
$_lang["role_create_plugin"] = 'プラグインの作成';
$_lang["role_create_snippet"] = 'スニペットの作成';
$_lang["role_create_template"] = 'テンプレートの作成';
$_lang["role_credits"] = '著作権表示/謝辞の表示';
$_lang["role_delete_chunk"] = 'チャンクを削除';
$_lang["role_delete_doc"] = 'リソースの削除';
$_lang["role_delete_eventlog"] = 'システムログを削除';
$_lang["role_delete_module"] = 'モジュールの削除';
$_lang["role_delete_plugin"] = 'プラグインの削除';
$_lang["role_delete_role"] = 'ロールの削除';
$_lang["role_delete_snippet"] = 'スニペットの削除';
$_lang["role_delete_template"] = 'テンプレートの削除';
$_lang["role_delete_user"] = 'ユーザーの削除';
$_lang["role_delete_web_user"] = 'ウェブユーザーの削除';
$_lang["role_edit_chunk"] = 'チャンクを編集';
$_lang["role_edit_doc"] = 'リソースの編集';
$_lang["role_edit_doc_metatags"] = 'METAタグとキーワードの編集';
$_lang["role_edit_module"] = 'モジュールの編集';
$_lang["role_edit_plugin"] = 'プラグインの編集';
$_lang["role_edit_role"] = 'ロールの編集';
$_lang["role_edit_settings"] = 'サイト設定の変更';
$_lang["role_edit_snippet"] = 'スニペットの編集';
$_lang["role_edit_template"] = 'テンプレートの編集';
$_lang["role_edit_user"] = 'ユーザーの編集';
$_lang["role_edit_web_user"] = 'ウェブユーザーの編集';
$_lang["role_empty_trash"] = '全ての削除済みリソースを完全に消去する';
$_lang["role_errors"] = 'エラーダイアログの表示';
$_lang["role_eventlog_management"] = 'システムログ管理';
$_lang["role_export_static"] = '静的HTMLファイルとして書き出す';
$_lang["role_file_manager"] = 'ファイル管理機能の使用';
$_lang["role_frames"] = '管理画面フレームの要求';
$_lang["role_help"] = 'ヘルプページの表示';
$_lang["role_home"] = '管理画面ホームの要求';
$_lang["role_import_static"] = '静的HTMLファイルをインポート';
$_lang["role_logout"] = '管理画面をログアウト';
$_lang["role_manage_metatags"] = 'サイト全体METAタグとキーワードの管理';
$_lang["role_management_msg"] = 'ロール(役割)ごとに、アクセス可能な機能を選択・設定します。たとえば「管理者」「投稿者」といったロールを作る場合、「管理者」には全権を、そして「投稿者」にはサイト管理に関する設定をさわれないように制限をかけます。ロールは役割・役職のようなもので、たとえば営業グループと秘書グループとで役割が違うのと似ています。各ユーザごとに個別に権限を直接割り当てるのではなく、ロールという形で役割・権限を割り当てる考え方となっています。MODxでは、管理画面にアクセスする全てのユーザが何らかのロール(役割)を持ちます。';
$_lang["role_management_title"] = 'ロール管理';
$_lang["role_messages"] = 'メッセージの表示および送信';
$_lang["role_module_management"] = 'モジュール管理';
$_lang["role_name"] = 'ロール名';
$_lang["role_new_module"] = 'モジュールの作成';
$_lang["role_new_role"] = 'ロールの作成';
$_lang["role_new_user"] = 'ユーザーの作成';
$_lang["role_new_web_user"] = 'ウェブユーザーの作成';
$_lang["role_plugin_management"] = 'プラグイン管理';
$_lang["role_publish_doc"] = 'リソースの公開';
$_lang["role_role_management"] = 'ロール管理';
$_lang["role_run_module"] = 'モジュールの実行';
$_lang["role_save_chunk"] = 'チャンクの保存';
$_lang["role_save_doc"] = 'リソースの保存';
$_lang["role_save_module"] = 'モジュールの保存';
$_lang["role_save_password"] = 'パスワードの保存';
$_lang["role_save_plugin"] = 'プラグインの保存';
$_lang["role_save_role"] = 'ロールの保存';
$_lang["role_save_snippet"] = 'スニペットの保存';
$_lang["role_save_template"] = 'テンプレートの保存';
$_lang["role_save_user"] = 'ユーザーの保存';
$_lang["role_save_web_user"] = 'ウェブユーザーの保存';
$_lang["role_snippet_management"] = 'スニペット管理';
$_lang["role_template_management"] = 'テンプレート管理';
$_lang["role_title"] = 'ロールの作成/編集';
$_lang["role_udperms"] = 'アクセス許可管理';
$_lang["role_user_management"] = 'ユーザー管理';
$_lang["role_view_docdata"] = 'リソースデータの表示';
$_lang["role_view_eventlog"] = 'システムログを見る';
$_lang["role_view_logs"] = 'システムログの閲覧';
$_lang["role_view_unpublished"] = '未公開のリソースの閲覧';
$_lang["role_web_access_persmissions"] = 'ウェブアクセス許可';
$_lang["role_web_user_management"] = 'ウェブユーザー管理';
$_lang["rss_url_news_default"] = 'http://feeds2.feedburner.com/modxjp';
$_lang["rss_url_news_message"] = '管理画面トップの「MODx News」のフィードURL.';
$_lang["rss_url_news_title"] = 'RSS ニュースフィード';
$_lang["rss_url_security_default"] = 'http://feeds2.feedburner.com/modxjpsec';
$_lang["rss_url_security_message"] = '管理画面トップの「MODx Security」のフィードURL';
$_lang["rss_url_security_title"] = 'RSS セキュリティ情報フィード';
$_lang["run_module"] = 'モジュールの実行';
$_lang["saturday"] = '土曜';
$_lang["save"] = '保存';
$_lang["save_all_changes"] = '全ての変更を更新';
$_lang["save_tag"] = 'タグ保存';
$_lang["saving"] = '保存中です。お待ちください ...';
$_lang["search"] = '検索';
$_lang["search_criteria"] = '検索 条件';
$_lang["search_criteria_content"] = '内容で検索';
$_lang["search_criteria_content_msg"] = '入力されたテキストで全てのリソースの内容を検索します。';
$_lang["search_criteria_id"] = 'IDで検索';
$_lang["search_criteria_id_msg"] = 'リソースを手早く特定するにはリソースIDを入力してください。';
$_lang["search_criteria_longtitle"] = '長いタイトルで検索';
$_lang["search_criteria_longtitle_msg"] = '入力されたテキストで全てのリソースの「長いタイトル」を検索します。';
$_lang["search_criteria_title"] = 'タイトルで検索';
$_lang["search_criteria_title_msg"] = '入力されたテキストで全てのリソースのタイトルを検索します。';
$_lang["search_empty"] = '指定したデータが見つかりませんでした。検索範囲を広げて再度検索してください。';
$_lang["search_item_deleted"] = 'このアイテムは削除されています';
$_lang["search_results"] = '検索結果';
$_lang["search_results_returned_desc"] = '説明';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = '<strong>%s</strong>件のデータが見つかりました。多くの検索結果が表示される場合は、検索範囲を更に狭くしてください。左側二つのカラムでは、サイトツリーでリソースを探したり、リソースを表示したりすることができます。右側二つのカラムでは、 リソースの削除状態および公開状態が各々表示されます。<p />';
$_lang["search_results_returned_title"] = 'タイトル';
$_lang["search_view_docdata"] = 'このアイテムを表示';
$_lang["security"] = 'ユーザー管理';
$_lang["security_notices_tab"] ='セキュリティ情報';
$_lang["security_notices_title"] ='セキュリティ情報';
$_lang["select_date"] = '日付を選択';
$_lang["send"] = '送信';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'このサイトがSSL接続を使用している場合は、httpsを選択してください。';
$_lang["server_protocol_title"] = 'サーバータイプ:';
$_lang["serveroffset"] = 'サーバーオフセット';
$_lang["serveroffset_message"] = 'サーバー設置場所とあなたの居場所の時差を選択してください。サーバーの現在時刻は<strong>[%s]</strong>です。オフセットを使用したサーバーの現在時刻は<strong>[%s]</strong>です。';
$_lang["serveroffset_title"] = 'サーバーオフセットタイム:';
$_lang["servertime"] = 'サーバー時刻';
$_lang["settings_after_install"] = '<p><strong style="color:red;">アップデートまたは新規インストール直後のため、各種設定を確認し保存する必要があります。設定を確認した後、データベースを更新するために「保存」ボタンをクリックしてください。</strong></p><p>※この設定は後で自由に変更できます(ツール→グローバル設定)。今の時点ではサイトステータス(公開・準備中など)の設定のみ確認しておくといいでしょう。</p>';
$_lang["settings_config"] = '設定';
$_lang["settings_dependencies"] = '関連付け';
$_lang["settings_events"] = 'システムイベント';
$_lang["settings_furls"] = 'フレンドリーURL';
$_lang["settings_general"] = 'メイン';
$_lang["settings_misc"] = 'ファイル管理の設定';
$_lang["settings_page_settings"] = 'ページ設定';
$_lang["settings_photo"] = '写真';
$_lang["settings_properties"] = 'プロパティ';
$_lang["settings_site"] = 'サイト';
$_lang["settings_strip_image_paths_message"] = 'ファイルブラウザで選択したファイルのsrc属性を相対パスで投稿画面に渡します。この設定を「いいえ」にした場合は、httpから始まるフルURLになります。投稿画面で利用するRTEによっては、受け取った値をさらに処理することがあるため、ここでの設定は確実ではありません。<br />また、相対パスで運用する場合はフレンドリーURL設定を有効にすると画像やサイト内リンクなどを正しく参照できないことがあります。そのような場合は<a href="http://www.google.com/search?hl=ja&q=html+base+href" target="_blank">baseタグ</a>を利用してください。';
$_lang["settings_strip_image_paths_title"] = '相対パスを渡す';
$_lang["settings_templvars"] = 'テンプレート変数';
$_lang["settings_title"] = 'グローバル設定';
$_lang["settings_ui"] = 'インターフェースとその他の機能';
$_lang["settings_users"] = '詳細設定';
$_lang["show_preview"] = 'リソースの詳細にプレビューを表示';
$_lang["show_tree"] = 'サイトツリーの表示';
$_lang["showing"] = '表示中';
$_lang["signupemail_message"] = 'ユーザ管理画面でユーザーアカウントを作成した時に、ユーザー名とパスワードを記載したメールを送信することができます。このメールの内容を設定してください。<br /><strong>参考:</strong> 下記の差し込み文字列は送信時に自動的に置き換えられます。<br /><br />[+sname+] - サイトの名前, <br />[+saddr+] - サイト管理者のメールアドレス, <br />[+surl+] - サイトのURL, <br />[+uid+] - ユーザーのログイン名, <br />[+pwd+] - ユーザーのパスワード, <br />[+ufn+] - ユーザーのフルネーム. ';
$_lang["signupemail_title"] = 'サインアップメール:';
$_lang["site"] = 'メイン';
$_lang["site_schedule"] = '公開状態の一覧';
$_lang["sitename_message"] = 'サイト名を入力してください。title要素などで [*pagetitle*] などと組み合わせて用います。<br />セッティング変数： [(site_name)]';
$_lang["sitename_title"] = 'サイト名:';
$_lang["sitestart_message"] = 'トップページとして使用するリソースのIDを入力してください。<strong>注意: 既に存在するリソースのIDを入力してください。リソースは公開されている必要があります。</strong>';
$_lang["sitestart_title"] = 'サイトスタート:';
$_lang["sitestatus_message"] = 'このサイトをウェブ上に公開するには「オンライン」を選択してください。「オフライン」を選択した場合、訪問者には「サイト閉鎖中ページ」または「サイト閉鎖中メッセージ」が表示されます。';
$_lang["sitestatus_title"] = 'サイトステータス:';
$_lang["siteunavailable_message"] = 'サイトがオフラインまたはエラー発生時に表示するメッセージです。<br />セッティング変数：[(site_unavailable_message)]<br /><strong>注意: このメッセージはサイト閉鎖中ページが設定されていないときのみ表示されます。</strong>';
$_lang["siteunavailable_message_default"] = 'ただいま調整中です。しばらくお待ちください。';
$_lang["siteunavailable_page_message"] = 'サイト閉鎖中に表示するリソースのIDをここに入力してください。<strong>注意: 入力するIDは既に存在するリソースのものでないといけません。また公開中であるものに限ります。</strong>';
$_lang["siteunavailable_page_title"] = 'サイト閉鎖中ページ:';
$_lang["siteunavailable_title"] = 'サイト閉鎖中メッセージ:';
$_lang["snippet"] = 'スニペット';
$_lang["snippet_code"] = 'スニペット コード (php)';
$_lang["snippet_desc"] = '説明';
$_lang["snippet_execonsave"] = '保存後にスニペットを実行';
$_lang["snippet_management_msg"] = '<h3 style="font-weight:bold;">スニペットの管理</h3><p>編集したいスニペットを選択してください。</p>';
$_lang["snippet_msg"] = 'スニペットを追加・編集することができます。スニペットは「生の」PHPコードです。スニペットの出力をテンプレートの特定の場所に表示したい場合は、テンプレート内にスニペット名を記述する必要があります - 基本的に、スニペットのアウトプットはスニペット自身と同じ名前で保存された変数を必要とします。';
$_lang["snippet_name"] = 'スニペット名';
$_lang["snippet_properties"] = '既定のプロパティ';
$_lang["snippet_title"] = 'スニペットの作成/編集';
$_lang["sort_asc"] = '昇順';
$_lang["sort_desc"] = '降順';
$_lang["sort_tree"] = 'サイトツリーのソート';
$_lang["source"] = 'ソース';
$_lang["stay"] = '保存後に続けて編集';
$_lang["stay_new"] = '次の作成';
$_lang["submit"] = '実行';
$_lang["sunday"] = '日曜';
$_lang["sys_alert"] = 'システム警告';
$_lang["sysinfo_activity_message"] = '最近どのリソースが最近ユーザーによって編集されたかを表示します。';
$_lang["sysinfo_userid"] = 'ユーザー';
$_lang["system_email_signup"] = "こんにちは [+uid+] さん\n\n「[+sname+] ([+surl+])」のコンテント管理システムへのログイン情報について下記のとおりお知らせします。\n\nログインユーザー名: [+uid+]\nパスワード: [+pwd+]\n\nコンテント管理システムへログインすれば、自分のパスワードは自由に変更できます。\n\n以上、よろしくお願いします。\nサイト管理者より";
$_lang["system_email_webreminder"] = "こんにちは [+uid+] さん\n\n新しいパスワードを有効にするためには、下記のリンクをクリックしてください。\n\n[+surl+]\n\n処理完了後、下記のパスワードをログインに使用できるようになります。\n\nパスワード:[+pwd+]\n\nもしこのメールに覚えが無いときは、ただ単に無視してこのメールを破棄して下さい。\n\n以上、よろしくお願いします。\nサイト管理者より";
$_lang["system_email_websignup"] = "こんにちは [+uid+] さん\n\n「[+sname+] ([+surl+])」へのログイン情報について下記のとおりお知らせします。\n\nログインユーザー名: [+uid+]\nパスワード: [+pwd+]\n\n [+sname+]へログインすれば、自分のパスワードは自由に変更できます。\n\n以上、よろしくお願いします。\nサイト管理者より";
$_lang["table_hoverinfo"] = 'テーブル名にマウスをかざすとテーブルの機能について簡単な説明を見ることができます（全てのテーブルに<i>説明</i>があるわけではありません）。';
$_lang["table_prefix"] = 'テーブル接頭辞';
$_lang["tag"] = 'タグ';
$_lang["template"] = 'テンプレート';
$_lang["template_assignedtv_tab"] = '定義されているテンプレート変数';
$_lang["template_code"] = 'テンプレート コード (html)';
$_lang["template_desc"] = '説明';
$_lang["template_edit_tab"] = 'テンプレートの編集';
$_lang["template_management_msg"] = '<h3 style="font-weight:bold;">テンプレートデザインの管理</h3><p>テンプレートはいくつでも作成でき、リソースごとに自由に割り当てることができます。</p>';
$_lang["template_msg"] = 'テンプレートを作成/編集できます。作成・変更されたテンプレートは、キャッシュがクリアされるまで見れないかもしれません。しかし、プレビュー機能を使用してテンプレートの動作を確認することができます。';
$_lang["template_name"] = 'テンプレート名';
$_lang["template_no_tv"] = 'テンプレート変数は定義されていません。';
$_lang["template_reset_all"] = '全てのリソースが既定のテンプレートを使用するようにリセットする';
$_lang["template_reset_specific"] = '「%s」を使用しているリソースのみリセットする';
$_lang["template_title"] = 'テンプレートの作成/編集';
$_lang["template_tv_edit"] = 'テンプレート変数の順序を書き換え';
$_lang["template_tv_edit_message"] = 'テンプレート変数を並び替えるためドラッグする';
$_lang["template_tv_edit_title"] = 'テンプレート変数のソート順';
$_lang["template_tv_msg"] = 'このテンプレートに定義されているテンプレート変数は下記のリストのとおりです。';
$_lang["thursday"] = '木曜';
$_lang["tmplvar_access_msg"] = 'この変数に対して内容や値の変更を許可するリソースグループを選択してください。';
$_lang["tmplvar_change_template_msg"] = 'このテンプレートを変更すると、このページのテンプレート変数をリロードします。保存していない変更は失われます。\n\n ほんとうにこのテンプレートを変更しますか?';
$_lang["tmplvar_inuse"] = '下記のリソースはこのテンプレート変数を現在使用しています。削除処理を続けるには「削除」ボタンを、やめるときは「キャンセル」ボタンをクリックしてください。';
$_lang["tmplvar_tmpl_access"] = 'テンプレートへのアクセス';
$_lang["tmplvar_tmpl_access_msg"] = 'この変数へのアクセスや処理を許可するテンプレートを選択してください。';
$_lang["tmplvars"] = 'テンプレート変数';
$_lang["tmplvars_binding_msg"] = 'このフィールドは@コマンドを使ってのデータソースへのバインドをサポートします。';
$_lang["tmplvars_caption"] = '見出し';
$_lang["tmplvars_default"] = '既定値';
$_lang["tmplvars_description"] = '説明';
$_lang["tmplvars_elements"] = '入力時のオプション値';
$_lang["tmplvars_management_msg"] = '<h3 style="font-weight:bold;">テンプレート変数の管理</h3><p>リソース変数を追加・管理できます。これは「テンプレート変数」と呼ばれるもので、一般的なCMSで言うところのカスタムフィールドに相当します。「タイトル」や「内容」などの既定の項目に加え、自由に項目を追加できます。</p>';
$_lang["tmplvars_msg"] = 'テンプレート変数を作成・編集します。このテンプレート変数を使用するテンプレートを「テンプレートへのアクセス」で関連付けてください。';
$_lang["tmplvars_name"] = '変数名';
$_lang["tmplvars_novars"] = 'テンプレート変数が見つかりません。';
$_lang["tmplvars_rank"] = '並べ替え順';
$_lang["tmplvars_reset_params"] = 'パラメータのリセット';
$_lang["tmplvars_type"] = '入力タイプ';
$_lang["tmplvars_widget"] = 'ウィジェット';
$_lang["tmplvars_widget_prop"] = 'Widget プロパティ';
$_lang["to"] = '-';
$_lang["tools"] = 'ツール';
$_lang["top_howmany_message"] = '訪問レポートの「トップ ...」に何件表示するか指定します。(※訪問レポートの機能は現在のMODxには実装されていません)';
$_lang["top_howmany_title"] = 'トップ 表示件数';
$_lang["total"] = '合計';
$_lang["track_visitors_message"] = 'このサイトのアクセス解析データを蓄積します(※ただし閲覧には対応モジュールが必要)。';
$_lang["track_visitors_title"] = 'アクセスログを記録';
$_lang["tree_show_protected"] = '権限のないリソースの表示';
$_lang["tree_show_protected_message"] = '操作権限を持たないリソースも全てサイトツリーに表示します。Windowsフォルダオプションの「全てのファイルとフォルダを表示する」に似ています。「いいえ」に設定した場合は権限を持つリソースのみが表示されますが、親リソースに権限がない場合は、権限を持つサブリソースも表示されません。権限の設定は<a href="index.php?a=40">「管理画面へのアクセス許可」</a>で行ないます。';
$_lang["truncate_table"] = 'このテーブルの内容を全削除するにはここをクリック';
$_lang["tuesday"] = '火曜';
$_lang["tv"] = 'テンプレート変数';
$_lang["type"] = 'タイプ';
$_lang["udperms_allowroot_message"] = 'サイトツリーのルート直下にユーザーがリソースを作成できるようにしますか? ';
$_lang["udperms_allowroot_title"] = 'ルートの使用許可:';
$_lang["udperms_message"] = 'アクセス権限設定を有効にすると、ユーザーの編集権限をユーザーグループごと・リソースグループごとに割り当てることができます。まず<a href="index.php?a=40" target="_self">管理画面へのアクセス許可</a>を開き、ユーザーグループとリソースグループを作ってください。次に、それぞれのユーザーグループとリソースグループを関連付けてください。最後に、個別のユーザーをユーザーグループに、個別のリソースをリソースグループに割り当ててください。この設定を「はい」にした場合、全てのリソースを編集する権限を持つのは初期状態では管理者のみとなります。';
$_lang["udperms_title"] = 'アクセス権限設定の使用:';
$_lang["unable_set_link"] = 'リンクを設定できません。';
$_lang["unable_set_parent"] = '新しい親リソースを設定できません。';
$_lang["unauthorizedpage_message"] = 'ユーザーがアクセスを許可されていないリソースを要求したとき表示するリソースのIDを入力してください。 <strong>注意: 入力するIDは既に存在するリソースのものでないといけません。また公開中でしかもPublicなアクセスが可能であるものに限ります!</strong>';
$_lang["unauthorizedpage_title"] = '権限外告知のページ:';
$_lang["unblock_message"] = 'ユーザーデータを保存した後、このユーザーのアクセス拒否は解除されます。';
$_lang["undelete_document"] = 'リソースの復活';
$_lang["unpublish_date"] = '非公開日時';
$_lang["unpublish_document"] = 'リソースの公開取消';
$_lang["unpublish_events"] = '公開取消予定のリソース一覧';
$_lang["untitled_document"] = '無題のリソース';
$_lang["untitled_weblink"] = '無題のウェブリンク';
$_lang["update_params"] = 'パラメータ表示の更新';
$_lang["update_settings_from_language"] = '置き換え:';
$_lang["upload_maxsize_message"] = '管理画面を通じてアップロード可能なファイルの最大サイズを入力してください。サイズはバイト単位で入力します。<strong>注意: サーバ側で設けられている上限サイズを超えることはできません。</strong>';
$_lang["upload_maxsize_title"] = 'アップロードサイズの上限';
$_lang["uploadable_files_message"] = '<a href="index.php?a=31" target="_self">ファイル管理</a>画面でアップロードできるファイルタイプの一覧を入力してください。ファイルタイプの拡張子をカンマで区切って複数指定できます。この設定はファイルブラウザも参照します。';
$_lang["uploadable_files_title"] = 'アップロード可能なファイルタイプ:';
$_lang["uploadable_flash_message"] = 'ファイルブラウザを使用して「assets/flash/ 」にアップロードできるフラッシュファイルの一覧を入力してください。拡張子をカンマで区切って入力してください。';
$_lang["uploadable_flash_title"] = 'アップロード可能なフラッシュ:';
$_lang["uploadable_images_message"] = 'ファイルブラウザを使用して「assets/images/ 」にアップロードできる画像ファイルの一覧を入力してください。拡張子をカンマで区切って入力してください。';
$_lang["uploadable_images_title"] = 'アップロード可能な画像タイプ:';
$_lang["uploadable_media_message"] = 'ファイルブラウザを使用して「assets/media/ 」にアップロードできるメディアファイルの一覧を入力してください。拡張子をカンマで区切って入力してください。';
$_lang["uploadable_media_title"] = 'アップロード可能なマルチメディアタイプ:';
$_lang["use_alias_path_message"] = 'このオプションを「はい」に設定すると、リソースのエイリアスがパスとして表示されます。例えば、「child」というエイリアスを持ったリソース「parent」というエイリアスのリソースの下に配置されていると、エイリアスパスは「/parent/child.html」になります。<br /><strong>注意: このオプションを「はい」にするとき、つまりエイリアスパスを使用するときは、リソースから参照するものは（画像・CSS・JavaScriptなど）絶対パスで指定する必要があります。例えば、assets/imagesに対しては/assets/imagesと指定します。ただし<a href="http://www.google.com/search?hl=ja&q=html+base+href" target="_blank">baseタグ</a>を利用すると、相対パス記述でも正しく参照できます。</strong>';
$_lang["use_alias_path_title"] = 'エイリアスパスを使用:';
$_lang["use_editor_message"] = 'リッチテキストエディター(RTE)の使用を設定します。「いいえ」を選択するとRTEを利用できなくなります。この設定は全てのリソース・全てのユーザーに一括で適用されるためご注意ください。<br />TinyMCEやCKEditorはデフォルトでは無難なタグしか利用できないようになっており、閉じタグの処理も自動的に行なうことができます。必ずしもプレーンなテキストエリアが無難とは限らないので、ご検討ください。詳細については<a href="index.php?a=9">ヘルプ</a>をご覧ください。';
$_lang["use_editor_title"] = 'RTEの使用:';
$_lang["user"] = 'ユーザー';
$_lang["user_block"] = 'アクセス拒否';
$_lang["user_blockedafter"] = 'この日から拒否';
$_lang["user_blockeduntil"] = 'この日まで拒否';
$_lang["user_changeddata"] = 'ユーザー情報が変更されました。もう一度ログインしなおしてください。';
$_lang["user_country"] = '国';
$_lang["user_dob"] = '誕生日';
$_lang["user_doesnt_exist"] = 'ユーザー登録がありません';
$_lang["user_edit_self_msg"] = 'ユーザー情報を変更した場合は、変更を反映させるためにログアウトして再度ログインしてください。<br />新しいパスワードの作成をチェックした場合、新しいパスワードがメール送信されます。</b>';
$_lang["user_email"] = 'メールアドレス';
$_lang["user_failedlogincount"] = 'ログイン失敗';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = '女性';
$_lang["user_full_name"] = 'フルネーム';
$_lang["user_gender"] = '性別';
$_lang["user_is_blocked"] = 'このユーザーはアクセス拒否されています。';
$_lang["user_logincount"] = 'ログイン回数';
$_lang["user_male"] = '男性';
$_lang["user_management_msg"] = '管理画面にログインできるユーザーの情報を編集します。';
$_lang["user_management_title"] = 'ユーザー管理';
$_lang["user_mobile"] = '携帯電話番号';
$_lang["user_phone"] = '電話番号';
$_lang["user_photo"] = 'ユーザーの写真';
$_lang["user_photo_message"] = 'このユーザーの写真イメージファイルのURLを入力してください。または、挿入ボタンをクリックしファイルマネージャーでファイルを選択してください。';
$_lang["user_prevlogin"] = '最終ログイン';
$_lang["user_role"] = 'ロール(役割)';
$_lang["user_state"] = '住所';
$_lang["user_title"] = 'ユーザーの作成/編集';
$_lang["user_upload_message"] = ' このユーザーに対してこのカテゴリーに含まれるファイルタイプのアップロードを禁じたい場合、「グローバル設定を使用」をチェックせず、このフィールドを空白にしておいてください。';
$_lang["user_use_config"] = 'グローバル設定を使用';
$_lang["user_zip"] = '郵便番号';
$_lang["username"] = 'ユーザー名';
$_lang["users"] = 'ユーザー';
$_lang["validate_referer_message"] = '「はい」を選択すると、HTTP_REFERER チェックを行い、認証されないHTTP_REFERERヘッダからの要求を拒否します。これにより、管理画面にログイン中に意図しない動作をさせられてしまう脅威 (CSRF=Cross Site Request Forgery)をある程度軽減できます。ただし、HTTP_REFERERを無効にしているサーバーには、有効な手段ではありません。完全な回避策が出るまでは、管理画面にログイン中は、不用意に外部リンクをクリックしない・こまめにログアウトをするなどして十分注意してください';
$_lang["validate_referer_title"] = 'HTTP_REFERER チェック';
$_lang["value"] = '値';
$_lang["version_codename"] = 'コードネーム';
$_lang["view"] = 'ここをクリック';
$_lang["view_child_documents_in_container"] = 'サブリソースを表示';
$_lang["view_log"] = 'ログを見る';
$_lang["view_logging"] = '管理操作ログ';
$_lang["view_sysinfo"] = 'システム情報';
$_lang["warning"] = '警告 ';
$_lang["warning_not_saved"] = '変更が保存されていません。変更を保存するためには「キャンセル」をクリックし現在のページに戻ってください。また、「OK」をクリックして全ての変更を破棄することもできます。';
$_lang["web_access_permissions"] = 'サイト上のアクセス許可';
$_lang["web_access_permissions_user_groups"] = 'ウェブユーザーグループ';
$_lang["web_permissions"] = 'サイト上のアクセス許可';
$_lang["web_user_management_msg"] = '編集したいウェブユーザーを選択します。ウェブユーザーはウェブサイトにのみログインできるユーザーを意味します。';
$_lang["web_user_management_title"] = 'ウェブユーザー';
$_lang["web_user_title"] = 'ウェブユーザーの作成･編集';
$_lang["web_users"] = 'ウェブユーザー';
$_lang["weblink"] = 'ウェブリンク';
$_lang["weblink_message"] = 'ウェブリンクは、インターネット上のオブジェクトに対する参照です。オブジェクトは、MODx内のリソース(IDで指定)・他のサイトのページや画像・インターネット上の他のファイル(URLで指定)です。<p>';
$_lang["webpwdreminder_message"] = 'ウェブユーザーからパスワード変更の要求があった時に、MODxは新パスワードとアクティベーション方法を記載したメールを送信することができます。このメールの内容を設定してください。<br /><strong>参考:</strong> 下記の差し込み文字列は送信時に自動的に置き換えられます。<br /><br />[+sname+] - サイトの名前, <br />[+saddr+] - サイト管理者のメールアドレス, <br />[+surl+] - サイトのURL, <br />[+uid+] - ユーザーのログイン名, <br />[+pwd+] - ユーザーのパスワード, <br />[+ufn+] - ユーザーのフルネーム. ';
$_lang["webpwdreminder_title"] = 'パスワード変更<br />リクエストメール:';
$_lang["websignupemail_message"] = 'ユーザー自らがウェブユーザーアカウントを作成した時に、MODxはユーザー名とパスワードを記載したメールを送信することができます。このメールの内容を設定してください。<br /><strong>参考:</strong> 下記の差し込み文字列は送信時に自動的に置き換えられます。<br /><br />[+sname+] - サイトの名前, <br />[+saddr+] - サイト管理者のメールアドレス, <br />[+surl+] - サイトのURL, <br />[+uid+] - ユーザーのログイン名, <br />[+pwd+] - ユーザーのパスワード, <br />[+ufn+] - ユーザーのフルネーム. ';
$_lang["websignupemail_title"] = 'ウェブサインアップメール:';
$_lang["wednesday"] = '水曜';
$_lang["welcome_messages"] = '受信トレイに <strong>%d</strong> 件のメッセージが入っています。<strong>%s</strong> 件が未読です。';
$_lang["welcome_title"] = 'MODxへようこそ';
$_lang["which_editor_message"] = '使用するリッチテキストエディターを選択してください(※<a href="http://modxcms.com/extras/repository/packages/Content" target="_blank">MODxのダウンロードページ</a>には追加でインストールできるリッチテキストエディターがあります)。';
$_lang["which_editor_title"] = '使用エディター:';
$_lang["working"] = '処理中 ...';
$_lang["wrap_lines"] = '行の折り返し';
$_lang["xhtml_urls_message"] = '「はい」を設定すると、アンパーサンド (&) を自動的に文字実態参照 (&<!-- -->amp;) に置き換えます。';
$_lang["xhtml_urls_title"] = 'XHTML URLs';
$_lang["yes"] = 'はい';
$_lang["you_got_mail"] = 'メッセージが届いています。';
$_lang["yourinfo_message"] = '自分自身に関する情報を表示しています:';
$_lang["yourinfo_previous_login"] = '最終ログイン日時は:';
$_lang["yourinfo_role"] = '所属ロール(役割):';
$_lang["yourinfo_title"] = 'あなたの情報';
$_lang["yourinfo_total_logins"] = '合計ログイン回数は:';
$_lang["yourinfo_username"] = 'ログイン名は:';
?>