<?php
if(IN_MANAGER_MODE!="true") die("<b>INCLUDE_ORDERING_ERROR</b><br /><br />Please use the MODx Content Manager instead of accessing this file directly.");
?>
<style type="text/css">
h3 {font-weight:bold;letter-spacing:2px;font-size:1;margin-top:10px;}
pre {border:1px dashed #ccc;background-color:#fcfcfc;padding:15px;}
ul {margin-bottom:15px;}
</style>

<div class="sectionHeader">知っておくと便利</div>
<div class="sectionBody" style="padding:10px 20px;">
<h3>フレンドリーURLを有効にする</h3>
<p>
各ページのURLはindex.php?id=xxxという形式になっていますが、サーバ側にインストールされているmod_rewriteモジュールの機能を利用し、静的構成のサイトのような /dir/page.html という形式でURLを扱うこともできます。</p>
<p>
まず、インストールディレクトリにある「ht.access」を「.htaccess」にリネームします(※サーバによってはOptions +FollowSymlinks記述を有効にしないとサーバのURL書き換え機能が働かないことがあります)。次にMODx側のフレンドリーURL出力を有効にするために<a href="index.php?a=17">グローバル設定</a>を開き、「フレンドリーURLの使用」を「はい」にしてください。すると関連する設定項目が追加表示されます。
</p>
<ul>
<li>フレンドリーURLの接頭辞 → 空白</li>
<li>フレンドリーURLの接尾辞 →「 .html」</li>
<li>フレンドリエイリアス →「はい」</li>
<li>エイリアスパスを使用 →「はい」</li>
<li>重複エイリアスを許可 →「はい」</li>
<li>エイリアス自動生成 →「いいえ」</li>
</ul>
<p>
一般的にはこのように設定します。拡張子を自由にコントロールしたい場合は「フレンドリーURLの接尾辞」を空白にしておいて、リソースのエイリアスで拡張子込みのファイル名を指定するとよいでしょう。たとえばCSSファイルやXMLファイルもリソースとして管理したいが、拡張子がhtmlになるのを避けたい場合に有効です。また、MODxのURLコントロール機能を補佐する<a href="http://www.google.com/search?hl=ja&q=modx+%22SEO+Strict+URLs%22" target="_blank">「SEO Strict URLs」</a>プラグインが知られています。
</p>

<h3>配布されているアドオン(スニペット・プラグイン)をインストールする</h3>
<p>
<a href="http://modxcms.com/extras/repository/10" target="_blank">MODx開発元のアドオン配布コーナー</a>ではさまざまなスニペット・プラグイン・モジュールが配布されています。現在のMODxはこれらのアドオンをシンプルで一律な手順でインストールする仕組みを持っていないため、基本的には配布ページに記述されている手順に沿ってインストールします。プラグインやモジュールに関してはインストーラが提供されていることもあります。連携ファイルを持たない小さなアドオンの場合は、管理画面の<a href="index.php?a=76">「エレメント管理」</a>で新規作成フォームを開き、コードをコピー・ペーストするだけで使えるようになります。プラグインの場合はさらにシステムイベント設定タブでシステムイベントを設定する必要があります。
</p>

<h3>ナビゲーションを設置する</h3>

<p>
MODxはオーサリングツールのイメージに近いCMSなので、静的にナビゲーションを記述してもいいのですが、動的生成ならではの便利なアプローチもあります。たとえばサイトを新規に構築する場合、通常は1ページずつ順に作っていきます。構築開始の時点で各ページのURLがしっかり決まっている場合は、その情報に従ってナビゲーションを組めばよいですが、せっかくCMSでサイトを作るからにはラフにすませる方法を考えたいです。</p>
<p>
こういう場合、標準で同梱されているWayfinderを利用します。テンプレート中に[[Wayfinder]]と記述するだけで、とりあえずその時点で作られているリソースのリンク一覧を動的に出力します。</p>
<pre>
[[Wayfinder? &startId=`0` &hideSubMenus=`true`]]
</pre>
<p>
一般的にはこのように記述します。Wayfinderには他にも豊富なオプションがあり、親子関係の表現なども自由自在です。ナビゲーションに関してはなんでもできる万能型のスニペットです。サイトマップも作れます。
</p>

<h3>新着情報の一覧を設置する</h3>
<p>
標準で同梱されているDittoを利用します。リソースの一覧出力に関してはあらゆることができる、万能型スニペットです。新着情報の一覧だけでなく、ブログの実装も可能です。DittoとWayfinderの使いこなしを習得することで、MODxをCMS的に使いこなすためのあらゆるノウハウを得ることができます。
</p>


<h3>問い合わせフォームを設置する</h3>
<p>
標準で同梱されているeFormスニペットが利用できます。さらに高機能なスニペットとしては<a href="http://www.google.com/search?hl=ja&q=cfformmailer" target="_blank">cfFormMailer</a>が知られています。
</p>

<h3>ブログ・フォーラム・通販カート・画像ギャラリーを設置する</h3>
<p>
MODxの仕組みを利用して独立CMSレベルの機能を追加するのは難しいですが、「インテグレータ」と呼ばれるスタイルのスニペット・モジュールなら手軽に導入できます。インテグレータは、WordPressやSMFなど既存の目的特化型CMSと連携し、MODxの機能の一部であるように振る舞うことができる仕組みです。この仕組みはMODxがシステムとして持っているものではなく、アドオン作家の工夫により実現されているもので、コミュニティ参加者または作者自身により自発的に「インテグレータ」と呼ばれています。
</p>

<p>
ブログ・フォーラム・通販カート・ギャラリーの仕組みを十分に理解している場合は、MODxの仕組みを利用してこれらのアプリケーションを作ることもできます。もともとMODxはそのような利用を十分に想定し、各種APIを充実させています。この特性のために、MODxはフレームワークとしても活用できます。phpによる開発のベースとしてもMODxをご利用ください。
</p>

<h3>CMS操作に慣れない担当者への配慮</h3>
<p>
MODxはシステムの扱いに慣れた管理者にとってはサイト構造を把握しやすいCMSですが、ブログのような手順型のコンテンツ管理に慣れているユーザには複雑に感じられるかもしれません。MODxをブログのような管理方式にカスタマイズするのは難しいですが、以下のような方法を用いて直感的なページ編集の手段を提供することは可能です。
</p>
<p>
まず<a href="index.php?a=75">ユーザ管理</a>を開いて、担当者のアカウントを作ります。アカウント編集ページの「詳細」タブを開き、「管理画面ログイン開始ページ」としてトップページのリソースIDを指定します。こうすると、担当者がログインした時、自動的にサイトのトップページにリダイレクトされます。ログインが完了しているので、この時点でQuickManagerの編集ツールバーが表示されています。あとは編集したいページを開き、編集ツールバーのボタンをクリックしてページ内容を編集するだけです。こうすることで、担当者は管理画面にアクセスせずにすみます。必要であれば管理画面のURLを開けば管理画面にアクセスできます。
</p>

<h3>Googleマップを貼り付ける(1)</h3>
<p>投稿画面を開き、「使用エディター」で「なし」を選びます。次に「ページ設定」のタブを開き「リッチテキストで編集」のチェックを外します。このチェックを外しておかないと、次に編集画面を開いた時にRTEがタグを削除してしまうことがあります。これでhtmlタグを自由に記述できるようになったので、Googleマップの「埋め込み地図」のタグを貼り付けます。</p>

<h3>Googleマップを貼り付ける(2)</h3>
<p>
Googleマップを貼り付ける方法はもうひとつあります。MODxの投稿画面に標準で実装されているTinyMCEが、Googleマップで使われる一部のタグを自動的に消去してしまうために地図を貼り付けられません。自動的に消去しないように設定します。<a href="index.php?a=76">エレメント → エレメント管理</a>のTinyMCEプラグインをクリックしてください。「設定」タブでパラメータを設定できるので、「Custom Parameters」に「extended_valid_elements : '*[*]',」と入力して更新してください。末尾のコンマは必須です。こうすることで、すべての要素(*)のすべての属性([*])を受け入れることができるようになるため、通常の記事管理で使わないようなタグを利用するGoogleマップを貼り付けることができるようになります。GoogleマップのコードはTinyMCEツールバーの「HTMLソース編集」ボタンをクリックし開いたダイアログに貼り付けます。</p>

<h3>画像貼り付け時のALT属性入力を求めないようにしたい</h3>
<p>
上記の「Googleマップを貼り付ける(2)」と同様、<a href="index.php?a=76">エレメント → エレメント管理</a>のTinyMCEプラグイン編集画面の「設定」タブに、「accessibility_warnings : false,」と記述して更新してください。末尾のコンマは必須です。次回からはALT属性の入力を求めなくなります。
</p>

<h3>YouTubeの動画を貼り付ける</h3>
<p>そのまま貼り付けられます。TinyMCEで開いている場合は「埋め込みメディアの挿入／編集」アイコンをクリックし、YouTubeの動画URLを貼り付けます。タイプは「Flash」を選んでください。HTMLソース編集ダイアログでプレイヤー展開コードをそのまま貼り付けることもできます。</p>

<h3>改行はシフト＋エンターキーで</h3>
<p>TinyMCEやFCKeditorでリソース編集画面を開いている場合、エンターキーを押すとp要素で段落整形されるため、意図しない空行が挿入されたように見えることがあります。Validな文書を作るには便利な機能ですが、改行のみですませたいこともあります。シフトを押しながらエンターキーを押すと、改行(&lt;br /&gt;)のみが挿入されます。</p>

<h3>文字コードeuc-jpで運用する</h3>
<p>
管理画面に関しては標準でeuc言語ファイルを同梱しており、エンコード設定とセットで設定を変更することでMODxをeuc-jpで運用できます。設定を変更する前に必ずデータベースのバックアップをとってください。</p>
<p>MySQLのバージョンが4.1以上の場合は、グローバル設定の設定変更と共に、manager/includes/config.inc.phpの$database_connection_charsetの値をujisに書き換えてください。4.0系の場合はデータベースの中身をeuc-jpに変換する必要があります。</p>
<p>
スニペットやプラグインなどアドオンに関しては自前で環境を整える必要があります。すでにjapanese-utf8.inc.phpが用意されているケースが多いと思いますので、これをテキストエディタで開いて「japanese-euc.inc.php」というファイル名で、文字コードeuc-jpとして別名保存してください。これがeuc-jp言語ファイルとして、該当アドオンで利用できます。
</p>
<p>
euc-jp運用はポイントさえ押さえていれば難しくありませんが、エンコードの扱いに慣れない場合はリスクをしっかりと意識する必要があります。
</p>

<h3>日常の運用で気をつけるべきこと</h3>
<p>
<a href="index.php?a=114">イベントログ</a>に時々目を通し、想定外のエラーが発生してないか確認しましょう。また、データベースのバックアップはできるだけ定期的にとるようにします。
</p>

<h3>投稿画面の入力項目の大半が不要なので整理したい</h3>

<p>
<a href="http://www.google.com/search?hl=ja&q=modx+ManagerManager" target="_blank">ManagerManager</a>というプラグインを利用すると、投稿画面の入力項目をすっきり整理することができます。項目名を変更することもできます。
</p>

<h3>携帯電話向けコンテンツを作る</h3>

<p>
<a href="http://www.google.com/search?hl=ja&q=modx+MobileConverter" target="_blank">MobileConverterプラグイン</a>が便利です。携帯電話向けに、エンコードや画像形式の変換などを行ないます。

<h3>投稿画面のtextareaのスタイルシートをカスタマイズする</h3>
<p>
たとえば暗い背景に明るい文字色のサイトを管理するのに、白い背景の投稿画面だとイメージをつかみにくいです。この場合、投稿画面のテキストエリアのスタイルを自由にカスタマイズできます。<a href="index.php?a=17">グローバル設定</a>の「CSSファイルへのパス」で指定されているスタイルシートで、投稿画面を自由にカスタマイズできます。
</p>
<p>TinyMCEプラグイン設定タブ「Custom Parameters」の値に「 body_class : "content", 」を追記すると(contentは任意)、投稿画面中ではCSSセレクタ「body.content」の上にコンテンツを展開しているように見立てることができます。</p>

<h3>テンプレート変数の便利な使い方</h3>
<p>
テンプレート変数は「カスタムフィールド」のようなもので、投稿画面にオリジナルの入力項目を追加することができます。MODxでは十分に実用的な仕様となっており、入力・出力のそれぞれにおいて様々な制御ができるようになっています。</p>
<p>
まず入力においては、通常のテキスト入力以外に、ドロップダウンメニュー・チェックボックス・ラジオボタン・ファイルアップロード(画像も可)など一般的なフォーム要素と、リッチテキストやカレンダー入力などさらに高度なGUIを持つものを選ぶことができます。</p>
<p>
ドロップダウンメニューやチェックボックスなど、複数の選択肢を持つタイプのテンプレート変数は下記のように設置します。</p>
<pre>
<b>入力時のオプション値</b>
チャーリー||ハドソン||ダニエル||タイチ||ユーリー

<b>既定値</b>
ハドソン
</pre>
<p>このように「|| 」で区切ります。</p>

<h3>ウィジェット</h3>
<p>テンプレート変数の出力においては、ウィジェットを利用すると高度な制御が可能です。特に「HTML Generic Tag」や「Image」は実用的で、これらのウィジェットを適用したテンプレート変数は、値が何も入力されなかった場合は何も出力しません。</p>
<pre>
&lt;img src=&quot; &quot; /&gt;
</pre>
<p>
このような、属性が空のままのimg要素を出力してしまうことがありません。
</p>

<h3>Dreamweaverなどで作ったhtmlファイルをそのままテンプレートにする</h3>
<p>
Dreamweaverなどでhtmlを組みテンプレート編集画面に貼り付けるのは、細部の調整が続く場合は面倒に感じます。Dreamweaverの高度なテンプレート管理機能を利用して複数のテンプレートを一括管理している場合も、少しの変更のたびに全てのテンプレートを貼り付け直すのは手間がかかります。この場合、Dreamweaverで作ったhtmlファイルをそのまま読み込んでテンプレートとして解釈する方法を用いると便利です。残念ながらdwtファイルは解釈できませんが(スニペットを作ってパス変換すれば可能)、htmlファイルを読み込む前提で以下に方法を説明します。</p>
<p>
詳細は<a href="http://modxcms.com/forums/index.php/topic,10351.msg88947.html#msg88947" target="_blank">こちらのトピック</a>をご覧ください。テンプレート内にphpコードなどを書いて外部ファイルを直接呼び出すことはできないため、テンプレート変数の機能を経由します(<a href="http://modxcms.com/forums/index.php?topic=15438.0" target="_blank">スニペットを利用する方法</a>もあります)。MODxのテンプレート変数には<a href="http://wiki.modxcms.com/index.php/Bindings" target="_blank">「@ Bindings」(アットバインディング)</a>と呼ばれる機能があり、これを利用します。「@ Bindings」は、リソース編集画面でテンプレート変数に入力する値(通常は文字列)を、他のソースに差し替えるものです。「他のソース」としてどんなものがあるのかというと、htmlファイルやCSVファイルなどの「外部ファイル」、任意のリソース(旧称ドキュメント)、チャンク、php文のインライン実行結果、データベースからの抽出結果などが利用できるようになっています。つまりテキストを入力する代わりに、これらのソースから値を動的に引っ張ってくることができます。</p>
<p>
テンプレート製作にDreamweaverを用いる場合は<a href="http://www.google.com/search?hl=ja&q=%22MODx+for+Dreamweaver%22" target="_blank">MODx for Dreamweaver</a>を利用すると便利です。
</p>

<h3>配布テンプレートを手軽に適用</h3>
<p>
モジュール「SkinGraft 」を利用すると、テンプレートを手軽にインストールすることができます。ただし対象テンプレートがSkinGraft に対応している必要があります。基本的な構成ルールが細部まで定まっているブログ型CMSと違い、オーサリングツールに近いMODxはあらゆる形態の運用が想定されるため、汎用的に利用できるテンプレートを作りにくいという事情もあります。
</p>

<h3>MODxの技術情報</h3>
<p>
<a href="http://wiki.modxcms.com/index.php/Ja:main" target="_blank">Ja:main - MODx Wiki</a><br />
MODx開発元のドキュメントサイトに日本語のコーナーを設けています。
</p>

</div>
