using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using MikuMikuDance.Core.Model;
using MikuMikuDance.Core.Misc;

namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// ModelPart̓ǂݍݗp^Cv[_
    /// </summary>
    public class MMDGPUModelPartReader : ContentTypeReader<MMDModelPart>
    {
        /// <summary>
        /// fp[c̓ǂݍ
        /// </summary>
        /// <param name="input">Rec[_</param>
        /// <param name="existingInstance">IuWFNg</param>
        protected override MMDModelPart Read(ContentReader input, MMDModelPart existingInstance)
        {
            //fp[c̓ǂݍ
            int triangleCount = input.ReadInt32();
            MMDVertexNm[] Vertices = input.ReadObject<MMDVertexNm[]>();
            Dictionary<long, int[]> VertMap = input.ReadObject<Dictionary<long, int[]>>();
            IndexBuffer indexBuffer = input.ReadObject<IndexBuffer>();

            // create the model part from this data
            Dictionary<string, object> OpaqueData = new Dictionary<string, object>();
            OpaqueData.Add("VertMap", VertMap);
            OpaqueData.Add("IndexBuffer", indexBuffer);
            MMDModelPart modelPart = null;
            modelPart = MMDXCore.Instance.ModelPartFactory.Create(triangleCount, Vertices, OpaqueData) as MMDModelPart;
            if (modelPart == null)
            {
                throw new ContentLoadException("MMDXCore.ModelPartFactoryMMDModelPartȊOԂt@Ng[ɂȂĂ܂BXNÃRecpCvCgpꍇMMDModelPartԂt@Ng[ZbgKv܂");
            }
            // read in the BasicEffect as a shared resource
            input.ReadSharedResource<Effect>(fx => modelPart.Effect = fx);

            return modelPart;
        }
    }
}
