﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace MikuMikuDance.XNA.Stages
{
    /// <summary>
    /// ライトの種別
    /// </summary>
    public enum LightType
    {
        /// <summary>
        /// ディレクショナルライト
        /// </summary>
        DirectionalLight = 0,
    }
    /// <summary>
    /// ライトクラス
    /// </summary>
    public struct MMDLight
    {
        /// <summary>
        /// ライトの方向ベクトル
        /// </summary>
        public Vector3 Direction;
        /// <summary>
        /// カラー
        /// </summary>
        /// <remarks>MMDではアクセサリにのみ使用</remarks>
        public Color Color;

        /// <summary>
        /// ライトの種別
        /// </summary>
        public LightType Type;

        internal MMDLight(Vector3 dir, Color color, LightType type)
        {
            Direction = dir;
            Color = color;
            Type = type;
        }
        internal void SetParameters(out Vector3 dir, out Vector3 color)
        {
            dir = Direction;
            dir.Normalize();
            color = Color.ToVector3();
        }
    }
    
}
