﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using MikuMikuDance.XNA.Stages;

namespace MikuMikuDance.XNA.ShadowMap
{
    /// <summary>
    /// シャドウマップマネージャインタフェース
    /// </summary>
    /// <remarks>MMDX内オブジェクトとそれ以外のオブジェクトとの間で正しくシャドウマップを共有するためのインターフェイス。</remarks>
    public interface IShadowMapManager
    {
        /// <summary>
        /// シャドウマップ取得
        /// </summary>
        /// <param name="offset">シャドウマップoffset</param>
        /// <return>テクスチャ</return>
        Texture2D GetShadowMap(out Vector2 offset);
        /// <summary>
        /// シャドウマップ生成用の光源から見たViewProjマトリクスの作成
        /// </summary>
        /// <param name="Camera">カメラ</param>
        /// <param name="LightManager">ライトマネージャ</param>
        /// <param name="graphics">グラフィックデバイス</param>
        /// <param name="View">ViewMatrixの出力</param>
        /// <param name="Proj">ProjMatrixの出力</param>
        void CreateLightViewProjMatrix(IMMDCamera Camera, IMMDLightManager LightManager, GraphicsDevice graphics, out Matrix View, out Matrix Proj);
        
    }
}
