﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;

namespace MikuMikuDance.XNA
{
    /// <summary>
    /// パーツのセンター位置
    /// </summary>
    public class PartCenter
    {
        /// <summary>
        /// パーツのセンター位置
        /// </summary>
        public Vector3 DefaultCenterPos;
        /// <summary>
        /// 計算済み値
        /// </summary>
        internal Vector3 CalcedCenterPos;
        /// <summary>
        /// パーツが透過？
        /// </summary>
        public bool IsTranslucent;
        internal int Order;
        /// <summary>
        /// カメラ空間におけるセンター位置
        /// </summary>
        /// <param name="WorldView"></param>
        public void Calc(ref Matrix WorldView)
        {
            Vector3.Transform(ref DefaultCenterPos, ref WorldView, out CalcedCenterPos);
        }
    }
    class PartCenterCompare : IComparer<PartCenter>
    {
        #region IComparer<PartCenter> メンバ

        public int Compare(PartCenter x, PartCenter y)
        {
            if (x.IsTranslucent == y.IsTranslucent)
                return Math.Sign(x.CalcedCenterPos.Z - y.CalcedCenterPos.Z);
            if (x.IsTranslucent)
                return -1;
            return 1;
        }

        #endregion
    }
}
