﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using DWORD = System.UInt32;

namespace MikuMikuDance.XNA.Motion.MotionData
{
    /// <summary>
    /// カメラモーションデータ
    /// </summary>
    public class MMDCameraMotion
    {
        /// <summary>
        /// フレーム番号
        /// </summary>
        public DWORD FrameNo { get; set; }
        /// <summary>
        /// 距離
        /// </summary>
        public float Length { get; set; }
        /// <summary>
        /// 位置
        /// </summary>
        public Vector3 Location { get; set; }
        /// <summary>
        /// 回転
        /// </summary>
        public Quaternion Quatanion { get; set; }
        /// <summary>
        /// 補完用曲線
        /// </summary>
        /// <remarks>順にX,Y,Z,回転,距離,視野角</remarks>
        public BezierCurve[] Curve { get; set; }
        /// <summary>
        /// 視野角
        /// </summary>
        public float ViewAngle { get; set; }
    }
}
