﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace MikuMikuDance.XNA.Stages
{
    /// <summary>
    /// ライトマネージャクラス
    /// </summary>
    public class MMDLightManager
    {
        const int NumLight = 3;
        Vector3[] m_dir = new Vector3[NumLight], m_color = new Vector3[NumLight], m_spec = new Vector3[NumLight];

        /// <summary>
        /// キーライト
        /// </summary>
        public MMDLight KeyLight = new MMDLight(new Vector3(1, -1, 1),
                 new Color(154, 145, 106));
        /// <summary>
        /// フィルライト
        /// </summary>
        public MMDLight FillLight = new MMDLight(new Vector3(-1, 1, -1),
                new Color(148, 139, 103));
        /// <summary>
        /// バックライト
        /// </summary>
        public MMDLight BackLight = new MMDLight(new Vector3(-1, -1, -1),
                new Color(82, 92, 100));
        /// <summary>
        /// ライト
        /// </summary>
        /// <param name="i">0=キー、1=フィル、2=バック</param>
        /// <returns>ライト構造体</returns>
        public MMDLight this[int i]
        {
            get
            {
                switch (i)
                {
                    case 0:
                        return KeyLight;
                    case 1:
                        return FillLight;
                    case 2:
                        return BackLight;
                }
                throw new ApplicationException();
            }
        }



        internal void GetParameters(out Vector3[] dir, out Vector3[] color)
        {
            dir = m_dir;
            color = m_color;
            for (int i = 0; i < 3; i++)
            {
                this[i].SetParameters(out dir[i], out color[i]);
            }
        }
    }
}
