﻿using System;
using System.Collections.Generic;

namespace MikuMikuDance.XNA.Model.ModelData
{
    /// <summary>
    /// MMD用のIK情報(内部用)
    /// </summary>
    public class MMDIKData
    {
        /// <summary>
        /// IKボーン番号
        /// </summary>
        /// <remarks>この番号で指定されたボーンがIKとなる</remarks>
        public UInt16 IKBoneIndex { get; set; }
        /// <summary>
        /// IKターゲットボーン番号
        /// </summary>
        /// <remarks>IKボーンが最初に接続するボーン</remarks>
        public UInt16 IKTargetBoneIndex { get; set; }
        /// <summary>
        /// 再帰演算回数
        /// </summary>
        public UInt16 Iteration { get; set; }
        /// <summary>
        /// IKの影響度
        /// </summary>
        public float ControlWeight { get; set; }
        /// <summary>
        /// K影響下のボーン番号
        /// </summary>
        public List<UInt16> IKChildBones { get; set; }
    }
}
