using System;
using System.Collections.Generic;
using System.IO;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using MikuMikuDance.XNA.Model.ModelData;
using MMD = MikuMikuDance.Model.Ver1;

using TImport = MikuMikuDance.XNA.Model.MMDModelIntermediate;

// TODO: GbW̏
// TODO: gD[̏

namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// MikuMikuDancẽff[^XNAɃC|[g邽߂̃C|[^
    /// </summary>
    [ContentImporter(".pmd", DisplayName = "MikuMikuDance PMD : MikuMikuDance for XNA", CacheImportedData = true, DefaultProcessor = "MMDProcessor")]
    public class MMDImporter : ContentImporter<TImport>
    {
        /// <summary>
        /// C|[g
        /// </summary>
        /// <param name="filename">t@C</param>
        /// <param name="context">RegC|[^</param>
        /// <returns>MMDf for XNAԃNX</returns>
        /// <remarks>XNÃC|[^Ăяo</remarks>
        public override TImport Import(string filename, ContentImporterContext context)
        {
            //Identityݒ(Rec̃[h̔ʓɕKv)
            ContentIdentity Identity = new ContentIdentity(filename);
            MMD.MMDModel1 model;
            
            //MMDf̓ǂݍ
            //Œӓ_
            //MMD͍WnŁAXNA͉EWnł
            //āASĂZ񂪋tł
            MikuMikuDance.Model.MMDModel modelBase;
            try
            {
                modelBase = MikuMikuDance.Model.ModelManager.Read(filename, MikuMikuDance.Model.CoordinateType.LeftHanded);
            }
            catch (Exception e)
            {
                // Rec ID (sԍ܂) ܂߂ėO񍐂܂
                throw new InvalidContentException(
                    "Unable to load MMD Model file. Exception:\n" + e.Message,
                    Identity, e);
            }
            //MMDo[W`FbN
            if (modelBase.Version != 1.0f)
                throw new InvalidContentException(
                    "This Importer can read only MMD Model ver 1.0.", Identity);
            //o[W`FbN̂MMDVer1ɃLXg
            model = (MMD.MMDModel1)modelBase;

            //bVr_[BbVăfH
            MeshBuilder meshBuilder = MeshBuilder.StartMesh(model.Header.ModelName);
            //_ʂ`FbN
            if (model.Vertexes == null || model.Vertexes.Length == 0)
                throw new InvalidContentException(
                    "There is no Vertex in Model file", Identity);
            if (model.FaceVertexes == null || model.FaceVertexes.Length == 0)
                throw new InvalidContentException(
                    "There is no FaceVertex in Model file", Identity);
            meshBuilder.MergeDuplicatePositions = true;
            
            //烁bVo^Ă
            
            //_o^
            int[] Positions = new int[model.Vertexes.Length];
            for (long i = 0; i < model.Vertexes.LongLength; i++)
            {
                //_o^(Wnϊ)
                Positions[i] = meshBuilder.CreatePosition(new Vector3(model.Vertexes[i].Pos[0], model.Vertexes[i].Pos[1], model.Vertexes[i].Pos[2]));
            }
            
            //eNX`[Wі@p̒_`lǉ
            int texCoordinateIndex = meshBuilder.CreateVertexChannel<Vector2>(VertexChannelNames.TextureCoordinate(0));
            int normalDataIndex = meshBuilder.CreateVertexChannel<Vector3>(VertexChannelNames.Normal(0));
            int weightDataIndex = meshBuilder.CreateVertexChannel<BoneWeightCollection>(VertexChannelNames.Weights(0));
            int ColorDataIndex = meshBuilder.CreateVertexChannel<Vector4>(VertexChannelNames.Color(0));
            //\p_f[^(-1Ȃ\ɗpȂ_A0ȏȂbase̒_ԍ)
            int FaceDataIndex = meshBuilder.CreateVertexChannel<Vector2>(VertexChannelNames.TextureCoordinate(1));
            long FaceIndex = 0;
            //_ԍ\p̒_ԍ̎쐬
            Dictionary<long, long> VertToFaceVert = new Dictionary<long, long>();
            for (int i = 0; i < model.Skins.Length; i++)
            {//baseT
                if (model.Skins[i].SkinType == 0)
                {
                    if (model.Skins[i].SkinVertDatas.LongLength > int.MaxValue)
                        throw new InvalidContentException("base\̒_܂BMikuMikuDanceXNAbase̒_32bitt̍ől܂łT|[gĂ܂", Identity);
                    for (long j = 0; j < model.Skins[i].SkinVertDatas.LongLength; j++)
                    {
                        VertToFaceVert.Add(model.Skins[i].SkinVertDatas[j].SkinVertIndex, j);
                    }
                    break;//łbase
                }
            }
            //}eA
            for (long i = 0; i < model.Materials.LongLength; i++)
            {
                EffectMaterialContent material = new EffectMaterialContent();
                //BasicMaterialContent material = new BasicMaterialContent();
                //Oݒ
                material.Name = "material" + i.ToString();
                //FEݒ
                
                //ݒf[^
                //GbWAgD[
                //model.Vertexes[].EdgeFlag;
                //model.Materials[i].EdgeFlag;
                //model.Materials[i].ToonIndex;
                
                material.OpaqueData.Add("DiffuseColor", new Vector3(model.Materials[i].DiffuseColor[0],
                                model.Materials[i].DiffuseColor[1],
                                model.Materials[i].DiffuseColor[2]));
                material.OpaqueData.Add("EmissiveColor", new Vector3(model.Materials[i].MirrorColor[0],
                                model.Materials[i].MirrorColor[1],
                                model.Materials[i].MirrorColor[2]));
                material.OpaqueData.Add("SpecularColor", new Vector3(model.Materials[i].SpecularCcolor[0],
                                                model.Materials[i].SpecularCcolor[1],
                                                model.Materials[i].SpecularCcolor[2]));
                material.OpaqueData.Add("SpecularPower", model.Materials[i].Specularity);
                material.OpaqueData.Add("Alpha", model.Materials[i].Alpha);
                //GbWAgD[͌ŏcc
                //VF[_΁cc
                
                bool HasTexture = false;
                //eNX`ǂݍ
                if (!string.IsNullOrEmpty(model.Materials[i].TextureFileName))
                {
                    string path = model.Materials[i].TextureFileName;
                    if (!Path.IsPathRooted(path))
                    {
                        path = Path.Combine(Path.GetDirectoryName(filename), path);
                    }
                    if (!File.Exists(path))
                        throw new InvalidContentException(
                            "Cannot find texture file:" + path, Identity);
                    //eNX`̃Zbg
                    if (Path.GetExtension(path).ToLower() == ".sph")
                    {//XtBA}bvB()
                        //ԃfBNgɊgqbmpɕςăRs[()
                        if (!Directory.Exists("ext"))
                            Directory.CreateDirectory("ext");
                        string intFilePath = Path.Combine("ext", Path.GetFileNameWithoutExtension(path) + ".bmp");
                        File.Copy(path, intFilePath, true);//㏑ŃRs[
                        //XtBA}bv(XtBA}bv̓VF[_ŏ̂ŁAtÕf[^)
                        material.OpaqueData.Add("UseSphere", 1.0f);
                        //path̍ւ
                        path = intFilePath;
                    }
                    else
                    {
                        material.OpaqueData.Add("UseSphere", 0.0f);//XtBA}bvgȂ
                    }
                    material.Textures.Add("Texture", new ExternalReference<TextureContent>(path));
                    HasTexture = true;
                }
                else
                {
                    material.OpaqueData.Add("UseSphere", 0.0f);
                }
                for (long k = FaceIndex; k < FaceIndex + model.Materials[i].FaceVertCount; k++)
                {
                    //}eAZbg
                    meshBuilder.SetMaterial(material);
                    //_index擾
                    int VecIndex = model.FaceVertexes[k];
                    //UVW0ԂɃZbg
                    if (HasTexture)
                        meshBuilder.SetVertexChannelData(texCoordinateIndex, new Vector2(model.Vertexes[VecIndex].UV[0], model.Vertexes[VecIndex].UV[1]));
                    else
                        meshBuilder.SetVertexChannelData(texCoordinateIndex, Vector2.Zero);
                    //@Zbg
                    meshBuilder.SetVertexChannelData(normalDataIndex,
                        new Vector3(model.Vertexes[VecIndex].NormalVector[0],
                                    model.Vertexes[VecIndex].NormalVector[1],
                                    model.Vertexes[VecIndex].NormalVector[2]));
                    //{[EFCg
                    BoneWeightCollection boneWeight = new BoneWeightCollection();
                    int boneNum = model.Vertexes[VecIndex].BoneNum[0];
                    if (boneNum >= 0 && boneNum < model.Bones.Length)
                        boneWeight.Add(new BoneWeight(model.Bones[boneNum].BoneName, model.Vertexes[VecIndex].BoneWeight / 100f));
                    boneNum = model.Vertexes[VecIndex].BoneNum[1];
                    if (boneNum >= 0 && boneNum < model.Bones.Length)
                        boneWeight.Add(new BoneWeight(model.Bones[boneNum].BoneName, 1.0f - model.Vertexes[VecIndex].BoneWeight / 100f));
                    
                    meshBuilder.SetVertexChannelData(weightDataIndex, boneWeight);

                    //\p̒_ԍ(base\̔ԍ)UVW1ԂɃZbg
                    if (VertToFaceVert.ContainsKey(VecIndex))
                        meshBuilder.SetVertexChannelData(FaceDataIndex, new Vector2(VertToFaceVert[VecIndex], 0));
                    else
                        meshBuilder.SetVertexChannelData(FaceDataIndex, new Vector2(-1, 0));
                    
                    //J[
                    //MMD̓fBt[YF̃}eAŃJ[ݒ̂ŁAł͔ɂĂ
                    meshBuilder.SetVertexChannelData(ColorDataIndex, new Vector4(255, 255, 255, 0));

                    //ʂ𐶐
                    meshBuilder.AddTriangleVertex(Positions[VecIndex]);
                }
                FaceIndex += model.Materials[i].FaceVertCount;
            }
            MMDModelIntermediate result = new MMDModelIntermediate();
            //{[̐
            List<MMDBoneData> mmdBone;
            BoneContent bone = CreateSkeleton(model, Identity, out mmdBone);
            result.Bones = mmdBone;
            //bV쐬
            MeshContent meshContent = meshBuilder.FinishMesh();
            //bV̐ݒ
            meshContent.Identity = Identity;
            meshContent.Name = model.Header.ModelName;
            //IK̊i[
            //result.IKs = new List<MMDIKData>();
            for (UInt16 i = 0; i < model.IKs.Length; i++)
            {
                MMDIKData ik = new MMDIKData();
                ik.IKBoneIndex = model.IKs[i].IKBoneIndex;
                ik.IKTargetBoneIndex = model.IKs[i].IKTargetBoneIndex;
                ik.Iteration = model.IKs[i].Iterations;
                ik.ControlWeight = model.IKs[i].AngleLimit;
                ik.IKChildBones = new List<ushort>();
                for (byte i2 = 0; i2 < model.IKs[i].IKChildBoneIndex.Length; i2++)
                {
                    ik.IKChildBones.Add(model.IKs[i].IKChildBoneIndex[i2]);
                }
                result.Bones[ik.IKBoneIndex].IK = ik;
            }
            //\̊i[
            result.Skins = new List<MMDSkinData>();
            for (UInt16 i = 0; i < model.Skins.Length; i++)
            {
                MMDSkinData skin = new MMDSkinData();
                skin.Name = model.Skins[i].SkinName;
                skin.SkinType = (MMDSkinType)model.Skins[i].SkinType;
                skin.SkinVerts = new MMDSkinVertData[model.Skins[i].SkinVertDatas.LongLength];
                for (UInt32 i2 = 0; i2 < model.Skins[i].SkinVertDatas.LongLength; i2++)
                {
                    skin.SkinVerts[i2] = new MMDSkinVertData();
                    skin.SkinVerts[i2].VertIndex = model.Skins[i].SkinVertDatas[i2].SkinVertIndex;
                    skin.SkinVerts[i2].Pos = new float[model.Skins[i].SkinVertDatas[i2].SkinVertPos.Length];
                    for (int i3 = 0; i3 < 3; i3++)
                        skin.SkinVerts[i2].Pos[i3] = model.Skins[i].SkinVertDatas[i2].SkinVertPos[i3];
                }
                result.Skins.Add(skin);
            }
            //\pɗpbaseS_i[
            result.NumVertexForFace = VertToFaceVert.Count;

            //Zf[^i[
            //if (model.RigidBodies!=null && model.RigidBodies.LongLength > int.MaxValue)
            //    throw new InvalidContentException("Zp̍̐BulletX̓sɂ"
            //            + int.MaxValue.ToString() + "EłB̃f" + model.RigidBodies.LongLength + "̍̂܂܂Ă܂", Identity);
            //if (model.RigidBodies != null &&  model.Joints.LongLength > int.MaxValue)
            //    throw new InvalidContentException("ZpJointBulletX̓sɂ"
            //            + int.MaxValue.ToString() + "EłB̃f" + model.Joints.LongLength + "̍̂܂܂Ă܂", Identity);
            result.Rigids = new List<MMDRigid>();
            if (model.RigidBodies != null)
            {
                for (UInt32 i = 0; i < model.RigidBodies.LongLength; i++)
                {
                    MMDRigid rigid = new MMDRigid();
                    rigid.AngularDamping = model.RigidBodies[i].AngularDamping;
                    rigid.Friction = model.RigidBodies[i].Friction;
                    rigid.GroupIndex = model.RigidBodies[i].GroupIndex;
                    rigid.GroupTarget = model.RigidBodies[i].GroupTarget;
                    rigid.LinerDamping = model.RigidBodies[i].LinerDamping;
                    rigid.Name = model.RigidBodies[i].Name;
                    rigid.Position = new float[model.RigidBodies[i].Position.Length];
                    for (int j = 0; j < rigid.Position.Length; j++)
                        rigid.Position[j] = model.RigidBodies[i].Position[j];
                    rigid.RelatedBoneIndex = model.RigidBodies[i].RelatedBoneIndex;
                    rigid.Restitution = model.RigidBodies[i].Restitution;
                    rigid.Rotation = new float[model.RigidBodies[i].Rotation.Length];
                    for (int j = 0; j < rigid.Rotation.Length; j++)
                        rigid.Rotation[j] = model.RigidBodies[i].Rotation[j];
                    rigid.ShapeDepth = model.RigidBodies[i].ShapeDepth;
                    rigid.ShapeHeight = model.RigidBodies[i].ShapeHeight;
                    rigid.ShapeType = model.RigidBodies[i].ShapeType;
                    rigid.ShapeWidth = model.RigidBodies[i].ShapeWidth;
                    rigid.Type = model.RigidBodies[i].Type;
                    rigid.Weight = model.RigidBodies[i].Weight;
                    result.Rigids.Add(rigid);
                }
            }
            result.Joints = new List<MMDJoint>();
            if (model.Joints != null)
            {
                for (UInt32 i = 0; i < model.Joints.LongLength; i++)
                {
                    MMDJoint joint = new MMDJoint();
                    joint.ConstrainPosition1 = new float[model.Joints[i].ConstrainPosition1.Length];
                    for (int j = 0; j < joint.ConstrainPosition1.Length; j++)
                        joint.ConstrainPosition1[j] = model.Joints[i].ConstrainPosition1[j];
                    joint.ConstrainPosition2 = new float[model.Joints[i].ConstrainPosition2.Length];
                    for (int j = 0; j < joint.ConstrainPosition2.Length; j++)
                        joint.ConstrainPosition2[j] = model.Joints[i].ConstrainPosition2[j];
                    joint.ConstrainRotation1 = new float[model.Joints[i].ConstrainRotation1.Length];
                    for (int j = 0; j < joint.ConstrainRotation1.Length; j++)
                        joint.ConstrainRotation1[j] = model.Joints[i].ConstrainRotation1[j];
                    joint.ConstrainRotation2 = new float[model.Joints[i].ConstrainRotation2.Length];
                    for (int j = 0; j < joint.ConstrainRotation2.Length; j++)
                        joint.ConstrainRotation2[j] = model.Joints[i].ConstrainRotation2[j];
                    joint.Name = model.Joints[i].Name;
                    joint.Position = new float[model.Joints[i].Position.Length];
                    for (int j = 0; j < joint.Position.Length; j++)
                        joint.Position[j] = model.Joints[i].Position[j];
                    joint.RigidBodyA = model.Joints[i].RigidBodyA;
                    joint.RigidBodyB = model.Joints[i].RigidBodyB;
                    joint.Rotation = new float[model.Joints[i].Rotation.Length];
                    for (int j = 0; j < joint.Rotation.Length; j++)
                        joint.Rotation[j] = model.Joints[i].Rotation[j];
                    joint.SpringPosition = new float[model.Joints[i].SpringPosition.Length];
                    for (int j = 0; j < joint.SpringPosition.Length; j++)
                        joint.SpringPosition[j] = model.Joints[i].SpringPosition[j];
                    joint.SpringRotation = new float[model.Joints[i].SpringRotation.Length];
                    for (int j = 0; j < joint.SpringRotation.Length; j++)
                        joint.SpringRotation[j] = model.Joints[i].SpringRotation[j];
                    result.Joints.Add(joint);
                }
            }
            //[gm[h𐶐āAbVƃ{[i[
            NodeContent nodeContent = new NodeContent();
            nodeContent.Identity = Identity;
            nodeContent.Children.Add(meshContent);//bV
            nodeContent.Children.Add(bone);//{[
            
            //MMDԃfɃ[gm[hi[
            result.RootNode = nodeContent;
            result.Identity = Identity;
            
            //[gm[hԋp
            return result;
        }

        private BoneContent CreateSkeleton(MikuMikuDance.Model.Ver1.MMDModel1 model, ContentIdentity Identity, out List<MMDBoneData> mmdBones)
        {
            //{[ꗗ
            List<MMDBoneSetIntermediate> bones = new List<MMDBoneSetIntermediate>();
            mmdBones = new List<MMDBoneData>();
            //{[ꗗ𐶐
            for (UInt16 i = 0; i < model.Bones.Length; i++)
            {
                bones.Add(new MMDBoneSetIntermediate(model.Bones[i]));
                //XNÃ{[ŏȂf[^MMDBoneNXɓ
                MMDBoneData mmdBone = new MMDBoneData();
                mmdBone.Name = model.Bones[i].BoneName;
                if (mmdBone.Name == "")
                    throw new InvalidContentException(
                    "All bones need to be named.", Identity);
                mmdBone.BoneType=(MMDBoneType)model.Bones[i].BoneType;
                mmdBone.IKParentBoneIndex = model.Bones[i].IKParentBoneIndex;
                mmdBones.Add(mmdBone);
            }
            //Ń{[gݗĂ
            //[g{[𐶐
            BoneContent rootBone = new BoneContent();
            UInt16 rootBoneIndex = UInt16.MaxValue;
            rootBone.Name = "root";
            rootBone.Identity = Identity;
            //root(0,0,0)?
            rootBone.Transform = Matrix.CreateFromYawPitchRoll(0, 0, 0) * Matrix.CreateTranslation(0, 0, 0);
            //[g{[ɑgݗĂ
            try
            {
                BuildSkelton(rootBone, rootBoneIndex, bones);
            }
            catch (StackOverflowException e)
            {
                throw new InvalidContentException("bone tree was looped", Identity, e);
            }

            //[g{[ɑgݗĂĂ̂łԋp
            return rootBone;
        }

        private void BuildSkelton(BoneContent ParentBone, UInt16 ParentBoneIndex, List<MMDBoneSetIntermediate> bones)
        {
            //܂͐e{[ԍɌ
            for (UInt16 i = 0; i < bones.Count; i++)
            {
                if (bones[i].BoneParent == ParentBoneIndex)
                {//q{[𔭌
                    //܂͐e{[̐΍sɎq̍sC
                    Matrix parent = ParentBone.AbsoluteTransform;
                    //Ɏq̍sݒ
                    //e̐΍s*q̍s=q̐΍sAq̍s=e̐΍sts*q̐΍s
                    bones[i].Bone.Transform = Matrix.Invert(parent) * bones[i].Bone.Transform;
                    //eɓo^
                    ParentBone.Children.Add(bones[i].Bone);
                    //ċAIɒ
                    BuildSkelton(bones[i].Bone, i, bones);
                }
            }
        }
    }
}
