/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.model;

import java.util.ArrayList;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.pmx.BoneFlags;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Model;

public class Bone {
    protected Model model;
    protected String name = null;
    protected short flags;
    protected int id;
    private String parent = null;
    private String linkParent = null;
    private ArrayList<Bone> children = new ArrayList();
    private ArrayList<BoneLink> linkChildren = new ArrayList();
    Vector3D gv = new Vector3D(0.0, 0.0, 0.0);
    private Matrix g_mr = new Matrix();
    private Vector3D v = new Vector3D();
    private Matrix mr = new Matrix();
    private Matrix ini_mr = new Matrix();
    protected Vector3D limitRot = null;
    protected boolean changed = false;

    public Bone(Model m) {
        this.model = m;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public short getFlags() {
        return this.flags;
    }

    public int hashCode() {
        if (this.model == null) {
            return 0;
        }
        if (this.name == null) {
            return 0;
        }
        return (this.model.getName() + "/" + this.name).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bone other = (Bone)obj;
        if (this.model != other.model && (this.model == null || this.model.getName().compareTo(other.model.getName()) != 0)) {
            return false;
        }
        return !(this.name != null ? this.name.compareTo(other.name) == 0 : other.name != null);
    }

    public String getParent() {
        return this.parent;
    }

    public String getLinkParent() {
        return this.linkParent;
    }

    public Bone addChild(Bone child) {
        child.parent = this.name;
        this.children.add(child);
        return this;
    }

    public Bone removeChild(Bone child) {
        int i = this.children.indexOf(child);
        if (i >= 0) {
            this.children.remove(i);
            child.parent = null;
            return this;
        }
        return null;
    }

    public Bone addLinkChild(Bone child, double translation, double rotation) {
        child.linkParent = this.name;
        this.linkChildren.add(new BoneLink(child, translation, rotation));
        return this;
    }

    public void addExternalChild(Bone child) {
        this.children.add(child);
        Vector3D cv = this.getPos();
        Matrix cm = this.getGMatrix();
        child.translationToG(cv);
        child.rotateToG(cm);
        child.v = new Vector3D();
        child.mr = new Matrix();
        child.gv = cv;
        child.g_mr = cm;
    }

    void setInicialLocalCoordinate(Vector3D lx, Vector3D lz) {
        this.mr = this.ini_mr = new Matrix(lx, lz);
    }

    public Vector3D getPos() {
        Vector3D g = this.g_mr.times(this.v).add(this.gv);
        return g;
    }

    public Matrix getGMatrix() {
        return this.g_mr.times(this.mr);
    }

    public Vector3D getLPos() {
        return this.v;
    }

    public Matrix getMatrix() {
        return this.mr;
    }

    public Vector3D getLimitRot() {
        return this.limitRot;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public void setChanged() {
        this.changed = true;
    }

    public void resetChanged() {
        this.changed = false;
    }

    public void translationTo(Vector3D lv) {
        Vector3D gtv = this.g_mr.times(lv.sub(this.v));
        for (Bone c : this.children) {
            c.translationG(gtv);
        }
        for (BoneLink l : this.linkChildren) {
            if (l.linkedT == 0.0) continue;
            l.child.translationG(gtv.times(l.linkedT));
        }
        this.v = lv;
        this.changed = true;
    }

    public void translationToG(Vector3D gpv) {
        this.translationTo(this.g_mr.inverse().times(gpv.sub(this.gv)));
    }

    private void translationG(Vector3D dv) {
        for (Bone c : this.children) {
            c.translationG(dv);
        }
        this.gv = this.gv.add(dv);
    }

    public Vector3D getLx() {
        return this.g_mr.times(this.mr.getLx());
    }

    public Vector3D getLy() {
        return this.g_mr.times(this.mr.getLy());
    }

    public Vector3D getLz() {
        return this.g_mr.times(this.mr.getLz());
    }

    public void rotate(Vector3D axis_sin, double co) {
        if (new Vector3D().equals(axis_sin)) {
            return;
        }
        Matrix dr = this.mr.inverse().times(this.g_mr.inverse());
        Vector3D lsin = this.g_mr.inverse().times(axis_sin);
        this.mr = this.mr.rotate(lsin, co);
        dr = this.g_mr.times(this.mr).times(dr);
        Vector3D center = this.getPos();
        for (Bone c : this.children) {
            c.rotateChild(dr, center);
        }
        for (BoneLink l : this.linkChildren) {
            double sine = axis_sin.norm();
            if (l.linkedR == 0.0) continue;
            double angle = Math.atan2(co, sine) * l.linkedR;
            double[] r = axis_sin.times(Math.sin(angle) / sine).toDouble();
            l.child.rotateL(Matrix.rotationQ(r[0], r[1], r[2], Math.cos(angle)));
        }
        this.changed = true;
    }

    public void rotate(Matrix dmr) {
        Matrix dr = this.mr.inverse().times(this.g_mr.inverse());
        this.mr = this.mr.times(dmr);
        dr = this.g_mr.times(this.mr).times(dr);
        Vector3D center = this.getPos();
        for (Bone c : this.children) {
            c.rotateChild(dr, center);
        }
        for (BoneLink l : this.linkChildren) {
            if (l.linkedR == 0.0) continue;
            l.child.rotateL(dmr.power(l.linkedR));
        }
        this.changed = true;
    }

    private void rotateChild(Matrix dmr, Vector3D center) {
        this.g_mr = dmr.times(this.g_mr);
        this.gv = dmr.times(this.gv.sub(center)).add(center);
        for (Bone c : this.children) {
            c.rotateChild(dmr, center);
        }
    }

    void moveMorph(Vector3D dv, Matrix dmr) {
        for (Bone c : this.children) {
            c.translationG(dv);
        }
        this.gv = this.gv.add(dv);
        Matrix gdmr = this.g_mr.times(dmr.times(this.g_mr.inverse()));
        this.g_mr = gdmr.times(this.g_mr);
        Vector3D center = this.gv;
        for (Bone c : this.children) {
            c.rotateChild(gdmr, center);
        }
    }

    private void rotateL(Matrix dmr) {
        this.ini_mr = this.ini_mr.times(dmr);
        this.mr = this.mr.times(dmr);
        Vector3D center = this.getPos();
        for (Bone c : this.children) {
            c.rotateChild(dmr, center);
        }
    }

    public void rotateTo(Matrix m) {
        Matrix dmr = this.mr.inverse().times(m.times(this.ini_mr));
        this.rotate(dmr);
    }

    public void rotateToG(Matrix gm) {
        Matrix dmr = this.mr.inverse().times(this.g_mr.inverse()).times(gm);
        this.rotate(dmr);
    }

    public void setPose(BonePose p) {
        if (p.nameOfBone.compareTo(this.name) != 0) {
            return;
        }
        if (!this.mr.equals(p.mr)) {
            this.rotateTo(p.mr);
        }
        if (!this.v.equals(p.v)) {
            this.translationTo(p.v);
        }
    }

    public BonePose getPose() {
        BonePose p = new BonePose();
        p.nameOfBone = this.name;
        p.v = this.v;
        p.mr = this.mr.times(this.ini_mr.inverse());
        return p;
    }

    public BonePose getCoordinate() {
        BonePose p = new BonePose();
        p.nameOfBone = "\u539f\u70b91";
        p.v = this.getPos();
        p.mr = this.getGMatrix();
        return p;
    }

    public String toString() {
        String ret = this.name + ":\n";
        ret = ret + "\tV:" + this.v + "\n";
        ret = ret + "\tM:" + this.mr + "\n";
        ret = ret + "\tinit_M:" + this.ini_mr + "\n";
        double[] rv = this.mr.angles();
        ret = ret + "\tA:" + rv[0] + "," + rv[1] + "," + rv[2] + "\n";
        return ret;
    }

    public static Bone fromCSV(Model m, String line) throws MmdFormatException {
        String[] p = CsvSpliter.split(line);
        if (p.length < 39) {
            return null;
        }
        if (p[0].compareTo("Bone") != 0) {
            throw new MmdFormatException("not Bone line");
        }
        Bone ret = new Bone(m);
        ret.name = p[1];
        try {
            ret.gv = new Vector3D(Double.parseDouble(p[5]), Double.parseDouble(p[6]), Double.parseDouble(p[7]));
        }
        catch (NumberFormatException ex) {
            throw new MmdFormatException("Number error in " + ret.name + "'s corrdinate.");
        }
        ret.flags = (short)((p[8].contentEquals("1") ? BoneFlags.ROTATE.encode() : (short)0) + (p[9].contentEquals("1") ? BoneFlags.MOVE.encode() : (short)0) + (p[10].contentEquals("1") ? BoneFlags.IK.encode() : (short)0) + (p[11].contentEquals("1") ? BoneFlags.VISIBLE.encode() : (short)0) + (p[12].contentEquals("1") ? BoneFlags.OP.encode() : (short)0) + (p[14].contentEquals("1") ? BoneFlags.OFFSET.encode() : (short)0) + (p[19].contentEquals("1") ? BoneFlags.LINK_FLAG.encode() : (short)0) + (p[20].contentEquals("1") ? BoneFlags.ROTATE_LINK.encode() : (short)0) + (p[21].contentEquals("1") ? BoneFlags.MOVE_LINK.encode() : (short)0) + (p[24].contentEquals("1") ? BoneFlags.AXIS_ROTATE.encode() : (short)0) + (p[28].contentEquals("1") ? BoneFlags.LOCAL_AXIS.encode() : (short)0));
        if (p[13].length() != 0) {
            ret.model.get(p[13]).addChild(ret);
        }
        if (p[23].length() != 0) {
            double rate = Double.parseDouble(p[22]);
            ret.model.get(p[23]).addLinkChild(ret, p[21].startsWith("1") ? rate : 0.0, p[20].startsWith("1") ? rate : 0.0);
        }
        if (p[24].equals("1")) {
            ret.limitRot = new Vector3D(Double.parseDouble(p[25]), Double.parseDouble(p[26]), Double.parseDouble(p[27]));
        }
        if (p[28].equals("1")) {
            Vector3D lz;
            Vector3D lx;
            try {
                lx = new Vector3D(Double.parseDouble(p[29]), Double.parseDouble(p[30]), Double.parseDouble(p[31]));
                lz = new Vector3D(-Double.parseDouble(p[32]), -Double.parseDouble(p[33]), -Double.parseDouble(p[34]));
            }
            catch (NumberFormatException ex) {
                System.err.println("Number error in " + ret.name + "'s matrix.");
                return ret;
            }
            ret.setInicialLocalCoordinate(lx, lz);
        }
        return ret;
    }

    protected final class BoneLink {
        private final Bone child;
        private final double linkedT;
        private final double linkedR;

        protected BoneLink(Bone c, double translation, double rotation) {
            this.child = c;
            this.linkedT = translation;
            this.linkedR = rotation;
        }
    }
}

