/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.xml;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import jp.sfjp.mikutoga.xml.XmlExporter;

abstract class AbstractXmlExporter
implements XmlExporter {
    private static final String DEF_NL = "\n";
    private static final String DEF_INDENT_UNIT = "  ";
    private static final char CH_SP = ' ';
    private static final char CH_YEN = '\u00a5';
    private static final char CH_BSLASH = '\\';
    private static final char CH_DQ = '\"';
    private static final char CH_SQ = '\'';
    private static final char CH_EQ = '=';
    private static final char CH_LT = '<';
    private static final char CH_GT = '>';
    private static final String COMM_START = "<!--";
    private static final String COMM_END = "-->";
    private static final Pattern NUM_FUZZY = Pattern.compile("([^.]*\\.[0-9][0-9]*?)0+");
    private static final String REF_HEX = "&#x";
    private static final int HEX_EXP = 4;
    private static final int MASK_1HEX = 15;
    private static final int MAX_OCTET = 255;
    private static final char[] HEXCHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private boolean basicLatinOnlyOut = true;
    private String newline = "\n";
    private String indentUnit = "  ";
    private int indentNest = 0;

    protected AbstractXmlExporter() {
    }

    protected static boolean isBasicLatin(char ch) {
        return '\u0000' <= ch && ch <= '\u007f';
    }

    protected static String chopFuzzyZero(String numTxt) {
        Matcher matcher = NUM_FUZZY.matcher(numTxt);
        String result = matcher.matches() ? matcher.group(1) : numTxt;
        return result;
    }

    @Override
    public abstract Appendable append(char var1) throws IOException;

    @Override
    public abstract Appendable append(CharSequence var1) throws IOException;

    @Override
    public abstract Appendable append(CharSequence var1, int var2, int var3) throws IOException;

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public XmlExporter putRawCh(char ch) throws IOException {
        this.append(ch);
        return this;
    }

    @Override
    public XmlExporter putRawText(CharSequence seq) throws IOException {
        this.append(seq);
        return this;
    }

    @Override
    public XmlExporter sp() throws IOException {
        this.putRawCh(' ');
        return this;
    }

    @Override
    public XmlExporter sp(int count) throws IOException {
        for (int ct = 1; ct <= count; ++ct) {
            this.sp();
        }
        return this;
    }

    @Override
    public String getNewLine() {
        return this.newline;
    }

    @Override
    public void setNewLine(String newLine) throws NullPointerException {
        if (newLine == null) {
            throw new NullPointerException();
        }
        this.newline = newLine;
    }

    @Override
    public XmlExporter ln() throws IOException {
        this.putRawText(this.getNewLine());
        return this;
    }

    @Override
    public XmlExporter ln(int count) throws IOException {
        for (int ct = 1; ct <= count; ++ct) {
            this.ln();
        }
        return this;
    }

    @Override
    public String getIndentUnit() {
        return this.indentUnit;
    }

    @Override
    public void setIndentUnit(String indUnit) throws NullPointerException {
        if (indUnit == null) {
            throw new NullPointerException();
        }
        this.indentUnit = indUnit;
    }

    @Override
    public void pushNest() {
        ++this.indentNest;
    }

    @Override
    public void popNest() {
        --this.indentNest;
        if (this.indentNest < 0) {
            this.indentNest = 0;
        }
    }

    @Override
    public int getIndentLevel() {
        return this.indentNest;
    }

    @Override
    public XmlExporter ind() throws IOException {
        int level = this.getIndentLevel();
        for (int ct = 1; ct <= level; ++ct) {
            this.putRawText(this.getIndentUnit());
        }
        return this;
    }

    @Override
    public boolean isBasicLatinOnlyOut() {
        return this.basicLatinOnlyOut;
    }

    @Override
    public void setBasicLatinOnlyOut(boolean bool) {
        this.basicLatinOnlyOut = bool;
    }

    @Override
    public XmlExporter putCharRef2Hex(char ch) throws IOException {
        if (ch > 255) {
            return this.putCharRef4Hex((char)ch);
        }
        int ibits = ch;
        int idx4 = ibits & 0xF;
        int idx3 = (ibits >>= 4) & 0xF;
        char hex3 = HEXCHAR_TABLE[idx3];
        char hex4 = HEXCHAR_TABLE[idx4];
        this.putRawText(REF_HEX).putRawCh(hex3).putRawCh(hex4).putRawCh(';');
        return this;
    }

    @Override
    public XmlExporter putCharRef4Hex(char ch) throws IOException {
        int ibits = ch;
        int idx4 = ibits & 0xF;
        int idx3 = (ibits >>= 4) & 0xF;
        int idx2 = (ibits >>= 4) & 0xF;
        int idx1 = (ibits >>= 4) & 0xF;
        char hex1 = HEXCHAR_TABLE[idx1];
        char hex2 = HEXCHAR_TABLE[idx2];
        char hex3 = HEXCHAR_TABLE[idx3];
        char hex4 = HEXCHAR_TABLE[idx4];
        this.putRawText(REF_HEX).putRawCh(hex1).putRawCh(hex2).putRawCh(hex3).putRawCh(hex4).putRawCh(';');
        return this;
    }

    @Override
    public XmlExporter putCh(char ch) throws IOException {
        String escTxt;
        if (Character.isISOControl(ch)) {
            this.putCharRef2Hex(ch);
            return this;
        }
        switch (ch) {
            case '&': {
                escTxt = "&amp;";
                break;
            }
            case '<': {
                escTxt = "&lt;";
                break;
            }
            case '>': {
                escTxt = "&gt;";
                break;
            }
            case '\"': {
                escTxt = "&quot;";
                break;
            }
            case '\'': {
                escTxt = "&apos;";
                break;
            }
            default: {
                escTxt = null;
            }
        }
        if (escTxt != null) {
            this.putRawText(escTxt);
        } else {
            this.putRawCh(ch);
        }
        return this;
    }

    @Override
    public XmlExporter putContent(CharSequence content) throws IOException {
        int length = content.length();
        char prev = '\u0000';
        for (int pos = 0; pos < length; ++pos) {
            char ch = content.charAt(pos);
            if (this.isBasicLatinOnlyOut() && !AbstractXmlExporter.isBasicLatin(ch)) {
                this.putCharRef4Hex(ch);
            } else if (ch == '\u00a5') {
                this.putRawCh('\\');
            } else if (Character.isSpaceChar(ch)) {
                if (ch == ' ' && prev != ' ') {
                    this.putRawCh(ch);
                } else {
                    this.putCharRef2Hex(ch);
                }
            } else {
                this.putCh(ch);
            }
            prev = ch;
        }
        return this;
    }

    @Override
    public XmlExporter putCommentContent(CharSequence comment) throws IOException {
        int length = comment.length();
        char prev = '\u0000';
        for (int pos = 0; pos < length; ++pos) {
            char ch = comment.charAt(pos);
            if (ch == '\n') {
                this.ln();
            } else if ('\u0000' <= ch && ch <= '\u001f') {
                this.putRawCh((char)(9216 + ch));
            } else if (ch == '\u007f') {
                this.putRawCh('\u2421');
            } else if (prev == '-' && ch == '-') {
                this.sp().putRawCh(ch);
            } else {
                this.putRawCh(ch);
            }
            prev = ch;
        }
        return this;
    }

    @Override
    public XmlExporter putLineComment(CharSequence comment) throws IOException {
        this.putRawText(COMM_START).sp();
        this.putCommentContent(comment);
        this.sp().putRawText(COMM_END);
        return this;
    }

    @Override
    public XmlExporter putBlockComment(CharSequence comment) throws IOException {
        char lastCh;
        this.putRawText(COMM_START).ln();
        this.putCommentContent(comment);
        int commentLength = comment.length();
        if (commentLength > 0 && (lastCh = comment.charAt(commentLength - 1)) != '\n') {
            this.ln();
        }
        this.putRawText(COMM_END).ln();
        return this;
    }

    @Override
    public XmlExporter putOpenSTag(CharSequence tagName) throws IOException {
        this.putRawCh('<');
        this.putRawText(tagName);
        return this;
    }

    @Override
    public XmlExporter putCloseSTag() throws IOException {
        this.putRawCh('>');
        return this;
    }

    @Override
    public XmlExporter putSimpleSTag(CharSequence tagName) throws IOException {
        this.putRawCh('<');
        this.putRawText(tagName);
        this.putRawCh('>');
        return this;
    }

    @Override
    public XmlExporter putETag(CharSequence tagName) throws IOException {
        this.putRawText("</");
        this.putRawText(tagName);
        this.putRawCh('>');
        return this;
    }

    @Override
    public XmlExporter putSimpleEmpty(CharSequence tagName) throws IOException {
        this.putRawCh('<');
        this.putRawText(tagName).sp();
        this.putCloseEmpty();
        return this;
    }

    @Override
    public XmlExporter putCloseEmpty() throws IOException {
        this.putRawText("/>");
        return this;
    }

    @Override
    public XmlExporter putXsdInt(int iVal) throws IOException {
        String value = DatatypeConverter.printInt((int)iVal);
        this.putRawText(value);
        return this;
    }

    @Override
    public XmlExporter putXsdFloat(float fVal) throws IOException {
        String value = DatatypeConverter.printFloat((float)fVal);
        value = AbstractXmlExporter.chopFuzzyZero(value);
        this.putRawText(value);
        return this;
    }

    @Override
    public XmlExporter putIntAttr(CharSequence attrName, int iVal) throws IOException {
        this.putRawText(attrName).putRawCh('=');
        this.putRawCh('\"');
        this.putXsdInt(iVal);
        this.putRawCh('\"');
        return this;
    }

    @Override
    public XmlExporter putFloatAttr(CharSequence attrName, float fVal) throws IOException {
        this.putRawText(attrName).putRawCh('=');
        this.putRawCh('\"');
        this.putXsdFloat(fVal);
        this.putRawCh('\"');
        return this;
    }

    @Override
    public XmlExporter putAttr(CharSequence attrName, CharSequence content) throws IOException {
        this.putRawText(attrName).putRawCh('=');
        this.putRawCh('\"');
        this.putContent(content);
        this.putRawCh('\"');
        return this;
    }

    static {
        assert (HEXCHAR_TABLE.length == 16);
    }
}

