/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion.midi;

import javax.sound.midi.MidiEvent;
import jp.sourceforge.mmd.midiMotion.midi.MidiComparator;

public class MidiRelation
implements Comparable<MidiRelation> {
    private MidiEvent noteOn = null;
    private MidiEvent noteOff = null;
    private long length = -1L;
    private final MidiComparator comparator = new MidiComparator();

    public void setNoteOn(MidiEvent mm) {
        this.noteOn = mm;
        if (this.noteOff != null) {
            this.length = this.noteOff.getTick() - this.noteOn.getTick();
        }
    }

    public void setNoteOff(MidiEvent mm) {
        this.noteOff = mm;
        if (this.noteOn != null) {
            this.length = this.noteOff.getTick() - this.noteOn.getTick();
        }
    }

    public MidiEvent getNoteOn() {
        return this.noteOn;
    }

    public MidiEvent getNoteOff() {
        return this.noteOff;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public int compareTo(MidiRelation o) {
        int ret;
        if (this.noteOn == null) {
            ret = o.noteOn == null ? 0 : -1;
        } else {
            int n = ret = o.noteOn == null ? 1 : (int)(this.noteOn.getTick() - o.noteOn.getTick());
        }
        if (ret != 0) {
            return ret;
        }
        ret = this.noteOff == null ? (o.noteOff == null ? 0 : -1) : (o.noteOff == null ? 1 : this.comparator.compare(this.noteOff, o.noteOff));
        return ret;
    }
}

