/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * ファイルのドロップだけ受け付けるドロップターゲット.
 * @author nazo
 */
public class FileDropTarget extends DropTarget {
    private FileDropListener fdl;
    /**
     * ドロップされたファイルリストだけ受け取るListenerを登録.
     * @param l ファイルのリストを受け取る Listener.
     */
    public FileDropTarget(FileDropListener l){
        super();
        fdl=l;
    }

    /**
     * ドロップされたときに呼び指されるイベントハンドラ.
     * {@link FileDropListener#fileDrop(FileDropEvent)} はここから呼び出される.
     * @param dtde ドロップイベント.
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable t = dtde.getTransferable();
        if (!t.isDataFlavorSupported(DataFlavor.javaFileListFlavor))return;
        dtde.acceptDrop(DnDConstants.ACTION_REFERENCE);
        try {
            @SuppressWarnings("unchecked")
            List<File> list = (List<File>)t.getTransferData(DataFlavor.javaFileListFlavor);
            fdl.fileDrop(new FileDropEvent(getComponent(), list.toArray(new File[list.size()])));
            dtde.dropComplete(true);
        } catch (UnsupportedFlavorException e) {
        } catch (IOException ex) {
            Logger.getLogger(FileDropTarget.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
}
