/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion;

import java.util.LinkedList;

/**
 * CSV を分けるための関数群. 全部 static method.
 * @author nazo
 */
public class CsvSpliter {
    /**
     * String 1行を CSV ルールに従って分ける.
     * ルール1: カンマで分ける.
     * ルール2: 文字列セルは"で始まった場合、"まで終わらない
     * それ以外の文字で始まったら、カンマまでが文字列で,
     * "を文字にすることができる.
     * @param line 1行文字列
     * @return 分けられた文字列
     */
    static public String [] split(String line){
        LinkedList<String> list=new LinkedList<String>();
        int i=0,j,l=line.length();
        while(i<l){
            if(line.charAt(i)=='"'){
                j=line.indexOf('"', i+1);
                if(j<0){
                    list.add(line.substring(i+1));
                    break;
                }
                if(j==l-1 || line.charAt(j+1)==','){
                    list.add(line.substring(i+1, j));
                }
                if(j==l-1){break;
                }else{
                    i=j+2;
                }
            }else {
                j=line.indexOf(",", i);
                if(j<0){
                    list.add(line.substring(i));
                    break;
                }else {
                    list.add(line.substring(i, j));
                    i=j+1;
                }
            }
        }
        return list.toArray(new String[list.size()]);
    }
}
