/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.ik_solver;

import java.util.ArrayList;
import javax.swing.AbstractListModel;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;

/**
 * ボーンの親のリスト. 指定したボーンの祖先を「全ての親」まで
 * 親子関係が近い順に並べるリストモデル.
 * @author nazo
 */
public class ParentBoneListModel extends AbstractListModel<Object[]>{
    private Object[][] entries=null;
    protected Model model;

    /** MMD モデルを設定する.
     * @param model MMDモデル. ボーンの種類とかの判別に使われる.
     * 設定すると{@link #removeAll() } される.
     */
    void setMMDModel(Model model) {
        removeAll();
        this.model=model;
    }

    /**
     * 要素数を返す.
     * @return 要素数.
     */
    @Override
    public int getSize() {
        if(entries==null)return 0;
        return entries.length;
    }

    @Override
    public Object [] getElementAt(int index) {
        if(entries==null)return null;
        return entries[index];
    }
    public ParentBoneListModel(Object[][] n){
        entries=n;
    }
    public void removeAll(){
        if(entries==null)return;
        int n=entries.length;
        entries=null;
        fireIntervalRemoved(this, 0, n);
    }

    /** MMD ボーンを設定する.
     * 設定すると{@link #removeAll() } され, 新しいリストができる.
     * @param boneName 基準になるMMDボーンの名前.
     */
    void setMMDBone(String boneName) {
        removeAll();
        Bone bone=model.get(boneName);
        if(bone==null)return;
        ArrayList <Object []> al=new ArrayList<Object []>();
        int j=0;
        while(true){
            boneName=bone.getParent();
            if(boneName==null)break;
            bone=model.get(boneName);
            al.add(new Object[]{boneName,j,bone.getLimitRot()!=null});
            j++;
        }
        entries=al.toArray(new Object[al.size()][]);
        fireIntervalAdded(this, 0, entries.length);
    }
}
