/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.ik_solver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.ik_solver.BoneTableModel;
import jp.sourceforge.mmd.ik_solver.IKSolver;
import jp.sourceforge.mmd.ik_solver.ParentBoneListModel;
import jp.sourceforge.mmd.ik_solver.ParentBoneRenderer;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;
import jp.sourceforge.mmd.motion.swing.AboutDialog;
import jp.sourceforge.mmd.motion.swing.BoneComboBox;
import jp.sourceforge.mmd.motion.swing.FileDropEvent;
import jp.sourceforge.mmd.motion.swing.FileDropListener;
import jp.sourceforge.mmd.motion.swing.FileDropTarget;
import jp.sourceforge.mmd.motion.swing.MmdDialog;
import jp.sourceforge.mmd.motion.swing.VMD2CSV;

public class IKSolver_GUI
extends JFrame
implements FileDropListener {
    private IKSolver ikSolver;
    private Model IKmodel;
    private Motion IKMotion;
    private Motion resultMotion;
    private Model targetModel;
    private Motion targetMotion;
    private File motionOutFile = new File(".");
    private JButton buttonInsert;
    private JButton buttonOpenIKModel;
    private JButton buttonOpenIKMotion;
    private JButton buttonOpenTargetModel;
    private JButton buttonOpenTargetMotion;
    private JButton buttonRemove;
    private JButton buttonSave;
    private JButton buttonSolve;
    private JCheckBox checkInterp;
    private JCheckBox checkNoGlobalRotation;
    private JCheckBox checkSameModel;
    private BoneComboBox comboArrowBone;
    private BoneComboBox comboMotionBone;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JSplitPane jSplitPane1;
    private JTextArea jTextAreaLog;
    private JList listParents;
    private JMenuItem menuAbout;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuHelp;
    private JMenuItem menuQuit;
    private JMenu menuTools;
    private JMenuItem menuVMD2CSV;
    private JScrollPane scrollPaneL;
    private JScrollPane scrollPaneR;
    private JTable tableBones;
    private JTable tableFrames;
    private JTextField textIKModelName;
    private JTextField textIKMotion;
    private JTextField textTargetModel;
    private JTextField textTargetMotion;

    public IKSolver_GUI() {
        this.initComponents();
        this.textIKModelName.setDropTarget((DropTarget)new FileDropTarget((FileDropListener)this));
        this.textIKMotion.setDropTarget((DropTarget)new FileDropTarget((FileDropListener)this));
        this.textTargetModel.setDropTarget((DropTarget)new FileDropTarget((FileDropListener)this));
        this.textTargetMotion.setDropTarget((DropTarget)new FileDropTarget((FileDropListener)this));
        this.log("Welcome to MMD IK Solver.");
    }

    private void initComponents() {
        this.buttonSolve = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jTextAreaLog = new JTextArea();
        this.buttonSave = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.scrollPaneL = new JScrollPane();
        this.jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.textIKModelName = new JTextField();
        this.buttonOpenIKModel = new JButton();
        this.textIKMotion = new JTextField();
        this.buttonOpenIKMotion = new JButton();
        this.comboArrowBone = new BoneComboBox();
        this.checkNoGlobalRotation = new JCheckBox();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listParents = new JList();
        this.jScrollPane5 = new JScrollPane();
        this.tableBones = new JTable();
        this.buttonInsert = new JButton();
        this.buttonRemove = new JButton();
        this.scrollPaneR = new JScrollPane();
        this.jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.checkSameModel = new JCheckBox();
        this.textTargetModel = new JTextField();
        this.textTargetMotion = new JTextField();
        this.buttonOpenTargetModel = new JButton();
        this.buttonOpenTargetMotion = new JButton();
        this.comboMotionBone = new BoneComboBox();
        this.jScrollPane4 = new JScrollPane();
        this.tableFrames = new JTable();
        this.checkInterp = new JCheckBox();
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuQuit = new JMenuItem();
        this.menuTools = new JMenu();
        this.menuVMD2CSV = new JMenuItem();
        this.menuHelp = new JMenu();
        this.menuAbout = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("MMD IK Solver");
        this.getContentPane().setLayout(new GridBagLayout());
        this.buttonSolve.setText("\u5b9f\u884c");
        this.buttonSolve.setEnabled(false);
        this.buttonSolve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonSolveActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.getContentPane().add((Component)this.buttonSolve, gridBagConstraints);
        this.jScrollPane3.setPreferredSize(new Dimension(250, 96));
        this.jTextAreaLog.setEditable(false);
        this.jTextAreaLog.setColumns(20);
        this.jTextAreaLog.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextAreaLog);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.ipady = 30;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 18, 10, 19);
        this.getContentPane().add((Component)this.jScrollPane3, gridBagConstraints);
        this.buttonSave.setText("\u4fdd\u5b58");
        this.buttonSave.setEnabled(false);
        this.buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        this.getContentPane().add((Component)this.buttonSave, gridBagConstraints);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel1.setLayout(new GridBagLayout());
        jLabel1.setText("IK\u30e2\u30c7\u30eb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)jLabel1, gridBagConstraints);
        this.textIKModelName.setEditable(false);
        this.textIKModelName.setText("\u307e\u3060");
        this.textIKModelName.setToolTipText("IK\u3068\u3057\u3066\u52d5\u304b\u3059\u30e2\u30c7\u30eb. \u3053\u3053\u306b\u30c9\u30ed\u30c3\u30d7\u3057\u3066\u3082\u8aad\u307f\u8fbc\u3081\u307e\u3059.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.textIKModelName, gridBagConstraints);
        this.buttonOpenIKModel.setText("\u30e2\u30c7\u30eb\u8aad\u307f");
        this.buttonOpenIKModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonOpenIKModelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.buttonOpenIKModel, gridBagConstraints);
        this.textIKMotion.setEditable(false);
        this.textIKMotion.setText("\u521d\u671f\u5024");
        this.textIKMotion.setToolTipText("IK\u3067\u52d5\u304b\u3059\u524d\u306e\u30e2\u30fc\u30b7\u30e7\u30f3. \u30e2\u30c7\u30eb\u3068\u540c\u3058\u3082\u306e\u306b\u3057\u3066\u306d.\u30c9\u30ed\u30c3\u30d7\u8aad\u307f\u8fbc\u307f\u53ef\u80fd.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.textIKMotion, gridBagConstraints);
        this.buttonOpenIKMotion.setText("\u30e2\u30fc\u30b7\u30e7\u30f3\u8aad\u307f");
        this.buttonOpenIKMotion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonOpenIKMotionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.buttonOpenIKMotion, gridBagConstraints);
        this.comboArrowBone.setToolTipText("\u30bf\u30fc\u30b2\u30c3\u30c8\u306b\u5411\u304b\u308f\u305b\u308b\u30dc\u30fc\u30f3.");
        this.comboArrowBone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.comboArrowBoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.comboArrowBone, gridBagConstraints);
        this.checkNoGlobalRotation.setText("\u5148\u7aef\u975e\u56de\u8ee2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.jPanel1.add((Component)this.checkNoGlobalRotation, gridBagConstraints);
        jLabel5.setText("\u89aa");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)jLabel5, gridBagConstraints);
        jLabel6.setText("\u5909\u66f4\u5bfe\u8c61");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)jLabel6, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(160, 134));
        this.listParents.setSelectionMode(0);
        this.listParents.setToolTipText("\u5148\u7aef\u30dc\u30fc\u30f3\u306e\u7956\u5148\u30dc\u30fc\u30f3.\u52d5\u304b\u3059\u306e\u306f\u3053\u308c\u3089.");
        this.listParents.setCellRenderer(new ParentBoneRenderer());
        this.listParents.setMaximumSize(new Dimension(6000, 6000));
        this.listParents.setModel(new ParentBoneListModel(new Object[0][]));
        this.jScrollPane1.setViewportView(this.listParents);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane5.setMinimumSize(new Dimension(200, 80));
        this.jScrollPane5.setPreferredSize(new Dimension(100, 134));
        this.tableBones.setModel(new BoneTableModel());
        this.tableBones.setDefaultEditor(Boolean.class, new DefaultCellEditor(new JCheckBox()));
        this.jScrollPane5.setViewportView(this.tableBones);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane5, gridBagConstraints);
        this.buttonInsert.setText("\u2192");
        this.buttonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonInsertActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 0.1;
        this.jPanel1.add((Component)this.buttonInsert, gridBagConstraints);
        this.buttonRemove.setText("\u2190");
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 0.1;
        this.jPanel1.add((Component)this.buttonRemove, gridBagConstraints);
        this.scrollPaneL.setViewportView(this.jPanel1);
        this.jSplitPane1.setLeftComponent(this.scrollPaneL);
        this.jPanel2.setLayout(new GridBagLayout());
        jLabel2.setText("\u30bf\u30fc\u30b2\u30c3\u30c8");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.jPanel2.add((Component)jLabel2, gridBagConstraints);
        this.checkSameModel.setSelected(true);
        this.checkSameModel.setText("IK\u30e2\u30c7\u30eb\u3068\u540c\u3058");
        this.checkSameModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.checkSameModelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.jPanel2.add((Component)this.checkSameModel, gridBagConstraints);
        this.textTargetModel.setEditable(false);
        this.textTargetModel.setText("\u307e\u3060");
        this.textTargetModel.setToolTipText("\u30bf\u30fc\u30b2\u30c3\u30c8\u3068\u3057\u3066\u52d5\u304b\u3059\u30e2\u30c7\u30eb. \u3053\u3053\u306b\u30c9\u30ed\u30c3\u30d7\u3057\u3066\u3082\u8aad\u307f\u8fbc\u3081\u307e\u3059.");
        this.textTargetModel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.textTargetModel, gridBagConstraints);
        this.textTargetMotion.setEditable(false);
        this.textTargetMotion.setText("\u521d\u671f\u5024");
        this.textTargetMotion.setToolTipText("\u30bf\u30fc\u30b2\u30c3\u30c8\u30e2\u30c7\u30eb\u7528\u306e\u30e2\u30fc\u30b7\u30e7\u30f3.\u30c9\u30ed\u30c3\u30d7\u8aad\u307f\u8fbc\u307f\u53ef\u80fd.");
        this.textTargetMotion.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.textTargetMotion, gridBagConstraints);
        this.buttonOpenTargetModel.setText("\u30e2\u30c7\u30eb\u8aad\u307f");
        this.buttonOpenTargetModel.setEnabled(false);
        this.buttonOpenTargetModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonOpenTargetModelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.buttonOpenTargetModel, gridBagConstraints);
        this.buttonOpenTargetMotion.setText("\u30e2\u30fc\u30b7\u30e7\u30f3\u8aad\u307f");
        this.buttonOpenTargetMotion.setEnabled(false);
        this.buttonOpenTargetMotion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.buttonOpenTargetMotionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.buttonOpenTargetMotion, gridBagConstraints);
        this.comboMotionBone.setToolTipText("\u30bf\u30fc\u30b2\u30c3\u30c8\u30dc\u30fc\u30f3\u3002\u7956\u5148\u306bIK\u3067\u52d5\u304f\u30dc\u30fc\u30f3\u3092\u542b\u3081\u306a\u3044\u3088\u3046\u306b\u3002");
        this.comboMotionBone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.comboMotionBoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.jPanel2.add((Component)this.comboMotionBone, gridBagConstraints);
        this.jScrollPane4.setMinimumSize(new Dimension(80, 100));
        this.jScrollPane4.setPreferredSize(new Dimension(80, 134));
        this.tableFrames.setModel(new DefaultTableModel(new Object[0][], new String[]{"Frame", "\u8ddd\u96e2"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Double.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tableFrames.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane4.setViewportView(this.tableFrames);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jScrollPane4, gridBagConstraints);
        this.checkInterp.setText("\u30d5\u30ec\u30fc\u30e0\u88dc\u9593");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        this.jPanel2.add((Component)this.checkInterp, gridBagConstraints);
        this.scrollPaneR.setViewportView(this.jPanel2);
        this.jSplitPane1.setRightComponent(this.scrollPaneR);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 5.0;
        this.getContentPane().add((Component)this.jSplitPane1, gridBagConstraints);
        this.menuFile.setMnemonic('F');
        this.menuFile.setText("\u30d5\u30a1\u30a4\u30eb(F)");
        this.menuQuit.setMnemonic('X');
        this.menuQuit.setText("\u7d42\u4e86(X)");
        this.menuQuit.setToolTipText("\u7d42\u4e86");
        this.menuQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.menuQuitActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuQuit);
        this.menuBar.add(this.menuFile);
        this.menuTools.setMnemonic('T');
        this.menuTools.setText("\u30c4\u30fc\u30eb(T)");
        this.menuVMD2CSV.setText("vmd2csv convert");
        this.menuVMD2CSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.menuVMD2CSVActionPerformed(evt);
            }
        });
        this.menuTools.add(this.menuVMD2CSV);
        this.menuBar.add(this.menuTools);
        this.menuHelp.setMnemonic('H');
        this.menuHelp.setText("\u30d8\u30eb\u30d7(H)");
        this.menuHelp.setToolTipText("");
        this.menuBar.add(Box.createHorizontalGlue());
        this.menuAbout.setMnemonic('A');
        this.menuAbout.setText("IKSolver \u306b\u3064\u3044\u3066(A)");
        this.menuAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKSolver_GUI.this.menuAboutActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuAbout);
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void menuQuitActionPerformed(ActionEvent evt) {
        int i = JOptionPane.showConfirmDialog(this, "\u7d42\u4e86\u3057\u3066\u3044\u3044\u3067\u3059\u304b", "MMD IK Solver", 0);
        if (i == 0) {
            this.dispose();
        }
    }

    private void menuAboutActionPerformed(ActionEvent evt) {
        new AboutDialog((Frame)this, true, this.getClass(), "MMD IK Solver \u306f MMD Motion Library for Java \u306eIK \u554f\u984c\u3092\u89e3\u3044\u3066\u3001MMD \u30e2\u30fc\u30b7\u30e7\u30f3\u306b\u3059\u308bJava \u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u306e GUI \u3067\u3059\u3002").show("MMD IK Solver");
    }

    private void buttonSolveActionPerformed(ActionEvent evt) {
        int i;
        this.ikSolver = new IKSolver();
        int l = this.tableBones.getRowCount();
        Bone[] bs = new Bone[l + 1];
        bs[0] = this.IKmodel.get((String)this.comboArrowBone.getSelectedItem());
        BoneTableModel btm = (BoneTableModel)this.tableBones.getModel();
        for (i = 1; i <= l; ++i) {
            bs[i] = this.IKmodel.get((String)btm.getValueAt(i - 1, 0));
        }
        this.ikSolver.setBones(bs);
        if (this.checkNoGlobalRotation.isSelected()) {
            this.ikSolver.setLimits(0, 64);
        }
        for (i = 1; i <= l; ++i) {
            int flags = (Boolean)btm.getValueAt(i - 1, 1) != false ? 128 : 0;
            flags += (Boolean)btm.getValueAt(i - 1, 2) != false ? 3 : 0;
            flags += (Boolean)btm.getValueAt(i - 1, 3) != false ? 12 : 0;
            this.ikSolver.setLimits(i, flags += (Boolean)btm.getValueAt(i - 1, 4) != false ? 48 : 0);
        }
        if (this.IKMotion == null) {
            this.IKMotion = new Motion(this.IKmodel.getName());
        }
        String targetBone = (String)this.comboMotionBone.getSelectedItem();
        Pose[] poses = this.targetMotion.get(targetBone);
        Bone boneTarget = this.targetModel.get(targetBone);
        this.resultMotion = new Motion(this.IKMotion.getModelName());
        DefaultTableModel dtm = (DefaultTableModel)this.tableFrames.getModel();
        for (int row = dtm.getRowCount() - 1; row >= 0; --row) {
            dtm.removeRow(row);
        }
        if (this.checkInterp.isSelected()) {
            int endFrame = poses[poses.length - 1].frame;
            for (int frame = 0; frame < endFrame; ++frame) {
                this.log(String.valueOf(frame));
                this.resultMotion.putAll(this.IKMotion.get(frame), frame);
                this.IKmodel.setPoses(this.IKMotion.getInterporate(frame));
                if (this.targetModel != this.IKmodel) {
                    this.targetModel.setPoses(this.targetMotion.getInterporate(frame));
                }
                this.IKmodel.resetChanged();
                dtm.addRow(new Object[]{frame, this.ikSolver.solve(boneTarget.getPos())});
                this.resultMotion.putAll(this.IKmodel.getChanged(), frame);
            }
        } else {
            int frame;
            for (frame = 0; frame < this.IKMotion.getMaxFrame(); ++frame) {
                this.resultMotion.putAll(this.IKMotion.get(frame), frame);
            }
            for (Pose p : poses) {
                frame = p.frame;
                this.log(String.valueOf(p.frame));
                this.IKmodel.setPoses(this.IKMotion.getInterporate(frame));
                if (this.targetModel != this.IKmodel) {
                    this.targetModel.setPoses(this.targetMotion.get(frame));
                }
                this.IKmodel.resetChanged();
                dtm.addRow(new Object[]{frame, this.ikSolver.solve(boneTarget.getPos())});
                this.resultMotion.putAll(this.IKmodel.getChanged(), frame);
            }
        }
        this.buttonSave.setEnabled(true);
    }

    private void buttonOpenTargetModelActionPerformed(ActionEvent evt) {
        Model m = MmdDialog.loadModel((Component)this);
        if (m == null) {
            return;
        }
        this.openTargetModel(m);
    }

    private void openTargetModel(Model m) {
        this.targetModel = m;
        this.textTargetModel.setText(this.targetModel.getName());
    }

    private void buttonOpenIKMotionActionPerformed(ActionEvent evt) {
        Motion m = MmdDialog.loadMotion((Component)this);
        if (m == null) {
            return;
        }
        this.openIKMotion(m);
    }

    private void openIKMotion(Motion m) {
        this.IKMotion = m;
        this.textIKMotion.setText(this.IKMotion.getModelName());
        if (this.checkSameModel.isSelected()) {
            this.openTargetMotion(m);
        }
    }

    private void menuVMD2CSVActionPerformed(ActionEvent evt) {
        VMD2CSV a = new VMD2CSV();
        a.setVisible(true);
    }

    private void buttonInsertActionPerformed(ActionEvent evt) {
        Object[] sel = (Object[])this.listParents.getSelectedValue();
        if (sel == null) {
            return;
        }
        ((BoneTableModel)this.tableBones.getModel()).add((String)sel[0], (Integer)sel[1]);
        this.tableBones.repaint();
        if (this.tableFrames.getRowCount() > 0) {
            this.buttonSolve.setEnabled(true);
        }
    }

    private void buttonRemoveActionPerformed(ActionEvent evt) {
        int i = this.tableBones.getSelectedRow();
        if (i < 0) {
            return;
        }
        BoneTableModel btm = (BoneTableModel)this.tableBones.getModel();
        btm.removeRow(i);
        this.tableBones.repaint();
        if (btm.getColumnCount() == 0) {
            this.buttonSolve.setEnabled(false);
        }
    }

    private void buttonSaveActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(this.motionOutFile.getParentFile());
        jfc.setDialogTitle("\u30e2\u30fc\u30b7\u30e7\u30f3\u3092\u4fdd\u5b58");
        jfc.setFileFilter(new FileNameExtensionFilter("MMD motion", "vmd"));
        jfc.addChoosableFileFilter(new FileNameExtensionFilter("CSV motion", "csv"));
        jfc.setApproveButtonText("\u4fdd\u5b58");
        jfc.setDialogType(1);
        if (jfc.showSaveDialog(this) != 0) {
            return;
        }
        this.motionOutFile = jfc.getSelectedFile();
        try {
            FileOutputStream fos = new FileOutputStream(this.motionOutFile);
            if (this.motionOutFile.getName().toLowerCase().endsWith(".vmd")) {
                this.resultMotion.toVMD((OutputStream)fos);
            } else {
                this.resultMotion.toCSV((OutputStream)fos);
            }
            fos.close();
        }
        catch (UnsupportedCharsetException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }

    private void comboArrowBoneActionPerformed(ActionEvent evt) {
        ((BoneTableModel)this.tableBones.getModel()).removeAll();
        this.tableBones.repaint();
        this.buttonSolve.setEnabled(false);
        String selected = (String)this.comboArrowBone.getSelectedItem();
        if (selected == null) {
            return;
        }
        ((ParentBoneListModel)this.listParents.getModel()).setMMDBone(selected);
    }

    private void comboMotionBoneActionPerformed(ActionEvent evt) {
        String s = (String)this.comboMotionBone.getSelectedItem();
        if (s == null) {
            return;
        }
        Pose[] p = this.targetMotion.get(s);
        if (p == null) {
            return;
        }
        Object[][] table = new Object[p.length][];
        for (int i = 0; i < p.length; ++i) {
            table[i] = new Object[]{p[i].frame, null};
        }
        this.tableFrames.setModel(new DefaultTableModel(table, new String[]{"frame", "\u8ddd\u96e2"}));
        if (this.tableBones.getRowCount() > 0 && this.tableFrames.getRowCount() > 0) {
            this.buttonSolve.setEnabled(true);
        } else {
            this.buttonSolve.setEnabled(false);
        }
    }

    private void openIKModel(Model m) {
        this.IKmodel = m;
        this.textIKModelName.setText(this.IKmodel.getName());
        ((BoneTableModel)this.tableBones.getModel()).setMMDModel(m);
        ((ParentBoneListModel)this.listParents.getModel()).setMMDModel(m);
        this.comboArrowBone.removeAllItems();
        this.comboArrowBone.setMMDModel(this.IKmodel);
        if (this.checkSameModel.isSelected()) {
            this.targetModel = this.IKmodel;
            this.textTargetModel.setText(this.targetModel.getName());
        }
    }

    private void buttonOpenIKModelActionPerformed(ActionEvent evt) {
        Model m = MmdDialog.loadModel((Component)this);
        if (m == null) {
            return;
        }
        this.openIKModel(m);
    }

    private void buttonOpenTargetMotionActionPerformed(ActionEvent evt) {
        Motion m = MmdDialog.loadMotion((Component)this);
        if (m == null) {
            return;
        }
        this.openTargetMotion(m);
    }

    private void openTargetMotion(Motion m) {
        this.targetMotion = m;
        this.textTargetMotion.setText(this.targetMotion.getModelName());
        this.comboMotionBone.setMMDMotion(this.targetMotion);
    }

    private void checkSameModelActionPerformed(ActionEvent evt) {
        if (this.checkSameModel.isSelected()) {
            this.buttonOpenTargetModel.setEnabled(false);
            this.buttonOpenTargetMotion.setEnabled(false);
            this.targetModel = this.IKmodel;
            if (this.targetModel != null) {
                this.textTargetModel.setText(this.targetModel.getName());
            }
            this.targetMotion = this.IKMotion;
            if (this.IKMotion != null) {
                this.openTargetMotion(this.IKMotion);
            }
            this.textTargetModel.setEnabled(false);
            this.textTargetMotion.setEnabled(false);
        } else {
            this.buttonOpenTargetModel.setEnabled(true);
            this.textTargetModel.setEnabled(true);
            this.buttonOpenTargetMotion.setEnabled(true);
            this.textTargetMotion.setEnabled(true);
        }
    }

    public void fileDrop(FileDropEvent e) {
        block21: {
            Object src = e.getSource();
            File file = e.getFiles()[0];
            String name = file.toString().toLowerCase();
            if (src == this.textIKModelName || src == this.textTargetModel) {
                Model m = null;
                try {
                    if (name.endsWith(".pmx")) {
                        m = Model.fromPMX((InputStream)new FileInputStream(file));
                    } else if (name.endsWith(".pmd")) {
                        m = Model.fromPMD((InputStream)new FileInputStream(file));
                    } else if (name.endsWith(".csv")) {
                        m = Model.fromPMD((InputStream)new FileInputStream(file));
                    } else {
                        throw new MmdFormatException("\u62e1\u5f35\u5b50\u304b\u3089\u5224\u5225\u3067\u304d\u307e\u305b\u3093!: " + name);
                    }
                    if (src == this.textIKModelName) {
                        this.openIKModel(m);
                        break block21;
                    }
                    this.openTargetModel(m);
                }
                catch (IOException ex) {
                    this.log("IO \u30a8\u30e9\u30fc:" + ex.getLocalizedMessage());
                }
                catch (MmdFormatException ex) {
                    this.log("MMDFile error:" + (Object)((Object)ex));
                }
            } else {
                Motion m = new Motion();
                try {
                    if (name.endsWith(".vmd")) {
                        m.fromVMD((InputStream)new FileInputStream(file));
                    } else if (name.endsWith(".csv")) {
                        m.fromCSV((InputStream)new FileInputStream(file));
                    } else {
                        throw new MmdFormatException("\u62e1\u5f35\u5b50\u304b\u3089\u5224\u5225\u3067\u304d\u307e\u305b\u3093!: " + name);
                    }
                    if (src == this.textIKMotion) {
                        this.openIKMotion(m);
                    } else {
                        this.openTargetMotion(m);
                    }
                }
                catch (IOException ex) {
                    this.log("IO \u30a8\u30e9\u30fc:" + ex.getLocalizedMessage());
                }
                catch (MmdFormatException ex) {
                    this.log("MMDFile error:" + (Object)((Object)ex));
                }
            }
        }
    }

    private void log(String log) {
        this.jTextAreaLog.setText(this.jTextAreaLog.getText() + log + "\n");
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(IKSolver_GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(IKSolver_GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(IKSolver_GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(IKSolver_GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new IKSolver_GUI().setVisible(true);
            }
        });
    }
}

