/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ParseStage;
import jp.sfjp.mikutoga.pmx.BoneFlags;
import jp.sfjp.mikutoga.pmx.parser.PmxBasicHandler;
import jp.sfjp.mikutoga.pmx.parser.PmxBoneHandler;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;

public class PmxFileHander
implements PmxBoneHandler,
PmxBasicHandler {
    protected static Vector3D absoluteZ = Vector3D.unitZ;
    protected Model model;
    protected Bone bone;
    protected short boneFlags;
    protected ArrayList<String> idToName;
    protected TreeMap<Integer, Integer> childToParent;
    protected TreeMap<Integer, Number[]> childToLinkParent;
    protected TreeMap<Integer, Integer> parentToTail;
    protected TreeMap<Integer, Vector3D> parentToOffset;

    public PmxFileHander(Model model) {
        this.model = model;
    }

    @Override
    public void pmxParseStart() {
        this.bone = null;
        this.boneFlags = 0;
    }

    @Override
    public void pmxHeaderInfo(float version, int encode, int uv) throws MmdFormatException {
        if (version < 2.0f) {
            throw new MmdFormatException("Too old PMX file.");
        }
    }

    @Override
    public void pmxModelName(String name, String nameE) {
        this.model.setName(name);
    }

    @Override
    public void pmxModelDescription(String description, String descriptionE) {
    }

    @Override
    public void loopStart(ParseStage stage, int loops) {
        if (stage == PmxBoneHandler.BONE_LIST) {
            this.idToName = new ArrayList();
            this.childToParent = new TreeMap();
            this.childToLinkParent = new TreeMap();
            this.parentToTail = new TreeMap();
            this.parentToOffset = new TreeMap();
        }
    }

    @Override
    public void pmxBoneInfo(String name, String nameE) {
        this.bone = new Bone(this.model);
        this.bone.name = name;
        this.idToName.add(name);
    }

    @Override
    public void pmxBonePosition(float xPos, float yPos, float zPos) {
        this.bone.gv = new Vector3D(xPos, yPos, zPos);
    }

    @Override
    public void pmxBoneStructure(int parentId, int depth) {
        if (parentId == -1) {
            this.bone.parent = null;
        } else {
            this.childToParent.put(this.idToName.size() - 1, parentId);
        }
    }

    @Override
    public void pmxBoneFlags(short flags) {
        this.boneFlags = flags;
        if (!BoneFlags.LINK_FLAG.check(flags)) {
            this.bone.linkParent = null;
        }
        if (!BoneFlags.AXIS_ROTATE.check(flags)) {
            this.bone.limitRot = null;
        }
        if (!BoneFlags.LOCAL_AXIS.check(flags)) {
            this.bone.mr = new Matrix();
            this.bone.ini_mr = new Matrix();
        }
    }

    @Override
    public void pmxBoneOffset(float offX, float offY, float offZ) {
        this.parentToOffset.put(this.idToName.size() - 1, new Vector3D(offX, offY, offZ));
    }

    @Override
    public void pmxBoneArrowhead(int arrowId) {
        this.parentToTail.put(this.idToName.size() - 1, arrowId);
    }

    @Override
    public void pmxBoneLink(int linkParent, float ratio) throws MmdFormatException {
        this.childToLinkParent.put(this.idToName.size() - 1, new Number[]{linkParent, Float.valueOf(BoneFlags.MOVE_LINK.check(this.boneFlags) ? ratio : 0.0f), Float.valueOf(BoneFlags.ROTATE_LINK.check(this.boneFlags) ? ratio : 0.0f)});
    }

    @Override
    public void pmxBoneLocalAxis(float xx, float xy, float xz, float zx, float zy, float zz) {
        this.bone.mr = new Matrix(new Vector3D(xx, xy, xz), new Vector3D(-zx, -zy, -zz));
        this.bone.ini_mr = new Matrix(this.bone.mr);
    }

    @Override
    public void pmxBoneRotateAxe(float x, float y, float z) {
        this.bone.limitRot = new Vector3D(x, y, z);
    }

    @Override
    public void pmxBoneExtraParent(int extraParent) {
    }

    @Override
    public void pmxBoneIKInfo(int targetId, int depth, float weight) {
    }

    @Override
    public void pmxIKChainInfo(int childId, float[] limit_rotation) {
    }

    @Override
    public void loopNext(ParseStage stage) {
        if (this.bone != null) {
            this.model.put(this.bone);
        }
        this.bone = null;
    }

    @Override
    public void loopEnd(ParseStage stage) throws MmdFormatException {
        if (stage == PmxBoneHandler.BONE_LIST) {
            Bone parent;
            String name;
            Bone child;
            for (Map.Entry<Integer, Integer> entry : this.childToParent.entrySet()) {
                child = this.model.get(this.idToName.get(entry.getKey()));
                child.parent = this.idToName.get(entry.getValue());
                this.model.get(child.parent).addChild(child);
            }
            for (Map.Entry<Integer, Integer> entry : this.childToLinkParent.entrySet()) {
                child = this.model.get(this.idToName.get(entry.getKey()));
                Number[] link = (Number[])entry.getValue();
                child.linkParent = this.idToName.get((Integer)link[0]);
                if (child.linkParent == null) {
                    throw new MmdFormatException("Link parent not found. id:" + child.linkParent + " at bone:" + child.name);
                }
                this.model.get(child.linkParent).addLinkChild(child, ((Float)link[1]).floatValue(), ((Float)link[2]).floatValue());
            }
            for (Map.Entry<Integer, Object> entry : this.parentToOffset.entrySet()) {
                name = this.idToName.get(entry.getKey());
                if (this.model.get(name + "\u5148") != null) continue;
                parent = this.model.get(name);
                Bone arrowhead = new Bone(this.model);
                arrowhead.setName(name + "\u5148");
                arrowhead.gv = parent.getPos().add((Vector3D)entry.getValue());
                arrowhead.mr = new Matrix();
                arrowhead.ini_mr = new Matrix();
                arrowhead.parent = name;
                parent.addChild(arrowhead);
                this.idToName.add(arrowhead.getName());
                this.parentToTail.put(entry.getKey(), this.idToName.size() - 1);
                this.model.put(arrowhead);
            }
            for (Map.Entry<Integer, Object> entry : this.parentToTail.entrySet()) {
                name = this.idToName.get(entry.getKey());
                if (!name.matches("((\u5de6|\u53f3)(\u8155|\u3072\u3058|\u624b\u9996)|.*(\u89aa|\u4eba|\u4e2d|\u85ac|\u5c0f)\u6307.*)")) continue;
                parent = this.model.get(name);
                if (!parent.mr.equals(new Matrix())) continue;
                String tail = this.idToName.get((Integer)entry.getValue());
                Vector3D arrow = this.model.get(tail).getPos().sub(parent.getPos());
                double norm = (arrow = arrow.sub(absoluteZ.times(arrow.times(absoluteZ)))).norm();
                if (!(norm > 0.0)) continue;
                parent.mr = new Matrix(arrow.divide(norm), absoluteZ);
                parent.ini_mr = new Matrix(parent.mr);
            }
        }
    }

    @Override
    public void pmxParseEnd(boolean hasMoreData) {
    }
}

