/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.pmd.parser.PmdParser;
import jp.sfjp.mikutoga.pmx.parser.PmxParser;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.PmdFileHander;
import jp.sourceforge.mmd.motion.model.PmxFileHander;

public class Model {
    private String name;
    private TreeMap<String, Bone> namemap = new TreeMap();

    private Model() {
    }

    public static Model fromCSV(InputStream csv) throws IOException, MmdFormatException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(csv, "MS932"));
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Syntax error in Model.java:" + ex.getMessage());
            System.exit(-1);
        }
        Model ret = new Model();
        while (br.ready()) {
            String line = br.readLine();
            if (line.startsWith("Bone,")) {
                Bone tb = Bone.fromCSV(ret, line);
                if (tb == null) continue;
                ret.put(tb);
                continue;
            }
            if (!line.startsWith("ModelInfo,")) continue;
            int i = line.indexOf(44);
            int j = line.indexOf(44, i + 1);
            ret.name = line.substring(i + 2, j - 1);
        }
        ret.resetChanged();
        return ret;
    }

    public static Model fromPMD(InputStream is) throws IOException, MmdFormatException {
        Model mo = new Model();
        PmdParser pmdp = new PmdParser(is);
        PmdFileHander parser = new PmdFileHander(mo);
        pmdp.setBasicHandler(parser);
        pmdp.setBoneHandler(parser);
        pmdp.parsePmd();
        return mo;
    }

    public static Model fromPMX(InputStream is) throws IOException, MmdFormatException {
        Model mo = new Model();
        PmxParser pmxp = new PmxParser(is);
        PmxFileHander parser = new PmxFileHander(mo);
        pmxp.setBasicHandler(parser);
        pmxp.setBoneHandler(parser);
        pmxp.parsePmx();
        return mo;
    }

    public Bone get(String name) {
        return this.namemap.get(name);
    }

    protected void put(Bone b) {
        this.namemap.put(b.getName(), b);
    }

    public Collection<Bone> values() {
        return this.namemap.values();
    }

    public Set<String> keys() {
        return this.namemap.keySet();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPoses(Pose[] mof) {
        if (mof == null) {
            return;
        }
        for (Pose p : mof) {
            Bone b;
            if (!(p instanceof BonePose) || (b = this.get(p.nameOfBone)) == null) continue;
            b.setPose((BonePose)p);
        }
    }

    public Pose[] getChanged() {
        ArrayList<BonePose> al = new ArrayList<BonePose>();
        for (Bone b : this.namemap.values()) {
            if (!b.getChanged()) continue;
            al.add(b.getPose());
        }
        return al.toArray(new Pose[al.size()]);
    }

    public void resetChanged() {
        for (Bone b : this.namemap.values()) {
            b.resetChanged();
        }
    }
}

