/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.model;

import java.util.ArrayList;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Model;

public class Bone {
    protected Model model;
    protected String name = null;
    protected String parent = null;
    protected String linkParent = null;
    protected ArrayList<Bone> children = new ArrayList();
    protected ArrayList<BoneLink> linkChildren = new ArrayList();
    protected Vector3D gv = new Vector3D(0.0, 0.0, 0.0);
    protected Matrix g_mr = new Matrix();
    protected Matrix ini_mr;
    protected Vector3D v = new Vector3D();
    protected Matrix mr;
    protected Vector3D limitRot = null;
    protected boolean changed = false;

    public Bone(Model m) {
        this.model = m;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        if (this.model == null) {
            return 0;
        }
        if (this.name == null) {
            return 0;
        }
        return (this.model.getName() + "/" + this.name).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bone other = (Bone)obj;
        if (this.model != other.model && (this.model == null || this.model.getName().compareTo(other.model.getName()) != 0)) {
            return false;
        }
        return !(this.name != null ? this.name.compareTo(other.name) == 0 : other.name != null);
    }

    public String getParent() {
        return this.parent;
    }

    public String getLinkParent() {
        return this.linkParent;
    }

    public Bone addChild(Bone child) {
        if (child.parent.compareTo(this.name) != 0) {
            return null;
        }
        this.children.add(child);
        return this;
    }

    public Bone removeChild(Bone child) {
        int i = this.children.indexOf(child);
        if (i >= 0) {
            this.children.remove(i);
        }
        return this;
    }

    public Bone addLinkChild(Bone child, double translation, double rotation) {
        if (child.linkParent.compareTo(this.name) != 0) {
            return null;
        }
        this.linkChildren.add(new BoneLink(child, translation, rotation));
        return this;
    }

    public Vector3D getPos() {
        Vector3D g = this.g_mr.times(this.v).add(this.gv);
        return g;
    }

    public Matrix getGMatrix() {
        return this.g_mr.times(this.mr);
    }

    public Vector3D getLPos() {
        return new Vector3D(this.v);
    }

    public Matrix getMatrix() {
        return this.mr.clone();
    }

    public Vector3D getLimitRot() {
        return this.limitRot;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.changed = false;
    }

    public void translationTo(Vector3D lv) {
        Vector3D gtv = this.g_mr.times(lv.sub(this.v));
        for (Bone c : this.children) {
            c.translationG(gtv);
        }
        for (BoneLink l : this.linkChildren) {
            if (l.linkedT == 0.0) continue;
            l.child.translationG(gtv.times(l.linkedT));
        }
        this.v = new Vector3D(lv);
        this.changed = true;
    }

    private void translationG(Vector3D dv) {
        for (Bone c : this.children) {
            c.translationG(dv);
        }
        this.gv = this.gv.add(dv);
    }

    public Vector3D getLx() {
        return this.g_mr.times(this.mr.getLx());
    }

    public Vector3D getLy() {
        return this.g_mr.times(this.mr.getLy());
    }

    public Vector3D getLz() {
        return this.g_mr.times(this.mr.getLz());
    }

    public void rotate(Vector3D axis_sin, double co) {
        double sine = axis_sin.norm();
        if (sine == 0.0) {
            return;
        }
        Vector3D lsin = this.g_mr.inverse().times(axis_sin);
        this.mr.rotate(lsin, co);
        Vector3D center = this.getPos();
        for (Bone c : this.children) {
            c.rotateG(axis_sin, co, center);
        }
        for (BoneLink l : this.linkChildren) {
            if (l.linkedR == 1.0) {
                l.child.rotateG(axis_sin, co, new Vector3D());
                continue;
            }
            if (l.linkedR == -1.0) {
                l.child.rotateG(axis_sin.inverse(), co, new Vector3D());
                continue;
            }
            double angle = Math.atan2(co, sine) * l.linkedR;
            l.child.rotateG(axis_sin.times(Math.sin(angle) / sine), Math.cos(angle), new Vector3D());
        }
        this.changed = true;
    }

    private void rotateG(Vector3D axis_sin, double co, Vector3D center) {
        Vector3D ta = this.gv.sub(center);
        Vector3D ra = ta.rotate_vector(axis_sin, co);
        this.gv = ra.add(center);
        this.g_mr.rotate(axis_sin, co);
        for (Bone c : this.children) {
            c.rotateG(axis_sin, co, center);
        }
    }

    public void rotate(Matrix dmr) {
        this.mr = dmr.times(this.mr);
        Matrix gr = this.g_mr.times(dmr).times(this.g_mr.inverse());
        for (Bone c : this.children) {
            c.rotateG(gr, this.getPos());
        }
        for (BoneLink l : this.linkChildren) {
            if (l.linkedR == 1.0) {
                l.child.rotate(gr);
                continue;
            }
            if (l.linkedR == -1.0) {
                l.child.rotate(gr.inverse());
                continue;
            }
            l.child.rotate(gr.power(l.linkedR));
        }
        this.changed = true;
    }

    private void rotateG(Matrix dmr, Vector3D center) {
        Vector3D ta = this.gv.sub(center);
        Vector3D ra = dmr.times(ta);
        this.gv = ra.add(center);
        this.g_mr = dmr.times(this.g_mr);
        for (Bone c : this.children) {
            c.rotateG(dmr, center);
        }
    }

    public void rotateTo(Matrix m) {
        Matrix dmr = m.times(this.ini_mr).times(this.mr.inverse());
        this.rotate(dmr);
    }

    public void rotateToG(Matrix gm) {
        Matrix dmr = this.g_mr.inverse().times(gm).times(this.mr.inverse());
        this.rotate(dmr);
    }

    public void setPose(BonePose p) {
        if (p.nameOfBone.compareTo(this.name) != 0) {
            return;
        }
        if (!this.mr.equals(p.mr)) {
            this.rotateTo(p.mr);
        }
        if (!this.v.equals(p.v)) {
            this.translationTo(p.v);
        }
    }

    public BonePose getPose() {
        BonePose p = new BonePose();
        p.nameOfBone = this.name;
        p.v = this.v;
        p.mr = this.mr.times(this.ini_mr.inverse());
        return p;
    }

    public BonePose getCoordinate() {
        BonePose p = new BonePose();
        p.nameOfBone = "\u539f\u70b91";
        p.v = this.g_mr.times(this.v).add(this.gv);
        p.mr = this.g_mr.times(this.mr);
        return p;
    }

    public String toString() {
        String ret = this.name + ":\n";
        ret = ret + "\tV:" + this.v + "\n";
        ret = ret + "\tM:" + this.mr + "\n";
        ret = ret + "\tinit_M:" + this.ini_mr + "\n";
        double[] rv = this.mr.angles();
        ret = ret + "\tA:" + rv[0] + "," + rv[1] + "," + rv[2] + "\n";
        return ret;
    }

    public static Bone fromCSV(Model m, String line) throws MmdFormatException {
        String[] p = CsvSpliter.split(line);
        if (p.length < 39) {
            return null;
        }
        if (p[0].compareTo("Bone") != 0) {
            throw new MmdFormatException("not Bone line");
        }
        Bone ret = new Bone(m);
        ret.name = p[1];
        try {
            ret.gv = new Vector3D(Double.parseDouble(p[5]), Double.parseDouble(p[6]), Double.parseDouble(p[7]));
            ret.v = new Vector3D();
        }
        catch (NumberFormatException ex) {
            throw new MmdFormatException("Number error in " + ret.name + "'s corrdinate.");
        }
        ret.parent = p[13];
        if (ret.parent.length() == 0) {
            ret.parent = null;
        } else {
            ret.model.get(ret.parent).addChild(ret);
        }
        ret.linkParent = p[23];
        if (ret.linkParent.length() == 0) {
            ret.linkParent = null;
        } else {
            double rate = Double.parseDouble(p[22]);
            ret.model.get(ret.linkParent).addLinkChild(ret, p[21].startsWith("1") ? rate : 0.0, p[20].startsWith("1") ? rate : 0.0);
        }
        ret.limitRot = p[24].equals("1") ? new Vector3D(Double.parseDouble(p[25]), Double.parseDouble(p[26]), Double.parseDouble(p[27])) : null;
        if (p[28].equals("1")) {
            Vector3D lz;
            Vector3D lx;
            try {
                lx = new Vector3D(Double.parseDouble(p[29]), Double.parseDouble(p[30]), Double.parseDouble(p[31]));
                lz = new Vector3D(-Double.parseDouble(p[32]), -Double.parseDouble(p[33]), -Double.parseDouble(p[34]));
            }
            catch (NumberFormatException ex) {
                System.err.println("Number error in " + ret.name + "'s matrix.");
                return ret;
            }
            ret.mr = new Matrix(lx, lz);
        } else {
            ret.mr = new Matrix();
        }
        ret.ini_mr = new Matrix(ret.mr);
        ret.g_mr = new Matrix();
        return ret;
    }

    protected final class BoneLink {
        private final Bone child;
        private final double linkedT;
        private final double linkedR;

        protected BoneLink(Bone c, double translation, double rotation) {
            this.child = c;
            this.linkedT = translation;
            this.linkedR = rotation;
        }
    }
}

