/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.geo;

public class Vector3D
implements Cloneable {
    protected double[] r = new double[3];

    public Vector3D() {
        this.r[0] = 0.0;
        this.r[1] = 0.0;
        this.r[2] = 0.0;
    }

    public Vector3D(double[] v) {
        this.set(v);
    }

    public Vector3D(double x, double y, double z) {
        this.set(x, y, z);
    }

    public Vector3D(Vector3D b) {
        this.set(b.r);
    }

    public final void set(double[] v) {
        this.r[0] = v[0];
        this.r[1] = v[1];
        this.r[2] = v[2];
    }

    public final void set(double x, double y, double z) {
        this.r[0] = x;
        this.r[1] = y;
        this.r[2] = z;
    }

    public boolean equals(Vector3D e) {
        return this.r[0] == e.r[0] && this.r[1] == e.r[1] && this.r[2] == e.r[2];
    }

    public Vector3D clone() {
        return new Vector3D(this);
    }

    public Vector3D add(Vector3D b) {
        return new Vector3D(this.r[0] + b.r[0], this.r[1] + b.r[1], this.r[2] + b.r[2]);
    }

    public Vector3D sub(Vector3D b) {
        return new Vector3D(this.r[0] - b.r[0], this.r[1] - b.r[1], this.r[2] - b.r[2]);
    }

    public Vector3D inverse() {
        return new Vector3D(-this.r[0], -this.r[1], -this.r[2]);
    }

    public Vector3D divide(double d) {
        return new Vector3D(this.r[0] / d, this.r[1] / d, this.r[2] / d);
    }

    public Vector3D times(double m) {
        return new Vector3D(this.r[0] * m, this.r[1] * m, this.r[2] * m);
    }

    public double times(Vector3D b) {
        return this.r[0] * b.r[0] + this.r[1] * b.r[1] + this.r[2] * b.r[2];
    }

    public Vector3D cross(Vector3D b) {
        return new Vector3D(this.r[1] * b.r[2] - this.r[2] * b.r[1], this.r[2] * b.r[0] - this.r[0] * b.r[2], this.r[0] * b.r[1] - this.r[1] * b.r[0]);
    }

    public double norm() {
        return Math.sqrt(this.norm2());
    }

    public double norm2() {
        return this.r[0] * this.r[0] + this.r[1] * this.r[1] + this.r[2] * this.r[2];
    }

    public Vector3D rotate_vector(Vector3D axis_sin, double c) {
        double norm2 = axis_sin.norm2();
        if (norm2 == 0.0) {
            return new Vector3D(this);
        }
        double ns = axis_sin.times(this);
        Vector3D nn = axis_sin.times(ns / norm2);
        Vector3D ca = axis_sin.cross(this);
        return this.sub(nn).times(c).add(nn).add(ca);
    }

    public String toString() {
        return Double.toString(this.r[0]) + "," + this.r[1] + "," + this.r[2];
    }

    public double[] toDouble() {
        double[] ret = new double[]{this.r[0], this.r[1], this.r[2]};
        return ret;
    }
}

