/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.sfjp.mikutoga.xml.LocalXmlResource;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlResourceResolver
implements LSResourceResolver,
EntityResolver {
    public static final String SCHEMA_XML = "http://www.w3.org/2001/xml.xsd";
    public static final String NS_XSD = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String LOCAL_SCHEMA_XML = "resources/xmlspace.xsd";
    private static final URI EMPTY_URI = URI.create("");
    private static final Class<?> THISCLASS = XmlResourceResolver.class;
    private final Map<URI, URI> uriMap;

    public XmlResourceResolver() {
        assert (this.getClass().equals(THISCLASS));
        Map map = new HashMap();
        map = Collections.synchronizedMap(map);
        this.uriMap = map;
        URL redirectRes = THISCLASS.getResource(LOCAL_SCHEMA_XML);
        String redirectResName = redirectRes.toString();
        URI originalURI = URI.create(SCHEMA_XML);
        URI redirectURI = URI.create(redirectResName);
        this.putRedirectedImpl(originalURI, redirectURI);
    }

    protected static URI buildBaseRelativeURI(String base, String relative) throws URISyntaxException, IllegalArgumentException {
        URI baseURI;
        if (base != null) {
            baseURI = new URI(base);
            if (!baseURI.isAbsolute()) {
                throw new IllegalArgumentException();
            }
        } else {
            baseURI = null;
        }
        URI relativeURI = relative != null ? new URI(relative) : EMPTY_URI;
        URI resultURI = baseURI == null || relativeURI.isAbsolute() ? relativeURI : baseURI.resolve(relativeURI);
        if (!resultURI.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        resultURI = resultURI.normalize();
        return resultURI;
    }

    public static LSInput createLSInput() {
        LSInputImpl input = new LSInputImpl();
        return input;
    }

    private void putRedirectedImpl(URI original, URI redirect) {
        URI oridinalNorm = original.normalize();
        URI redirectNorm = redirect.normalize();
        this.uriMap.put(oridinalNorm, redirectNorm);
    }

    public void putRedirected(URI original, URI redirect) {
        this.putRedirectedImpl(original, redirect);
    }

    public void putRedirected(LocalXmlResource lsc) {
        URI original = lsc.getOriginalResource();
        if (original == null) {
            return;
        }
        URI local = lsc.getLocalResource();
        this.putRedirected(original, local);
    }

    public void putRedirected(XmlResourceResolver other) {
        this.uriMap.putAll(other.uriMap);
    }

    public URI getRedirected(URI original) {
        URI keyURI = original.normalize();
        URI resourceURI = this.uriMap.get(keyURI);
        return resourceURI;
    }

    public URI resolveRedirected(URI original) {
        URI result = this.getRedirected(original);
        if (result == null) {
            result = original;
        }
        return result;
    }

    private InputStream getXMLResourceAsStream(URI originalURI) throws IOException {
        URI resourceURI = this.getRedirected(originalURI);
        if (resourceURI == null) {
            return null;
        }
        URL resourceURL = resourceURI.toURL();
        InputStream is = resourceURL.openStream();
        return is;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        InputStream is;
        URI originalURI;
        if (systemId == null) {
            return null;
        }
        try {
            originalURI = XmlResourceResolver.buildBaseRelativeURI(baseURI, systemId);
        }
        catch (URISyntaxException e) {
            return null;
        }
        try {
            is = this.getXMLResourceAsStream(originalURI);
        }
        catch (IOException e) {
            return null;
        }
        if (is == null) {
            return null;
        }
        LSInput input = XmlResourceResolver.createLSInput();
        input.setBaseURI(baseURI);
        input.setPublicId(publicId);
        input.setSystemId(systemId);
        input.setByteStream(is);
        return input;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        URI originalUri;
        if (systemId == null) {
            return null;
        }
        try {
            originalUri = new URI(systemId);
        }
        catch (URISyntaxException e) {
            return null;
        }
        InputStream is = this.getXMLResourceAsStream(originalUri);
        if (is == null) {
            return null;
        }
        InputSource source = new InputSource(is);
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }

    private static final class LSInputImpl
    implements LSInput {
        private String baseURI = null;
        private InputStream byteStream = null;
        private boolean certifiedText = false;
        private Reader characterStream = null;
        private String encoding = null;
        private String publicId = null;
        private String stringData = null;
        private String systemId = null;

        LSInputImpl() {
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public void setBaseURI(String baseURI) {
            this.baseURI = baseURI;
        }

        @Override
        public InputStream getByteStream() {
            return this.byteStream;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this.byteStream = byteStream;
        }

        @Override
        public boolean getCertifiedText() {
            return this.certifiedText;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            this.certifiedText = certifiedText;
        }

        @Override
        public Reader getCharacterStream() {
            return this.characterStream;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this.characterStream = characterStream;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public void setStringData(String stringData) {
            this.stringData = stringData;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }
    }
}

