/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.bin.export;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class TextExporter {
    public static final int DEFBUFSZ_CHAR = 128;
    public static final int DEFBUFSZ_BYTE = 128;
    private final CharsetEncoder encoder;
    private CharBuffer cbuf = CharBuffer.allocate(128);
    private byte[] barray = new byte[128];
    private ByteBuffer bbuf = ByteBuffer.wrap(this.barray);
    private CharSequence textData;
    private int textLength;
    private int inPos;

    public TextExporter(CharsetEncoder encoder) throws NullPointerException {
        if (encoder == null) {
            throw new NullPointerException();
        }
        this.encoder = encoder;
        this.encoder.reset();
        this.encoder.onMalformedInput(CodingErrorAction.REPORT);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.cbuf.clear();
        this.bbuf.clear();
    }

    public TextExporter(Charset cs) {
        this(cs.newEncoder());
    }

    public CharsetEncoder getEncoder() {
        return this.encoder;
    }

    public void setCharBufSize(int newSize) throws IllegalArgumentException {
        if (newSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.cbuf = CharBuffer.allocate(newSize);
        this.cbuf.clear();
    }

    public void setByteBufSize(int newSize) throws IllegalArgumentException {
        float ratio = this.encoder.maxBytesPerChar();
        int minSz = (int)StrictMath.floor(ratio);
        if (newSize < minSz) {
            throw new IllegalArgumentException();
        }
        this.barray = new byte[newSize];
        this.bbuf = ByteBuffer.wrap(this.barray);
        this.bbuf.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dumpText(CharSequence text, OutputStream os) throws IOException, CharacterCodingException {
        this.textData = text;
        int total = 0;
        try {
            total = this.dumpTextImpl(os);
        }
        finally {
            this.textData = null;
        }
        return total;
    }

    private int dumpTextImpl(OutputStream os) throws IOException, CharacterCodingException {
        this.reset();
        int total = 0;
        while (true) {
            this.loadCharBuffer();
            CoderResult result = this.encode();
            if (result.isUnderflow()) {
                this.cbuf.clear();
                if (this.hasMoreInput()) continue;
                total += this.sweepByteBuffer(os);
                break;
            }
            if (result.isOverflow()) {
                total += this.sweepByteBuffer(os);
                this.cbuf.compact();
                continue;
            }
            if (!result.isError()) continue;
            result.throwException();
        }
        return total += this.flush(os);
    }

    private void reset() {
        this.cbuf.clear();
        this.bbuf.clear();
        this.encoder.reset();
        this.textLength = this.textData.length();
        this.inPos = 0;
    }

    private boolean hasMoreInput() {
        return this.inPos < this.textLength;
    }

    private void loadCharBuffer() {
        while (this.cbuf.hasRemaining() && this.hasMoreInput()) {
            char ch = this.textData.charAt(this.inPos++);
            this.cbuf.put(ch);
        }
        this.cbuf.flip();
    }

    private CoderResult encode() {
        boolean endOfInput = !this.hasMoreInput();
        CoderResult result = this.encoder.encode(this.cbuf, this.bbuf, endOfInput);
        return result;
    }

    private int sweepByteBuffer(OutputStream os) throws IOException {
        this.bbuf.flip();
        int total = this.bbuf.remaining();
        os.write(this.barray, 0, total);
        this.bbuf.clear();
        return total;
    }

    private int flush(OutputStream os) throws IOException, CharacterCodingException {
        CoderResult result;
        int total = 0;
        do {
            if ((result = this.encoder.flush(this.bbuf)).isError()) {
                result.throwException();
            }
            total += this.sweepByteBuffer(os);
        } while (!result.isUnderflow());
        return total;
    }

    public int encodeToByteStream(CharSequence text, ByteArrayOutputStream bos) throws CharacterCodingException {
        int result = 0;
        try {
            result = this.dumpText(text, bos);
        }
        catch (CharacterCodingException e) {
            throw e;
        }
        catch (IOException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        return result;
    }
}

