/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.ik_solver;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.ik_solver.IKSolver;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;

public class IKSolverTest {
    public static void main(String[] argv) {
        Model model = null;
        try {
            FileInputStream fis = new FileInputStream("maki_cut.csv");
            model = Model.fromCSV(fis);
            fis.close();
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        Motion maki_ini = null;
        try {
            FileInputStream fis = new FileInputStream("guiter_temp_cut.vmd");
            maki_ini = new Motion().fromVMD(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            System.exit(-1);
        }
        catch (IOException e) {
        }
        catch (MmdFormatException ex) {
            Logger.getLogger(IKSolver.class.getName()).log(Level.SEVERE, null, ex);
        }
        Motion motionQ = new Motion("Coordinates");
        Motion motionT = new Motion("Coordinates");
        Bone[] bs = new Bone[]{model.get("\u5de6\u624b\u9996"), model.get("\u5de6\u3072\u3058"), model.get("\u5de6\u8155")};
        Bone mustan = model.get("\u3080\u3059\u30bf\u30f3");
        model.setPoses(maki_ini.get(0));
        Vector3D pos = mustan.getPos();
        Vector3D ly = mustan.getLy();
        IKSolver iks = new IKSolver();
        iks.setBones(bs);
        iks.setLimits(1, 51);
        model.resetChanged();
        iks.solve(model.get("\u5de6\u624b\u9996D").getPos());
        model.get("\u5de6\u624b\u9996").rotateToG(model.get("\u5de6\u624b\u9996D").getGMatrix());
        Pose[] poses = model.getChanged();
        maki_ini.putAll(poses, 0);
        BonePose ps = bs[0].getCoordinate();
        ps.nameOfBone = "\u539f\u70b91";
        ps.frame = 0;
        motionQ.put(ps);
        ps = bs[1].getCoordinate();
        ps.nameOfBone = "\u539f\u70b91";
        ps.frame = 0;
        motionT.put(ps);
        for (int i = -12; i < 5; ++i) {
            model.resetChanged();
            iks.solve(model.get("\u5de6\u624b\u9996D").getPos().add(ly.times(1.916327266175 * (Math.pow(2.0, (double)(i + 19) / 12.0) - Math.pow(2.0, 1.5833333333333333)))));
            model.get("\u5de6\u624b\u9996").rotateToG(model.get("\u5de6\u624b\u9996D").getGMatrix());
            poses = model.getChanged();
            maki_ini.putAll(poses, 13 + i);
            ps = bs[0].getCoordinate();
            ps.nameOfBone = "\u539f\u70b91";
            ps.frame = 13 + i;
            motionQ.put(ps);
            ps = bs[1].getCoordinate();
            ps.nameOfBone = "\u539f\u70b91";
            ps.frame = 13 + i;
            motionT.put(ps);
        }
        try {
            FileOutputStream fos = new FileOutputStream("maki_solve.vmd");
            maki_ini.toVMD(fos);
            fos.close();
            fos = new FileOutputStream("testQ.vmd");
            motionQ.toVMD(fos);
            fos.close();
            fos = new FileOutputStream("testT.vmd");
            motionT.toVMD(fos);
            fos.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(IKSolver.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(IKSolver.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(IKSolver.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

