// -*- mode: C++ -*-
#ifndef MiX_XPathAtom_h_
#define MiX_XPathAtom_h_

#include "misc.h"

namespace MiX {
  /**
   * XPathιʤɽ魯饹
   *
   * ѥȤҥȤȤ°Ȥ
   */
  template <class charT, class char_traits,class xml_traits>
  class XPathAtom {
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
    virtual ~XPathAtom() { };

    virtual xpathresult_type execute( nodecontainer_type& el )=0;
  };


  /**
   * ̤XPathAtom ҥΡɤ椫̾ޥåΤõơ
   * ΡɽȤƷ̤֤
   */
  template <class charT,class char_traits,class xml_traits>
  class XPathAtom_Selector : public XPathAtom<charT,char_traits,xml_traits> {
  public:
    MiX_Template_Typedef(charT, char_traits, xml_traits );
  private:
    string_type name_;
  public:
    XPathAtom_Selector( const string_type& src ) : name_(src) { }
    ~XPathAtom_Selector( ) { }
    xpathresult_type execute( nodecontainer_type& el );
  };

  /**
   * °ؤXPathAtom 
   * °椫̾פΤõ֤ͤ
   */
  template <class charT,class char_traits,class xml_traits>
  class XPathAtom_Attribute : public XPathAtom<charT,char_traits,xml_traits> {
  public:
    MiX_Template_Typedef(charT, char_traits, xml_traits );
  private:
    string_type name_;
  public:
    XPathAtom_Attribute( const string_type& src ) : name_(src) { }
    ~XPathAtom_Attribute( ) { }
    xpathresult_type execute( nodecontainer_type& cur );
  };

}

#ifndef MiX_XPathAtom_cpp_
#include "XPathAtom.cpp"
#endif

#endif
