#define MiX_XPathAtom_cpp_

#include <stdexcept>

namespace MiX {
  template <class charT,class char_traits,class xml_traits>
  XPathResult<charT,char_traits,xml_traits> XPathAtom_Selector<charT,char_traits,xml_traits>::execute( nodecontainer_type& el ) {
   
    typename nodelist_type::iterator it = el.getChildren().begin();
    typename nodelist_type::iterator last = el.getChildren().end();
    nodelist_type lst;
    for( ; it!=last ; ++it ) {
      if( (*it)->getType()==Node_Element ) {
	element_type* el = dynamic_cast<element_type*>(*it);
	if( el->getName()==name_ ) {
	  lst.push_back( *it );
	}
      }
    }
    return xpathresult_type( lst );
  }

  template <class charT,class char_traits,class xml_traits>
  XPathResult<charT,char_traits,xml_traits> XPathAtom_Attribute<charT,char_traits,xml_traits>::execute( nodecontainer_type& cur ) {
    nodelist_type lst;
    try {
      element_type& el=dynamic_cast<element_type&>(cur);
      return xpathresult_type( el[name_].getValue() );
    } catch( const dom_exception_type& e ) {
      throw xpathexception_type( e.getType(), "DOM_Exception raised during process XPath");
    } catch( const std::bad_cast& e ) {
      throw xpathexception_type( InternalError, "not element");
    }
  }
  
}
