// -*- mode: c++ -*-

#ifndef MiX_XPATH_H_
#define MiX_XPATH_H_

#include "classes.h"
#include "XMLString.h"

namespace MiX{

  template <class retT>

  template <class charT,class char_traits,class xml_traits>
  class Document : boost::noncopyable,
		   public NodeContainer<charT,char_traits,xml_traits>{
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
    typedef Document<charT,char_traits,xml_traits> this_type;
    typedef typename nodelist_type::iterator nodelist_iter; 
    typedef NodeContainer<charT,char_traits,xml_traits> nodecontainer_type;
  private:
    const static typename nodelist_type::iterator dmy_it;
  protected:
    /**
     * 󥹥ȥ饯
     *
     * DocumentΥ󥹥ȥ饯ľܸƤ٤ޤ
     * Document<...>::createƤ
     */
    Document() { };
  public:
    ///ǥȥ饯
    virtual ~Document()throw() { };
    ///ΥΡɤΥפޤ
    virtual NodeType getType() const{ return Node_Document; };
    /**
     * Ū˥饹NodeTypeޤ
     *
     * Node_Document֤ޤ
     */
    static NodeType type(){ return Node_Document; } ;
    ///ͣλElement֤ޤ
    element_type& getRoot()const;
    /**
     * Documentʸɽޤ
     *
     * XMLʸϤƤӤޤ<br>
     * bIndentλǥȤɲäޤ
     */
    virtual string_type toString(bool is_indent=false,int indent_off=0)const;
    /**
     * Attribute˥ޤ
     *
     * szNameͿ줿̾AttributeؤλȤ֤ޤ<br>
     * ĤʤäDomException<...>ꤲޤ
     */
    attribute_type& operator[](const string_type& name){
      return getAttribute(name);
    }
    /**
     * Documentʣޤ
     */
    node_type& clone(nodecontainer_type& dmy,const nodelist_iter& it=dmy_it)const { return clone(); }

    /**
     * Documentʣޤ
     */
    node_type& clone() const;
    /**
     * Documentޤ
     *
     * DocumentƱͣλElementޤ
     * \param rootname ƱElement̾
     */
    static this_type& create(const string_type& rootname);
    
    friend class DOM_Parser<charT,char_traits,xml_traits>;
  };
}

#ifndef MiX_DOCUMENT_CPP_
#include "Document.cpp"
#endif

#endif
