#define MiX_XPath_cpp_

#include "XPathAtom.h"
#include "XPathParser.h"

namespace MiX{
  template <class charT,class char_traits,class xml_traits>
  void XPathResult<charT,char_traits,xml_traits>::assign( const xpathresult_type& src) { 
    type_ = src.getType();
    switch( type_ ) {
    case Result_Null:
      ptr_ = 0;
      break;
    case Result_NodeList: 
      list_ = new nodelist_type( src.getNodeList() );
      break;
    case Result_Boolean:
      bool_ = new bool( src.getBoolean() );
      break;
    case Result_Number:
      number_ = new double( src.getNumber() );
      break;
    case Result_String:
      str_ = new string_type( src.getString() );
      break;
    default:
      throw xpathexception_type( InvalidXPathResult, "invalid XPathResult" );
      break;
    }    
  }

  template <class charT,class char_traits,class xml_traits>
  void XPathResult<charT,char_traits,xml_traits>::clear( ) {
    if( ptr_!=0 ) {
      switch( type_ ) {
      case Result_Null:
	break;
      case Result_NodeList:
	delete list_;
	break;
      case Result_Boolean:
	delete bool_;
	break;
      case Result_Number:
	delete number_;
	break;
      case Result_String:
	delete str_;
	break;
      default:
	// 肦Ȃ
	throw xpathexception_type( InvalidXPathResult, "invalid XPathResult" );
	break;
      }
    }
    ptr_ = 0;
  }

  template <class charT, class char_traits,class xml_traits>
  void XPathResult<charT,char_traits,xml_traits>::output( std::ostream& os ) const {
    switch( getType() ) {
    case Result_Null:
      os << "(null)";
      break;
    case Result_NodeList: {
      os << "( ";
      typename nodelist_type::const_iterator it = getNodeList().begin();
      typename nodelist_type::const_iterator last = getNodeList().end();
      for( ; it!=last ; ++it ) {
	element_type& el = dynamic_cast<element_type&>(**it);
	os << '\"' << el.getName() << "\", ";
      }
      os << ")";
      break; }
    case Result_Boolean:
      if( getBoolean() ) os << "(true)";
      else os << "(false)";
      break;
    case Result_Number:
      os << getNumber();
      break;
    case Result_String:
      os << '\"' << getString() << '\"';
      break;
    default:
      os << "(invalid)";
      break;
    }
  }

  template <class charT,class char_traits,class xml_traits>
  XPath<charT,char_traits,xml_traits>::XPath( const string_type& src ) {
    XPathParser<charT,char_traits,xml_traits> parser;
    //parser.parse( src, std::back_inserter( atoms_ ) );
    parser.parse( src );
    xpathatom_type* atom;
    while( atom=parser.getNextAtom() ) atoms_.push_back( atom );
  }

  template <class charT,class char_traits,class xml_traits>
  XPath<charT,char_traits,xml_traits>::~XPath( ) throw() {
    try {
      for( typename std::list<xpathatom_type*>::iterator it = atoms_.begin() ;
	   it!=atoms_.end() ; ++it ) 
	delete (*it);
    } catch(...) {
    }
  }

  template <class charT,class char_traits,class xml_traits>
  XPathResult<charT,char_traits,xml_traits> XPath<charT,char_traits,xml_traits>::execute(nodecontainer_type& el) {
    typename std::list<xpathatom_type*>::iterator it = atoms_.begin();
    typename std::list<xpathatom_type*>::iterator last = atoms_.end();
    nodecontainer_type* cur = &el;
    /// result͒lx[Xœǂ݂̂...
    /// |C^NXւ̃|C^ĂȂ񂩊ԔB
    xpathresult_type result;
    for( ; it!=last ; ++it ) {
      result = (*it)->execute( *cur );
      if( result.getType()!=Result_Element ) {
	/// ɂ͓rʂƂăGgȊOw肳ꂽꍇ̓G[fׂA
	/// Ƃ肠AŏIʂƂēfoƂɂ
	break;
      }
      cur = &(result.getElement());
    }
    return result;
  }
  
}

