// -*- mode: c++ -*-

#ifndef MIX_XMLTOKEN_H_
#define MIX_XMLTOKEN_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"

namespace MiX{
  enum TokenType{
    Token_null = 0,
    Token_cr,
    Token_lf,
    Token_space,
    Token_tab,
    Token_lt,
    Token_eq,
    Token_gt,
    Token_slash,
    Token_hyphen,
    Token_semicolon,
    Token_exclamation,
    Token_question,
    Token_amp,
    Token_dblquote,
    Token_quote,
    Token_lsb,
    Token_rsb,
    //    TokenCount,
    Token_text = 100
  };
#define TokenCount 18
  template <class charT,class char_traits,class xml_traits>
  class XMLToken {
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
    typedef XMLToken<charT,char_traits,xml_traits> this_type;
  private:
    string_type str_;
    TokenType type_;
    long index_;
  public:
    ///RXgN^
    XMLToken() : type_(Token_null),index_(-1){ };
    ///RXgN^
    XMLToken(const charT* first,const charT* last,TokenType type,long index);
    ///𓾂܂
    string_type& getData() { return str_; };
    ///g[N^Cv𓾂܂
    TokenType getType() { return type_; };
    ///ʒu𓾂܂
    long getIndex() { return index_; };
  };
}

#ifndef MIX_XMLTOKEN_CPP_
#include "XMLToken.cpp"
#endif

#endif
