/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.IOException;
import java.io.Serializable;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.PMDModel;

public class PMDHeaderEnglish
implements Serializable {
    private int englishNameCompatibility;
    private String modelName;
    private String comment;
    private String[] boneNameEnglish;
    private String[] skinNameEnglish;
    private String[] dispNameEnglish;

    public PMDHeaderEnglish(PMDModel model, DataInputStreamLittleEndian is) throws IOException {
        this.englishNameCompatibility = is.readUnsignedByte();
        if (this.englishNameCompatibility == 1) {
            int i;
            this.modelName = is.readString(20);
            this.comment = is.readString(256);
            this.boneNameEnglish = new String[model.getBoneList().getBoneCount()];
            for (i = 0; i < this.boneNameEnglish.length; ++i) {
                this.boneNameEnglish[i] = is.readString(20);
            }
            this.skinNameEnglish = new String[model.getSkinCount() - 1];
            for (i = 0; i < this.skinNameEnglish.length; ++i) {
                this.skinNameEnglish[i] = is.readString(20);
            }
            this.dispNameEnglish = new String[model.getBoneDispNameList().getBoneDispNameCount()];
            for (i = 0; i < this.dispNameEnglish.length; ++i) {
                this.dispNameEnglish[i] = is.readString(50);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("englishNameCompatibility = ").append(this.englishNameCompatibility).append('\n');
        if (this.englishNameCompatibility == 1) {
            int i;
            sb.append("modelName = ").append(this.modelName).append('\n');
            sb.append("comment = ").append(this.comment).append('\n');
            sb.append("boneNameEnglish = ").append("{\n");
            for (i = 0; i < this.boneNameEnglish.length; ++i) {
                sb.append(i);
                sb.append(" ").append(this.boneNameEnglish[i]).append('\n');
            }
            sb.append("}\n");
            sb.append("skinNameEnglish = ").append("{\n");
            for (i = 0; i < this.skinNameEnglish.length; ++i) {
                sb.append(i);
                sb.append(" ").append(this.skinNameEnglish[i]).append('\n');
            }
            sb.append("}\n");
            sb.append("dispNameEnglish = ").append("{\n");
            for (i = 0; i < this.dispNameEnglish.length; ++i) {
                sb.append(i);
                sb.append(" ").append(this.dispNameEnglish[i]).append('\n');
            }
        }
        sb.append("}\n}}\n");
        return sb.toString();
    }

    public String[] getBoneNameEnglish() {
        return this.boneNameEnglish;
    }

    public void setBoneNameEnglish(String[] boneNameEnglish) {
        this.boneNameEnglish = boneNameEnglish;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String[] getDispNameEnglish() {
        return this.dispNameEnglish;
    }

    public void setDispNameEnglish(String[] dispNameEnglish) {
        this.dispNameEnglish = dispNameEnglish;
    }

    public int getEnglishNameCompatibility() {
        return this.englishNameCompatibility;
    }

    public void setEnglishNameCompatibility(int englishNameCompatibility) {
        this.englishNameCompatibility = englishNameCompatibility;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String[] getSkinNameEnglish() {
        return this.skinNameEnglish;
    }

    public void setSkinNameEnglish(String[] skinNameEnglish) {
        this.skinNameEnglish = skinNameEnglish;
    }
}

