/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd;

import com.jme3.animation.Skeleton;
import com.jme3.asset.AssetManager;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.SkeletonWire;
import com.jme3.shader.VarType;
import com.jme3.util.TempVars;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Vector3f;
import projectkyoto.jme3.mmd.PMDMesh;
import projectkyoto.jme3.mmd.PMDSkinMesh;
import projectkyoto.jme3.mmd.Skin;
import projectkyoto.mmd.file.PMDVertex;

public class SkeletonControl
extends AbstractControl
implements Savable,
Cloneable {
    PMDMesh[] targets;
    PMDSkinMesh[] skinTargets;
    Vector3f[] skinPosArray;
    Vector3f[] skinNormalArray;
    Vector3f[] skinPosArrayOrig;
    Vector3f[] skinNormalArrayOrig;
    float[] skinBoneWeightArray;
    int[] skinBoneArray;
    AssetManager assetManager;
    Map<String, Skin> skinMap = new HashMap<String, Skin>();
    Matrix4f[] offsetMatrices;
    Skeleton skeleton;
    Node model;
    Node skeletonLineNode;
    Node boneNode;

    public SkeletonControl(Node model, PMDMesh[] targets, PMDSkinMesh[] skinTargets, List<PMDVertex> skinVertexList, Skin[] skinAray, Skeleton skeleton, AssetManager assetManager) {
        this.targets = targets;
        this.skinTargets = skinTargets;
        this.skeleton = skeleton;
        this.model = model;
        this.assetManager = assetManager;
        Geometry geom = (Geometry)model.getChild("geom1");
        for (Skin skin : skinAray) {
            this.skinMap.put(skin.getSkinName(), skin);
        }
        int skinVertSize = skinVertexList.size();
        this.skinPosArray = new Vector3f[skinVertSize];
        this.skinNormalArray = new Vector3f[skinVertSize];
        this.skinPosArrayOrig = new Vector3f[skinVertSize];
        this.skinNormalArrayOrig = new Vector3f[skinVertSize];
        this.skinBoneWeightArray = new float[skinVertSize];
        this.skinBoneArray = new int[skinVertSize * 2];
        for (int i = 0; i < skinVertSize; ++i) {
            PMDVertex v = skinVertexList.get(i);
            this.skinPosArrayOrig[i] = v.getPos();
            this.skinPosArray[i] = new Vector3f(v.getPos());
            this.skinNormalArrayOrig[i] = v.getNormal();
            this.skinNormalArray[i] = new Vector3f(v.getNormal());
            this.skinBoneWeightArray[i] = (float)v.getBoneWeight() / 100.0f;
            this.skinBoneArray[i * 2] = v.getBoneNum1();
            this.skinBoneArray[i * 2 + 1] = v.getBoneNum2();
        }
    }

    protected void controlUpdate(float tpf) {
        this.skeleton.reset();
        this.skeleton.updateWorldVectors();
        this.offsetMatrices = this.skeleton.computeSkinningMatrices();
        int i = 0;
        for (Matrix4f m : this.offsetMatrices) {
            for (int columnCount = 0; columnCount < 4; ++columnCount) {
                for (int rowCount = 0; rowCount < 4; ++rowCount) {
                }
            }
        }
        for (i = 0; i < this.targets.length; ++i) {
        }
        for (i = 0; i < this.offsetMatrices.length; ++i) {
            Matrix4f m = this.offsetMatrices[i];
        }
        for (Spatial s : this.model.getChildren()) {
            if (!(s instanceof Geometry)) continue;
            Geometry g = (Geometry)s;
            Material m = g.getMaterial();
            if (!(g.getMesh() instanceof PMDMesh)) continue;
            PMDMesh pmdMesh = (PMDMesh)g.getMesh();
            for (int i2 = 0; i2 < pmdMesh.getBoneIndexArray().length; ++i2) {
                pmdMesh.getBoneMatrixArray()[i2].set(this.offsetMatrices[pmdMesh.getBoneIndexArray()[i2]]);
            }
            m.setParam("BoneMatrices", VarType.Matrix4Array, (Object)pmdMesh.getBoneMatrixArray());
        }
        this.updateSkinMesh(this.skinTargets[0]);
        for (PMDSkinMesh sm : this.skinTargets) {
        }
    }

    void updateSkinMesh(PMDSkinMesh skinMesh) {
        VertexBuffer vb = skinMesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fvb = (FloatBuffer)vb.getData();
        VertexBuffer nb = skinMesh.getBuffer(VertexBuffer.Type.Normal);
        FloatBuffer fnb = (FloatBuffer)nb.getData();
        fvb.position(0);
        fnb.position(0);
        for (int i = 0; i < this.skinPosArray.length; ++i) {
            boolean idxWeights = false;
            TempVars vars = TempVars.get();
            float[] posBuf = vars.skinPositions;
            float[] normBuf = vars.skinNormals;
            boolean idxPositions = false;
            float nmx = this.skinNormalArray[i].x;
            float vtx = this.skinPosArray[i].x;
            float nmy = this.skinNormalArray[i].y;
            float vty = this.skinPosArray[i].y;
            float nmz = this.skinNormalArray[i].z;
            float vtz = this.skinPosArray[i].z;
            float rx = 0.0f;
            float ry = 0.0f;
            float rz = 0.0f;
            float rnx = 0.0f;
            float rny = 0.0f;
            float rnz = 0.0f;
            for (int w = 1; w >= 0; --w) {
                float weight = this.skinBoneWeightArray[i];
                if (w == 1) {
                    weight = 1.0f - weight;
                }
                Matrix4f mat = this.offsetMatrices[this.skinBoneArray[i * 2 + w]];
                rx += (mat.m00 * vtx + mat.m01 * vty + mat.m02 * vtz + mat.m03) * weight;
                ry += (mat.m10 * vtx + mat.m11 * vty + mat.m12 * vtz + mat.m13) * weight;
                rz += (mat.m20 * vtx + mat.m21 * vty + mat.m22 * vtz + mat.m23) * weight;
                rnx += (nmx * mat.m00 + nmy * mat.m01 + nmz * mat.m02) * weight;
                rny += (nmx * mat.m10 + nmy * mat.m11 + nmz * mat.m12) * weight;
                rnz += (nmx * mat.m20 + nmy * mat.m21 + nmz * mat.m22) * weight;
            }
            fnb.put(rnx).put(rny).put(rnz);
            fvb.put(rx).put(ry).put(rz);
        }
        vb.setUpdateNeeded();
        nb.setUpdateNeeded();
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void softwareSkinUpdate(Mesh mesh, Matrix4f[] offsetMatrices) {
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        int fourMinusMaxWeights = 4 - maxWeightsPerVert;
        VertexBuffer vb = mesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fvb = (FloatBuffer)vb.getData();
        fvb.rewind();
        VertexBuffer nb = mesh.getBuffer(VertexBuffer.Type.Normal);
        FloatBuffer fnb = (FloatBuffer)nb.getData();
        fnb.rewind();
        ByteBuffer ib = (ByteBuffer)mesh.getBuffer(VertexBuffer.Type.BoneIndex).getData();
        FloatBuffer wb = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.BoneWeight).getData();
        ib.rewind();
        wb.rewind();
        float[] weights = wb.array();
        byte[] indices = ib.array();
        int idxWeights = 0;
        TempVars vars = TempVars.get();
        float[] posBuf = vars.skinPositions;
        float[] normBuf = vars.skinNormals;
        int iterations = (int)FastMath.ceil((float)((float)fvb.capacity() / (float)posBuf.length));
        int bufLength = posBuf.length * 3;
        for (int i = iterations - 1; i >= 0; --i) {
            bufLength = Math.min(posBuf.length, fvb.remaining());
            fvb.get(posBuf, 0, bufLength);
            fnb.get(normBuf, 0, bufLength);
            int verts = bufLength / 3;
            int idxPositions = 0;
            for (int vert = verts - 1; vert >= 0; --vert) {
                float nmx = normBuf[idxPositions];
                float vtx = posBuf[idxPositions++];
                float nmy = normBuf[idxPositions];
                float vty = posBuf[idxPositions++];
                float nmz = normBuf[idxPositions];
                float vtz = posBuf[idxPositions++];
                float rx = 0.0f;
                float ry = 0.0f;
                float rz = 0.0f;
                float rnx = 0.0f;
                float rny = 0.0f;
                float rnz = 0.0f;
                for (int w = maxWeightsPerVert - 1; w >= 0; --w) {
                    float weight = weights[idxWeights];
                    Matrix4f mat = offsetMatrices[indices[idxWeights++]];
                    rx += (mat.m00 * vtx + mat.m01 * vty + mat.m02 * vtz + mat.m03) * weight;
                    ry += (mat.m10 * vtx + mat.m11 * vty + mat.m12 * vtz + mat.m13) * weight;
                    rz += (mat.m20 * vtx + mat.m21 * vty + mat.m22 * vtz + mat.m23) * weight;
                    rnx += (nmx * mat.m00 + nmy * mat.m01 + nmz * mat.m02) * weight;
                    rny += (nmx * mat.m10 + nmy * mat.m11 + nmz * mat.m12) * weight;
                    rnz += (nmx * mat.m20 + nmy * mat.m21 + nmz * mat.m22) * weight;
                }
                idxWeights += fourMinusMaxWeights;
                normBuf[idxPositions -= 3] = rnx;
                posBuf[idxPositions++] = rx;
                normBuf[idxPositions] = rny;
                posBuf[idxPositions++] = ry;
                normBuf[idxPositions] = rnz;
                posBuf[idxPositions++] = rz;
            }
            fvb.position(fvb.position() - bufLength);
            fvb.put(posBuf, 0, bufLength);
            fnb.position(fnb.position() - bufLength);
            fnb.put(normBuf, 0, bufLength);
        }
        vb.updateData((Buffer)fvb);
        nb.updateData((Buffer)fnb);
    }

    public void resetToBind() {
        for (int i = 0; i < this.targets.length; ++i) {
            PMDMesh mesh = this.targets[i];
            if (this.targets[i].getBuffer(VertexBuffer.Type.BindPosePosition) == null) continue;
            VertexBuffer bindPos = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
            VertexBuffer bindNorm = mesh.getBuffer(VertexBuffer.Type.BindPoseNormal);
            VertexBuffer pos = mesh.getBuffer(VertexBuffer.Type.Position);
            VertexBuffer norm = mesh.getBuffer(VertexBuffer.Type.Normal);
            FloatBuffer pb = (FloatBuffer)pos.getData();
            FloatBuffer nb = (FloatBuffer)norm.getData();
            FloatBuffer bpb = (FloatBuffer)bindPos.getData();
            FloatBuffer bnb = (FloatBuffer)bindNorm.getData();
            pb.clear();
            nb.clear();
            bpb.clear();
            bnb.clear();
            pb.put(bpb).clear();
            nb.put(bnb).clear();
        }
    }

    public Set<String> getSkinSet() {
        return this.skinMap.keySet();
    }

    public float getSkinWeight(String skinName) {
        return this.skinMap.get(skinName).getWeight();
    }

    public Matrix4f[] getOffsetMatrices() {
        return this.offsetMatrices;
    }

    public void showSkeleton(boolean flag) {
        if (flag) {
            Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            mat.setColor("Color", ColorRGBA.Green);
            mat.getAdditionalRenderState().setDepthTest(false);
            SkeletonWire sw = new SkeletonWire(this.skeleton);
            Geometry skeletonWireGeom = new Geometry("skeletonWire", (Mesh)sw);
            this.model.attachChild((Spatial)skeletonWireGeom);
            skeletonWireGeom.setMaterial(mat);
            skeletonWireGeom.setQueueBucket(RenderQueue.Bucket.Transparent);
        } else if (this.skeletonLineNode != null) {
            this.skeletonLineNode.removeFromParent();
            this.skeletonLineNode = null;
        }
    }
}

