/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HullCollisionShape
extends CollisionShape {
    private float[] points;

    public HullCollisionShape() {
    }

    public HullCollisionShape(Mesh mesh) {
        this.points = this.getPoints(mesh);
        this.createShape();
    }

    public HullCollisionShape(float[] fArray) {
        this.points = fArray;
        this.createShape();
    }

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write(this.points, "points", null);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        Mesh mesh = (Mesh)inputCapsule.readSavable("hullMesh", null);
        this.points = mesh != null ? this.getPoints(mesh) : inputCapsule.readFloatArray("points", null);
        this.createShape();
    }

    protected void createShape() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(this.points.length * 4));
        for (int i = 0; i < this.points.length; ++i) {
            float f = this.points[i];
            byteBuffer.putFloat(f);
        }
        byteBuffer.rewind();
        this.objectId = this.createShape(byteBuffer);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Shape {0}", Long.toHexString(this.objectId));
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private native long createShape(ByteBuffer var1);

    protected float[] getPoints(Mesh mesh) {
        FloatBuffer floatBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        floatBuffer.rewind();
        int n = mesh.getVertexCount() * 3;
        float[] fArray = new float[n];
        for (int i = 0; i < n; i += 3) {
            fArray[i] = floatBuffer.get();
            fArray[i + 1] = floatBuffer.get();
            fArray[i + 2] = floatBuffer.get();
        }
        return fArray;
    }
}

