/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.ogre;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.TextureKey;
import com.jme3.material.Material;
import com.jme3.material.MaterialList;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.plugins.ogre.matext.MaterialExtensionLoader;
import com.jme3.scene.plugins.ogre.matext.MaterialExtensionSet;
import com.jme3.scene.plugins.ogre.matext.OgreMaterialKey;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import com.jme3.util.blockparser.BlockLanguageParser;
import com.jme3.util.blockparser.Statement;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaterialLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(MaterialLoader.class.getName());
    private String folderName;
    private AssetManager assetManager;
    private ColorRGBA ambient;
    private ColorRGBA diffuse;
    private ColorRGBA specular;
    private ColorRGBA emissive;
    private Texture[] textures = new Texture[4];
    private String texName;
    private String matName;
    private float shinines;
    private boolean vcolor = false;
    private boolean blend = false;
    private boolean twoSide = false;
    private boolean noLight = false;
    private boolean separateTexCoord = false;
    private int texUnit = 0;

    private ColorRGBA readColor(String content) {
        String[] split = content.split(" ");
        ColorRGBA color = new ColorRGBA();
        color.r = Float.parseFloat(split[0]);
        color.g = Float.parseFloat(split[1]);
        color.b = Float.parseFloat(split[2]);
        if (split.length >= 4) {
            color.a = Float.parseFloat(split[3]);
        }
        return color;
    }

    private void readTextureImage(String content) {
        Texture loadedTexture;
        int extStart;
        String path = null;
        for (int i = extStart = content.lastIndexOf("."); i < content.length(); ++i) {
            char c = content.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            path = content.substring(0, i).trim();
            content = content.substring(i + 1).trim();
            break;
        }
        if (path == null) {
            path = content.trim();
            content = "";
        }
        Scanner lnScan = new Scanner(content);
        Object mips = null;
        String type = null;
        if (lnScan.hasNext()) {
            type = lnScan.next();
        }
        boolean genMips = true;
        boolean cubic = false;
        if (type != null && type.equals("0")) {
            genMips = false;
        }
        if (type != null && type.equals("cubic")) {
            cubic = true;
        }
        TextureKey key = new TextureKey(this.folderName + path, false);
        key.setGenerateMips(genMips);
        key.setAsCube(cubic);
        try {
            loadedTexture = this.assetManager.loadTexture(key);
        }
        catch (AssetNotFoundException ex) {
            logger.log(Level.WARNING, "Failed to load texture " + key + " for material " + this.matName, ex);
            loadedTexture = null;
        }
        if (loadedTexture == null) {
            ByteBuffer tempData = BufferUtils.createByteBuffer(3);
            tempData.put((byte)-1).put((byte)0).put((byte)0);
            this.textures[this.texUnit].setImage(new Image(Image.Format.RGB8, 1, 1, tempData));
            logger.log(Level.WARNING, "Using RED texture instead of {0}", path);
        } else {
            this.textures[this.texUnit].setImage(loadedTexture.getImage());
            this.textures[this.texUnit].setMinFilter(loadedTexture.getMinFilter());
            this.textures[this.texUnit].setKey(loadedTexture.getKey());
            this.textures[this.texUnit].setWrap(Texture.WrapMode.Repeat);
            if (this.texName != null) {
                this.textures[this.texUnit].setName(this.texName);
                this.texName = null;
            } else {
                this.textures[this.texUnit].setName(key.getName());
            }
        }
    }

    private void readTextureUnitStatement(Statement statement) {
        String[] split = statement.getLine().split(" ", 2);
        String keyword = split[0];
        if (keyword.equals("texture")) {
            this.readTextureImage(split[1]);
        } else if (keyword.equals("tex_address_mode")) {
            String mode = split[1];
            if (mode.equals("wrap")) {
                this.textures[this.texUnit].setWrap(Texture.WrapMode.Repeat);
            } else if (mode.equals("clamp")) {
                this.textures[this.texUnit].setWrap(Texture.WrapMode.Clamp);
            } else if (mode.equals("mirror")) {
                this.textures[this.texUnit].setWrap(Texture.WrapMode.MirroredRepeat);
            } else if (mode.equals("border")) {
                this.textures[this.texUnit].setWrap(Texture.WrapMode.BorderClamp);
            }
        } else if (!keyword.equals("filtering")) {
            if (keyword.equals("tex_coord_set")) {
                int texCoord = Integer.parseInt(split[1]);
                if (texCoord == 1) {
                    this.separateTexCoord = true;
                }
            } else if (keyword.equals("max_anisotropy")) {
                int amount = Integer.parseInt(split[1]);
                this.textures[this.texUnit].setAnisotropicFilter(amount);
            } else {
                logger.log(Level.WARNING, "Unsupported texture_unit directive: {0}", keyword);
            }
        }
    }

    private void readTextureUnit(Statement statement) {
        String[] split = statement.getLine().split(" ", 2);
        this.texName = split.length == 2 ? split[1] : null;
        this.textures[this.texUnit] = new Texture2D();
        for (Statement texUnitStat : statement.getContents()) {
            this.readTextureUnitStatement(texUnitStat);
        }
        if (this.textures[this.texUnit].getImage() != null) {
            ++this.texUnit;
        } else {
            this.textures[this.texUnit] = null;
        }
    }

    private void readPassStatement(Statement statement) {
        String[] split = statement.getLine().split(" ", 2);
        String keyword = split[0];
        if (keyword.equals("diffuse")) {
            if (split[1].equals("vertexcolour")) {
                this.diffuse = ColorRGBA.White;
                this.vcolor = true;
            } else {
                this.diffuse = this.readColor(split[1]);
            }
        } else if (keyword.equals("ambient")) {
            this.ambient = split[1].equals("vertexcolour") ? ColorRGBA.White : this.readColor(split[1]);
        } else if (keyword.equals("emissive")) {
            this.emissive = this.readColor(split[1]);
        } else if (keyword.equals("specular")) {
            String[] subsplit = split[1].split(" ");
            this.specular = new ColorRGBA();
            this.specular.r = Float.parseFloat(subsplit[0]);
            this.specular.g = Float.parseFloat(subsplit[1]);
            this.specular.b = Float.parseFloat(subsplit[2]);
            float unknown = Float.parseFloat(subsplit[3]);
            if (subsplit.length >= 5) {
                this.specular.a = unknown;
                this.shinines = Float.parseFloat(subsplit[4]);
            } else {
                this.specular.a = 1.0f;
                this.shinines = unknown;
            }
        } else if (keyword.equals("texture_unit")) {
            this.readTextureUnit(statement);
        } else if (keyword.equals("scene_blend")) {
            String mode = split[1];
            if (mode.equals("alpha_blend")) {
                this.blend = true;
            }
        } else if (keyword.equals("cull_hardware")) {
            String mode = split[1];
            if (mode.equals("none")) {
                this.twoSide = true;
            }
        } else if (!keyword.equals("cull_software")) {
            if (keyword.equals("lighting")) {
                String isOn = split[1];
                if (isOn.equals("on")) {
                    this.noLight = false;
                } else if (isOn.equals("off")) {
                    this.noLight = true;
                }
            } else {
                logger.log(Level.WARNING, "Unsupported pass directive: {0}", keyword);
            }
        }
    }

    private void readPass(Statement statement) {
        String[] split = statement.getLine().split(" ", 2);
        String name = split.length == 1 ? null : split[1];
        for (Statement passStat : statement.getContents()) {
            this.readPassStatement(passStat);
        }
        this.texUnit = 0;
    }

    private void readTechnique(Statement statement) {
        String[] split = statement.getLine().split(" ", 2);
        String name = split.length == 1 ? null : split[1];
        for (Statement techStat : statement.getContents()) {
            this.readPass(techStat);
        }
    }

    private void readMaterialStatement(Statement statement) {
        String isOn;
        if (statement.getLine().startsWith("technique")) {
            this.readTechnique(statement);
        } else if (!statement.getLine().startsWith("receive_shadows") || (isOn = statement.getLine().split(" ")[1]) == null || isOn.equals("true")) {
            // empty if block
        }
    }

    private void readMaterial(Statement statement) {
        for (Statement materialStat : statement.getContents()) {
            this.readMaterialStatement(materialStat);
        }
    }

    private Material compileMaterial() {
        Material mat = this.noLight ? new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md") : new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (this.blend) {
            RenderState rs = mat.getAdditionalRenderState();
            rs.setAlphaTest(true);
            rs.setAlphaFallOff(0.01f);
            rs.setBlendMode(RenderState.BlendMode.Alpha);
            if (this.twoSide) {
                rs.setFaceCullMode(RenderState.FaceCullMode.Off);
            }
            mat.setTransparent(true);
            if (!this.noLight) {
                mat.setBoolean("UseAlpha", true);
            }
        } else if (this.twoSide) {
            RenderState rs = mat.getAdditionalRenderState();
            rs.setFaceCullMode(RenderState.FaceCullMode.Off);
        }
        if (!this.noLight) {
            if (this.shinines > 0.0f) {
                mat.setFloat("Shininess", this.shinines);
            } else {
                mat.setFloat("Shininess", 16.0f);
            }
            if (this.vcolor) {
                mat.setBoolean("UseVertexColor", true);
            }
            if (this.textures[0] != null) {
                mat.setTexture("DiffuseMap", this.textures[0]);
            }
            mat.setBoolean("UseMaterialColors", true);
            if (this.diffuse != null) {
                mat.setColor("Diffuse", this.diffuse);
            } else {
                mat.setColor("Diffuse", ColorRGBA.White);
            }
            if (this.ambient != null) {
                mat.setColor("Ambient", this.ambient);
            } else {
                mat.setColor("Ambient", ColorRGBA.DarkGray);
            }
            if (this.specular != null) {
                mat.setColor("Specular", this.specular);
            } else {
                mat.setColor("Specular", ColorRGBA.Black);
            }
            if (this.emissive != null) {
                mat.setColor("GlowColor", this.emissive);
            }
        } else {
            if (this.vcolor) {
                mat.setBoolean("VertexColor", true);
            }
            if (this.textures[0] != null && this.textures[1] == null) {
                if (this.separateTexCoord) {
                    mat.setTexture("LightMap", this.textures[0]);
                    mat.setBoolean("SeparateTexCoord", true);
                } else {
                    mat.setTexture("ColorMap", this.textures[0]);
                }
            } else if (this.textures[1] != null) {
                mat.setTexture("ColorMap", this.textures[0]);
                mat.setTexture("LightMap", this.textures[1]);
                if (this.separateTexCoord) {
                    mat.setBoolean("SeparateTexCoord", true);
                }
            }
            if (this.diffuse != null) {
                mat.setColor("Color", this.diffuse);
            }
            if (this.emissive != null) {
                mat.setColor("GlowColor", this.emissive);
            }
        }
        this.noLight = false;
        Arrays.fill(this.textures, null);
        this.diffuse = null;
        this.specular = null;
        this.shinines = 0.0f;
        this.vcolor = false;
        this.blend = false;
        this.texUnit = 0;
        this.separateTexCoord = false;
        return mat;
    }

    private MaterialList load(AssetManager assetManager, AssetKey key, InputStream in) throws IOException {
        this.folderName = key.getFolder();
        this.assetManager = assetManager;
        MaterialList list = null;
        List<Statement> statements = BlockLanguageParser.parse(in);
        for (Statement statement : statements) {
            if (statement.getLine().startsWith("import")) {
                MaterialExtensionSet matExts = null;
                if (key instanceof OgreMaterialKey) {
                    matExts = ((OgreMaterialKey)key).getMaterialExtensionSet();
                }
                if (matExts == null) {
                    throw new IOException("Must specify MaterialExtensionSet when loading\nOgre3D materials with extended materials");
                }
                list = new MaterialExtensionLoader().load(assetManager, matExts, statements);
                break;
            }
            if (!statement.getLine().startsWith("material")) continue;
            if (list == null) {
                list = new MaterialList();
            }
            String[] split = statement.getLine().split(" ", 2);
            this.matName = split[1].trim();
            this.readMaterial(statement);
            Material mat = this.compileMaterial();
            list.put(this.matName, mat);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo info) throws IOException {
        InputStream in = null;
        try {
            in = info.openStream();
            MaterialList materialList = this.load(info.getManager(), info.getKey(), in);
            return materialList;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

