/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.textures.UVProjectionGenerator;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UVCoordinatesGenerator {
    private static final Logger LOGGER = Logger.getLogger(UVCoordinatesGenerator.class.getName());
    public static final int TEXCO_ORCO = 1;
    public static final int TEXCO_REFL = 2;
    public static final int TEXCO_NORM = 4;
    public static final int TEXCO_GLOB = 8;
    public static final int TEXCO_UV = 16;
    public static final int TEXCO_OBJECT = 32;
    public static final int TEXCO_LAVECTOR = 64;
    public static final int TEXCO_VIEW = 128;
    public static final int TEXCO_STICKY = 256;
    public static final int TEXCO_OSA = 512;
    public static final int TEXCO_WINDOW = 1024;
    public static final int NEED_UV = 2048;
    public static final int TEXCO_TANGENT = 4096;
    public static final int TEXCO_PARTICLE_OR_STRAND = 8192;
    public static final int TEXCO_STRESS = 16384;
    public static final int TEXCO_SPEED = 32768;
    public static final int PROJECTION_FLAT = 0;
    public static final int PROJECTION_CUBE = 1;
    public static final int PROJECTION_TUBE = 2;
    public static final int PROJECTION_SPHERE = 3;

    public static VertexBuffer generateUVCoordinates(int texco, int projection, int textureDimension, int[] coordinatesSwappingIndexes, List<Geometry> geometries) {
        if (textureDimension != 2 && textureDimension != 3) {
            throw new IllegalStateException("Unsupported texture dimension: " + textureDimension);
        }
        VertexBuffer result = new VertexBuffer(VertexBuffer.Type.TexCoord);
        Mesh mesh = geometries.get(0).getMesh();
        BoundingBox bb = UVCoordinatesGenerator.getBoundingBox(geometries);
        float[] inputData = null;
        switch (texco) {
            case 1: {
                inputData = BufferUtils.getFloatArray(mesh.getFloatBuffer(VertexBuffer.Type.Position));
                break;
            }
            case 16: {
                FloatBuffer uvCoordinatesBuffer = BufferUtils.createFloatBuffer(mesh.getVertexCount() * textureDimension);
                Vector2f[] data = new Vector2f[]{new Vector2f(0.0f, 1.0f), new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f)};
                for (int i = 0; i < mesh.getVertexCount(); ++i) {
                    Vector2f uv = data[i % 3];
                    uvCoordinatesBuffer.put(uv.x);
                    uvCoordinatesBuffer.put(uv.y);
                    if (textureDimension != 3) continue;
                    uvCoordinatesBuffer.put(0.0f);
                }
                result.setupData(VertexBuffer.Usage.Static, textureDimension, VertexBuffer.Format.Float, uvCoordinatesBuffer);
                break;
            }
            case 4: {
                inputData = BufferUtils.getFloatArray(mesh.getFloatBuffer(VertexBuffer.Type.Normal));
                break;
            }
            case 2: 
            case 8: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: {
                LOGGER.warning("Texture coordinates type not currently supported: " + texco);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown texture coordinates value: " + texco);
            }
        }
        if (inputData != null) {
            if (textureDimension == 2) {
                switch (projection) {
                    case 0: {
                        inputData = UVProjectionGenerator.flatProjection(mesh, bb);
                        break;
                    }
                    case 1: {
                        inputData = UVProjectionGenerator.cubeProjection(mesh, bb);
                        break;
                    }
                    case 2: {
                        BoundingTube bt = UVCoordinatesGenerator.getBoundingTube(geometries);
                        inputData = UVProjectionGenerator.tubeProjection(mesh, bt);
                        break;
                    }
                    case 3: {
                        BoundingSphere bs = UVCoordinatesGenerator.getBoundingSphere(geometries);
                        inputData = UVProjectionGenerator.sphereProjection(mesh, bs);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown projection type: " + projection);
                    }
                }
            } else {
                Vector3f min = bb.getMin(null);
                float[] uvCoordsResults = new float[4];
                float[] ext = new float[]{bb.getXExtent() * 2.0f, bb.getYExtent() * 2.0f, bb.getZExtent() * 2.0f};
                for (int i = 0; i < inputData.length; i += 3) {
                    uvCoordsResults[1] = (inputData[i] - min.x) / ext[0];
                    uvCoordsResults[2] = (inputData[i + 1] - min.y) / ext[1];
                    uvCoordsResults[3] = (inputData[i + 2] - min.z) / ext[2];
                    inputData[i] = uvCoordsResults[coordinatesSwappingIndexes[0]];
                    inputData[i + 1] = uvCoordsResults[coordinatesSwappingIndexes[1]];
                    inputData[i + 2] = uvCoordsResults[coordinatesSwappingIndexes[2]];
                }
            }
            result.setupData(VertexBuffer.Usage.Static, textureDimension, VertexBuffer.Format.Float, BufferUtils.createFloatBuffer(inputData));
        }
        for (Geometry geometry : geometries) {
            mesh = geometry.getMesh();
            mesh.clearBuffer(VertexBuffer.Type.TexCoord);
            mesh.setBuffer(result);
        }
        return result;
    }

    static BoundingBox getBoundingBox(List<Geometry> geometries) {
        BoundingBox result = null;
        for (Geometry geometry : geometries) {
            BoundingBox bb = UVCoordinatesGenerator.getBoundingBox(geometry.getMesh());
            if (result == null) {
                result = bb;
                continue;
            }
            result.merge(bb);
        }
        return result;
    }

    static BoundingBox getBoundingBox(Mesh mesh) {
        mesh.updateBound();
        BoundingVolume bv = mesh.getBound();
        if (bv instanceof BoundingBox) {
            return (BoundingBox)bv;
        }
        if (bv instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)bv;
            float r = bs.getRadius();
            return new BoundingBox(bs.getCenter(), r, r, r);
        }
        throw new IllegalStateException("Unknown bounding volume type: " + bv.getClass().getName());
    }

    static BoundingSphere getBoundingSphere(List<Geometry> geometries) {
        BoundingSphere result = null;
        for (Geometry geometry : geometries) {
            BoundingSphere bs = UVCoordinatesGenerator.getBoundingSphere(geometry.getMesh());
            if (result == null) {
                result = bs;
                continue;
            }
            result.merge(bs);
        }
        return result;
    }

    static BoundingSphere getBoundingSphere(Mesh mesh) {
        mesh.updateBound();
        BoundingVolume bv = mesh.getBound();
        if (bv instanceof BoundingBox) {
            BoundingBox bb = (BoundingBox)bv;
            float r = Math.max(bb.getXExtent(), bb.getYExtent());
            r = Math.max(r, bb.getZExtent());
            return new BoundingSphere(r, bb.getCenter());
        }
        if (bv instanceof BoundingSphere) {
            return (BoundingSphere)bv;
        }
        throw new IllegalStateException("Unknown bounding volume type: " + bv.getClass().getName());
    }

    static BoundingTube getBoundingTube(Mesh mesh) {
        Vector3f center = new Vector3f();
        float maxx = -3.4028235E38f;
        float minx = Float.MAX_VALUE;
        float maxy = -3.4028235E38f;
        float miny = Float.MAX_VALUE;
        float maxz = -3.4028235E38f;
        float minz = Float.MAX_VALUE;
        FloatBuffer positions = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        int limit = positions.limit();
        for (int i = 0; i < limit; i += 3) {
            float x = positions.get(i);
            float y = positions.get(i + 1);
            float z = positions.get(i + 2);
            center.addLocal(x, y, z);
            maxx = x > maxx ? x : maxx;
            minx = x < minx ? x : minx;
            maxy = y > maxy ? y : maxy;
            miny = y < miny ? y : miny;
            maxz = z > maxz ? z : maxz;
            minz = z < minz ? z : minz;
        }
        center.divideLocal(limit / 3);
        float radius = Math.max(maxx - minx, maxy - miny) * 0.5f;
        return new BoundingTube(radius, maxz - minz, center);
    }

    static BoundingTube getBoundingTube(List<Geometry> geometries) {
        BoundingTube result = null;
        for (Geometry geometry : geometries) {
            BoundingTube bt = UVCoordinatesGenerator.getBoundingTube(geometry.getMesh());
            if (result == null) {
                result = bt;
                continue;
            }
            result.merge(bt);
        }
        return result;
    }

    static class BoundingTube {
        private float radius;
        private float height;
        private Vector3f center;

        public BoundingTube(float radius, float height, Vector3f center) {
            this.radius = radius;
            this.height = height;
            this.center = center;
        }

        public BoundingTube merge(BoundingTube boundingTube) {
            BoundingTube tube2;
            BoundingTube tube1;
            if (this.radius >= boundingTube.radius) {
                tube1 = this;
                tube2 = boundingTube;
            } else {
                tube1 = boundingTube;
                tube2 = this;
            }
            float r1 = tube1.radius;
            float r2 = tube2.radius;
            float minZ = Math.min(tube1.center.z - tube1.height * 0.5f, tube2.center.z - tube2.height * 0.5f);
            float maxZ = Math.max(tube1.center.z + tube1.height * 0.5f, tube2.center.z + tube2.height * 0.5f);
            float height = maxZ - minZ;
            Vector3f distance = tube2.center.subtract(tube1.center);
            Vector3f center = tube1.center.add(distance.mult(0.5f));
            distance.z = 0.0f;
            float d = distance.length();
            float radius = d <= r1 - r2 ? tube1.radius : (d + r1 + r2) * 0.5f;
            return new BoundingTube(radius, height, center);
        }

        public float getRadius() {
            return this.radius;
        }

        public float getHeight() {
            return this.height;
        }

        public Vector3f getCenter() {
            return this.center;
        }
    }
}

