/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.BlenderKey;
import com.jme3.asset.GeneratedTextureKey;
import com.jme3.asset.TextureKey;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.textures.ImageLoader;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorBlend;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorClouds;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorDistnoise;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorMagic;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorMarble;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorMusgrave;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorNoise;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorStucci;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorVoronoi;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorWood;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3tools.converters.ImageToAwt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(TextureHelper.class.getName());
    public static final int TEX_NONE = 0;
    public static final int TEX_CLOUDS = 1;
    public static final int TEX_WOOD = 2;
    public static final int TEX_MARBLE = 3;
    public static final int TEX_MAGIC = 4;
    public static final int TEX_BLEND = 5;
    public static final int TEX_STUCCI = 6;
    public static final int TEX_NOISE = 7;
    public static final int TEX_IMAGE = 8;
    public static final int TEX_PLUGIN = 9;
    public static final int TEX_ENVMAP = 10;
    public static final int TEX_MUSGRAVE = 11;
    public static final int TEX_VORONOI = 12;
    public static final int TEX_DISTNOISE = 13;
    public static final int TEX_POINTDENSITY = 14;
    public static final int TEX_VOXELDATA = 15;
    public static final int MAP_COL = 1;
    public static final int MAP_NORM = 2;
    public static final int MAP_COLSPEC = 4;
    public static final int MAP_COLMIR = 8;
    public static final int MAP_VARS = 65520;
    public static final int MAP_REF = 16;
    public static final int MAP_SPEC = 32;
    public static final int MAP_EMIT = 64;
    public static final int MAP_ALPHA = 128;
    public static final int MAP_HAR = 256;
    public static final int MAP_RAYMIRR = 512;
    public static final int MAP_TRANSLU = 1024;
    public static final int MAP_AMB = 2048;
    public static final int MAP_DISPLACE = 4096;
    public static final int MAP_WARP = 8192;
    public static final int MAP_LAYER = 16384;
    public static final int MTEX_BLEND = 0;
    public static final int MTEX_MUL = 1;
    public static final int MTEX_ADD = 2;
    public static final int MTEX_SUB = 3;
    public static final int MTEX_DIV = 4;
    public static final int MTEX_DARK = 5;
    public static final int MTEX_DIFF = 6;
    public static final int MTEX_LIGHT = 7;
    public static final int MTEX_SCREEN = 8;
    public static final int MTEX_OVERLAY = 9;
    public static final int MTEX_BLEND_HUE = 10;
    public static final int MTEX_BLEND_SAT = 11;
    public static final int MTEX_BLEND_VAL = 12;
    public static final int MTEX_BLEND_COLOR = 13;
    public static final int MTEX_NUM_BLENDTYPES = 14;
    protected NoiseGenerator noiseGenerator;
    private Map<Integer, TextureGenerator> textureGenerators = new HashMap<Integer, TextureGenerator>();

    public TextureHelper(String blenderVersion) {
        super(blenderVersion);
        this.noiseGenerator = new NoiseGenerator(blenderVersion);
        this.textureGenerators.put(5, new TextureGeneratorBlend(this.noiseGenerator));
        this.textureGenerators.put(1, new TextureGeneratorClouds(this.noiseGenerator));
        this.textureGenerators.put(13, new TextureGeneratorDistnoise(this.noiseGenerator));
        this.textureGenerators.put(4, new TextureGeneratorMagic(this.noiseGenerator));
        this.textureGenerators.put(3, new TextureGeneratorMarble(this.noiseGenerator));
        this.textureGenerators.put(11, new TextureGeneratorMusgrave(this.noiseGenerator));
        this.textureGenerators.put(7, new TextureGeneratorNoise(this.noiseGenerator));
        this.textureGenerators.put(6, new TextureGeneratorStucci(this.noiseGenerator));
        this.textureGenerators.put(12, new TextureGeneratorVoronoi(this.noiseGenerator));
        this.textureGenerators.put(2, new TextureGeneratorWood(this.noiseGenerator));
    }

    public Texture getTexture(Structure tex, BlenderContext blenderContext) throws BlenderFileException {
        Texture result = (Texture)blenderContext.getLoadedFeature(tex.getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (result != null) {
            return result;
        }
        int type = ((Number)tex.getFieldValue("type")).intValue();
        int width = blenderContext.getBlenderKey().getGeneratedTextureWidth();
        int height = blenderContext.getBlenderKey().getGeneratedTextureHeight();
        int depth = blenderContext.getBlenderKey().getGeneratedTextureDepth();
        switch (type) {
            case 8: {
                Pointer pImage = (Pointer)tex.getFieldValue("ima");
                if (!pImage.isNotNull()) break;
                Structure image = pImage.fetchData(blenderContext.getInputStream()).get(0);
                result = this.getTextureFromImage(image, blenderContext);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                TextureGenerator textureGenerator = this.textureGenerators.get(type);
                result = textureGenerator.generate(tex, width, height, depth, blenderContext);
                break;
            }
            case 0: {
                break;
            }
            case 14: {
                LOGGER.warning("Point density texture loading currently not supported!");
                break;
            }
            case 15: {
                LOGGER.warning("Voxel data texture loading currently not supported!");
                break;
            }
            case 9: 
            case 10: {
                LOGGER.log(Level.WARNING, "Unsupported texture type: {0} for texture: {1}", new Object[]{type, tex.getName()});
                break;
            }
            default: {
                throw new BlenderFileException("Unknown texture type: " + type + " for texture: " + tex.getName());
            }
        }
        if (result != null) {
            result.setName(tex.getName());
            result.setWrap(Texture.WrapMode.Repeat);
            result.setMinFilter(Texture.MinFilter.Trilinear);
            if (type != 8) {
                result.setKey(new GeneratedTextureKey(tex.getName()));
            }
        }
        return result;
    }

    public Texture blendTexture(float[] materialColor, Texture texture, float[] color, float affectFactor, int blendType, boolean neg, BlenderContext blenderContext) {
        float[] materialColorClone = (float[])materialColor.clone();
        Image.Format format = texture.getImage().getFormat();
        ByteBuffer data = texture.getImage().getData(0);
        data.rewind();
        int width = texture.getImage().getWidth();
        int height = texture.getImage().getHeight();
        int depth = texture.getImage().getDepth();
        if (depth == 0) {
            depth = 1;
        }
        ByteBuffer newData = BufferUtils.createByteBuffer(width * height * depth * 4);
        float[] resultPixel = new float[4];
        int dataIndex = 0;
        while (data.hasRemaining()) {
            float tin = this.setupMaterialColor(data, format, neg, materialColorClone);
            this.blendPixel(resultPixel, materialColorClone, color, tin, affectFactor, blendType, blenderContext);
            newData.put(dataIndex++, (byte)(resultPixel[0] * 255.0f));
            newData.put(dataIndex++, (byte)(resultPixel[1] * 255.0f));
            newData.put(dataIndex++, (byte)(resultPixel[2] * 255.0f));
            newData.put(dataIndex++, (byte)(materialColorClone[3] * 255.0f));
        }
        if (texture.getType() == Texture.Type.TwoDimensional) {
            return new Texture2D(new Image(Image.Format.RGBA8, width, height, newData));
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(newData);
        return new Texture3D(new Image(Image.Format.RGBA8, width, height, depth, dataArray));
    }

    public Texture mergeTextures(List<Texture> sources, MaterialContext materialContext) {
        Texture result = null;
        if (sources != null && sources.size() > 0) {
            int lastTextureWithoutAlphaIndex = 0;
            int width = sources.get(0).getImage().getWidth();
            int height = sources.get(0).getImage().getHeight();
            int depth = sources.get(0).getImage().getDepth();
            for (Texture source : sources) {
                if (source.getImage().getWidth() != width) {
                    throw new IllegalArgumentException("The texture " + source.getName() + " has invalid width! It should be: " + width + '!');
                }
                if (source.getImage().getHeight() != height) {
                    throw new IllegalArgumentException("The texture " + source.getName() + " has invalid height! It should be: " + height + '!');
                }
                if (source.getImage().getDepth() != depth) {
                    throw new IllegalArgumentException("The texture " + source.getName() + " has invalid depth! It should be: " + depth + '!');
                }
                if (source.getImage().getFormat() == Image.Format.RGB8 || source.getImage().getFormat() == Image.Format.BGR8) continue;
                ++lastTextureWithoutAlphaIndex;
            }
            if (depth == 0) {
                depth = 1;
            }
            if (lastTextureWithoutAlphaIndex > 0 && lastTextureWithoutAlphaIndex < sources.size() - 1) {
                sources = sources.subList(lastTextureWithoutAlphaIndex, sources.size() - 1);
            }
            int pixelsAmount = width * height * depth;
            ByteBuffer data = BufferUtils.createByteBuffer(pixelsAmount * 3);
            TexturePixel resultPixel = new TexturePixel();
            TexturePixel sourcePixel = new TexturePixel();
            ColorRGBA diffuseColor = materialContext.getDiffuseColor();
            for (int i = 0; i < pixelsAmount; ++i) {
                for (int j = 0; j < sources.size(); ++j) {
                    Image image = sources.get(j).getImage();
                    ByteBuffer sourceData = image.getData(0);
                    if (j == 0) {
                        resultPixel.fromColor(diffuseColor);
                        sourcePixel.fromImage(image.getFormat(), sourceData, i);
                        resultPixel.merge(sourcePixel);
                        continue;
                    }
                    sourcePixel.fromImage(image.getFormat(), sourceData, i);
                    resultPixel.merge(sourcePixel);
                }
                data.put((byte)(255.0f * resultPixel.red));
                data.put((byte)(255.0f * resultPixel.green));
                data.put((byte)(255.0f * resultPixel.blue));
                resultPixel.clear();
            }
            if (depth == 1) {
                result = new Texture2D(new Image(Image.Format.RGB8, width, height, data));
            } else {
                ArrayList<ByteBuffer> arrayData = new ArrayList<ByteBuffer>(1);
                arrayData.add(data);
                result = new Texture3D(new Image(Image.Format.RGB8, width, height, depth, arrayData));
            }
        }
        return result;
    }

    protected float setupMaterialColor(ByteBuffer data, Image.Format imageFormat, boolean neg, float[] materialColor) {
        float tin = 0.0f;
        byte pixelValue = data.get();
        float firstPixelValue = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
        switch (imageFormat) {
            case Luminance8: {
                materialColor[3] = tin = neg ? 1.0f - firstPixelValue : firstPixelValue;
                neg = false;
                break;
            }
            case RGBA8: {
                materialColor[0] = firstPixelValue;
                pixelValue = data.get();
                materialColor[1] = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get();
                materialColor[2] = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get();
                materialColor[3] = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                break;
            }
            case ABGR8: {
                materialColor[3] = firstPixelValue;
                pixelValue = data.get();
                materialColor[2] = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get();
                materialColor[1] = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get();
                materialColor[0] = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                break;
            }
            case BGR8: {
                materialColor[2] = firstPixelValue;
                pixelValue = data.get();
                materialColor[1] = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get();
                materialColor[0] = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                materialColor[3] = 1.0f;
                break;
            }
            case RGB8: {
                materialColor[0] = firstPixelValue;
                pixelValue = data.get();
                materialColor[1] = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                pixelValue = data.get();
                materialColor[2] = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                materialColor[3] = 1.0f;
                break;
            }
            case Luminance8Alpha8: {
                tin = neg ? 1.0f - firstPixelValue : firstPixelValue;
                neg = false;
                pixelValue = data.get();
                materialColor[3] = pixelValue >= 0 ? (float)pixelValue / 255.0f : 1.0f - (float)(~pixelValue) / 255.0f;
                break;
            }
            case Luminance16: 
            case Luminance16Alpha16: 
            case Alpha16: 
            case Alpha8: 
            case ARGB4444: 
            case Depth: 
            case Depth16: 
            case Depth24: 
            case Depth32: 
            case Depth32F: 
            case DXT1: 
            case DXT1A: 
            case DXT3: 
            case DXT5: 
            case Intensity16: 
            case Intensity8: 
            case LATC: 
            case LTC: 
            case Luminance16F: 
            case Luminance16FAlpha16F: 
            case Luminance32F: 
            case RGB10: 
            case RGB111110F: 
            case RGB16: 
            case RGB16F: 
            case RGB16F_to_RGB111110F: 
            case RGB16F_to_RGB9E5: 
            case RGB32F: 
            case RGB565: 
            case RGB5A1: 
            case RGB9E5: 
            case RGBA16: 
            case RGBA16F: 
            case RGBA32F: {
                LOGGER.log(Level.WARNING, "Image type not yet supported for blending: {0}", (Object)imageFormat);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown image format type: " + (Object)((Object)imageFormat));
            }
        }
        if (neg) {
            materialColor[0] = 1.0f - materialColor[0];
            materialColor[1] = 1.0f - materialColor[1];
            materialColor[2] = 1.0f - materialColor[2];
        }
        return tin;
    }

    protected void blendPixel(float[] result, float[] materialColor, float[] color, float textureIntensity, float textureFactor, int blendtype, BlenderContext blenderContext) {
        textureIntensity *= textureFactor;
        switch (blendtype) {
            case 0: {
                float oneMinusFactor = 1.0f - textureIntensity;
                result[0] = textureIntensity * color[0] + oneMinusFactor * materialColor[0];
                result[1] = textureIntensity * color[1] + oneMinusFactor * materialColor[1];
                result[2] = textureIntensity * color[2] + oneMinusFactor * materialColor[2];
                break;
            }
            case 1: {
                float oneMinusFactor = 1.0f - textureFactor;
                result[0] = (oneMinusFactor + textureIntensity * materialColor[0]) * color[0];
                result[1] = (oneMinusFactor + textureIntensity * materialColor[1]) * color[1];
                result[2] = (oneMinusFactor + textureIntensity * materialColor[2]) * color[2];
                break;
            }
            case 4: {
                float oneMinusFactor = 1.0f - textureIntensity;
                if ((double)color[0] != 0.0) {
                    result[0] = (oneMinusFactor * materialColor[0] + textureIntensity * materialColor[0] / color[0]) * 0.5f;
                }
                if ((double)color[1] != 0.0) {
                    result[1] = (oneMinusFactor * materialColor[1] + textureIntensity * materialColor[1] / color[1]) * 0.5f;
                }
                if ((double)color[2] == 0.0) break;
                result[2] = (oneMinusFactor * materialColor[2] + textureIntensity * materialColor[2] / color[2]) * 0.5f;
                break;
            }
            case 8: {
                float oneMinusFactor = 1.0f - textureFactor;
                result[0] = 1.0f - (oneMinusFactor + textureIntensity * (1.0f - materialColor[0])) * (1.0f - color[0]);
                result[1] = 1.0f - (oneMinusFactor + textureIntensity * (1.0f - materialColor[1])) * (1.0f - color[1]);
                result[2] = 1.0f - (oneMinusFactor + textureIntensity * (1.0f - materialColor[2])) * (1.0f - color[2]);
                break;
            }
            case 9: {
                float oneMinusFactor = 1.0f - textureFactor;
                result[0] = materialColor[0] < 0.5f ? color[0] * (oneMinusFactor + 2.0f * textureIntensity * materialColor[0]) : 1.0f - (oneMinusFactor + 2.0f * textureIntensity * (1.0f - materialColor[0])) * (1.0f - color[0]);
                result[1] = materialColor[1] < 0.5f ? color[1] * (oneMinusFactor + 2.0f * textureIntensity * materialColor[1]) : 1.0f - (oneMinusFactor + 2.0f * textureIntensity * (1.0f - materialColor[1])) * (1.0f - color[1]);
                if (materialColor[2] < 0.5f) {
                    result[2] = color[2] * (oneMinusFactor + 2.0f * textureIntensity * materialColor[2]);
                    break;
                }
                result[2] = 1.0f - (oneMinusFactor + 2.0f * textureIntensity * (1.0f - materialColor[2])) * (1.0f - color[2]);
                break;
            }
            case 3: {
                result[0] = materialColor[0] - textureIntensity * color[0];
                result[1] = materialColor[1] - textureIntensity * color[1];
                result[2] = materialColor[2] - textureIntensity * color[2];
                result[0] = FastMath.clamp(result[0], 0.0f, 1.0f);
                result[1] = FastMath.clamp(result[1], 0.0f, 1.0f);
                result[2] = FastMath.clamp(result[2], 0.0f, 1.0f);
                break;
            }
            case 2: {
                result[0] = (textureIntensity * color[0] + materialColor[0]) * 0.5f;
                result[1] = (textureIntensity * color[1] + materialColor[1]) * 0.5f;
                result[2] = (textureIntensity * color[2] + materialColor[2]) * 0.5f;
                break;
            }
            case 6: {
                float oneMinusFactor = 1.0f - textureIntensity;
                result[0] = oneMinusFactor * materialColor[0] + textureIntensity * Math.abs(materialColor[0] - color[0]);
                result[1] = oneMinusFactor * materialColor[1] + textureIntensity * Math.abs(materialColor[1] - color[1]);
                result[2] = oneMinusFactor * materialColor[2] + textureIntensity * Math.abs(materialColor[2] - color[2]);
                break;
            }
            case 5: {
                float col = textureIntensity * color[0];
                result[0] = col < materialColor[0] ? col : materialColor[0];
                col = textureIntensity * color[1];
                result[1] = col < materialColor[1] ? col : materialColor[1];
                col = textureIntensity * color[2];
                result[2] = col < materialColor[2] ? col : materialColor[2];
                break;
            }
            case 7: {
                float col = textureIntensity * color[0];
                result[0] = col > materialColor[0] ? col : materialColor[0];
                col = textureIntensity * color[1];
                result[1] = col > materialColor[1] ? col : materialColor[1];
                col = textureIntensity * color[2];
                result[2] = col > materialColor[2] ? col : materialColor[2];
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                System.arraycopy(materialColor, 0, result, 0, 3);
                this.rampBlend(blendtype, result, textureIntensity, color, blenderContext);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown blend type: " + blendtype);
            }
        }
    }

    protected void rampBlend(int type, float[] rgb, float fac, float[] col, BlenderContext blenderContext) {
        float oneMinusFactor = 1.0f - fac;
        MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
        if (rgb.length >= 3) {
            switch (type) {
                case 10: {
                    float[] colorTransformResult = new float[3];
                    materialHelper.rgbToHsv(col[0], col[1], col[2], colorTransformResult);
                    if (colorTransformResult[1] == 0.0f) break;
                    float colH = colorTransformResult[0];
                    materialHelper.rgbToHsv(rgb[0], rgb[1], rgb[2], colorTransformResult);
                    materialHelper.hsvToRgb(colH, colorTransformResult[1], colorTransformResult[2], colorTransformResult);
                    rgb[0] = oneMinusFactor * rgb[0] + fac * colorTransformResult[0];
                    rgb[1] = oneMinusFactor * rgb[1] + fac * colorTransformResult[1];
                    rgb[2] = oneMinusFactor * rgb[2] + fac * colorTransformResult[2];
                    break;
                }
                case 11: {
                    float[] colorTransformResult = new float[3];
                    materialHelper.rgbToHsv(rgb[0], rgb[1], rgb[2], colorTransformResult);
                    float h = colorTransformResult[0];
                    float s = colorTransformResult[1];
                    float v = colorTransformResult[2];
                    if (s == 0.0f) break;
                    materialHelper.rgbToHsv(col[0], col[1], col[2], colorTransformResult);
                    materialHelper.hsvToRgb(h, oneMinusFactor * s + fac * colorTransformResult[1], v, rgb);
                    break;
                }
                case 12: {
                    float[] rgbToHsv = new float[3];
                    float[] colToHsv = new float[3];
                    materialHelper.rgbToHsv(rgb[0], rgb[1], rgb[2], rgbToHsv);
                    materialHelper.rgbToHsv(col[0], col[1], col[2], colToHsv);
                    materialHelper.hsvToRgb(rgbToHsv[0], rgbToHsv[1], oneMinusFactor * rgbToHsv[2] + fac * colToHsv[2], rgb);
                    break;
                }
                case 13: {
                    float[] rgbToHsv = new float[3];
                    float[] colToHsv = new float[3];
                    materialHelper.rgbToHsv(col[0], col[1], col[2], colToHsv);
                    if (colToHsv[2] == 0.0f) break;
                    materialHelper.rgbToHsv(rgb[0], rgb[1], rgb[2], rgbToHsv);
                    materialHelper.hsvToRgb(colToHsv[0], colToHsv[1], rgbToHsv[2], rgbToHsv);
                    rgb[0] = oneMinusFactor * rgb[0] + fac * rgbToHsv[0];
                    rgb[1] = oneMinusFactor * rgb[1] + fac * rgbToHsv[1];
                    rgb[2] = oneMinusFactor * rgb[2] + fac * rgbToHsv[2];
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown ramp type: " + type);
                }
            }
        }
    }

    public Texture convertToNormalMapTexture(Texture source, float strengthFactor) {
        Image image = source.getImage();
        BufferedImage sourceImage = ImageToAwt.convert(image, false, false, 0);
        BufferedImage heightMap = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        BufferedImage bumpMap = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        ColorConvertOp gscale = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        gscale.filter(sourceImage, heightMap);
        Vector3f S = new Vector3f();
        Vector3f T = new Vector3f();
        Vector3f N = new Vector3f();
        for (int x = 0; x < bumpMap.getWidth(); ++x) {
            for (int y = 0; y < bumpMap.getHeight(); ++y) {
                S.x = 1.0f;
                S.y = 0.0f;
                S.z = strengthFactor * (float)this.getHeight(heightMap, x + 1, y) - strengthFactor * (float)this.getHeight(heightMap, x - 1, y);
                T.x = 0.0f;
                T.y = 1.0f;
                T.z = strengthFactor * (float)this.getHeight(heightMap, x, y + 1) - strengthFactor * (float)this.getHeight(heightMap, x, y - 1);
                float den = (float)Math.sqrt(S.z * S.z + T.z * T.z + 1.0f);
                N.x = -S.z;
                N.y = -T.z;
                N.z = 1.0f;
                N.divideLocal(den);
                bumpMap.setRGB(x, y, this.vectorToColor(N.x, N.y, N.z));
            }
        }
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(image.getWidth() * image.getHeight() * 3);
        ImageToAwt.convert(bumpMap, Image.Format.RGB8, byteBuffer);
        return new Texture2D(new Image(Image.Format.RGB8, image.getWidth(), image.getHeight(), byteBuffer));
    }

    protected int getHeight(BufferedImage image, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= image.getWidth()) {
            x = image.getWidth() - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= image.getHeight()) {
            y = image.getHeight() - 1;
        }
        return image.getRGB(x, y) & 0xFF;
    }

    protected int vectorToColor(float x, float y, float z) {
        int r = Math.round(255.0f * (x + 1.0f) / 2.0f);
        int g = Math.round(255.0f * (y + 1.0f) / 2.0f);
        int b = Math.round(255.0f * (z + 1.0f) / 2.0f);
        return -16777216 + (r << 16) + (g << 8) + b;
    }

    public Texture getTextureFromImage(Structure image, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.log(Level.FINE, "Fetching texture with OMA = {0}", image.getOldMemoryAddress());
        Texture result = (Texture)blenderContext.getLoadedFeature(image.getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (result == null) {
            String texturePath = image.getFieldValue("name").toString();
            Pointer pPackedFile = (Pointer)image.getFieldValue("packedfile");
            if (pPackedFile.isNull()) {
                LOGGER.log(Level.INFO, "Reading texture from file: {0}", texturePath);
                result = this.loadTextureFromFile(texturePath, blenderContext);
            } else {
                LOGGER.info("Packed texture. Reading directly from the blend file!");
                Structure packedFile = pPackedFile.fetchData(blenderContext.getInputStream()).get(0);
                Pointer pData = (Pointer)packedFile.getFieldValue("data");
                FileBlockHeader dataFileBlock = blenderContext.getFileBlock(pData.getOldMemoryAddress());
                blenderContext.getInputStream().setPosition(dataFileBlock.getBlockPosition());
                ImageLoader imageLoader = new ImageLoader();
                Image im = imageLoader.loadImage(blenderContext.getInputStream(), dataFileBlock.getBlockPosition(), true);
                if (im != null) {
                    result = new Texture2D(im);
                }
            }
            if (result != null) {
                result.setName(texturePath);
                result.setWrap(Texture.WrapMode.Repeat);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Adding texture {0} to the loaded features with OMA = {1}", new Object[]{texturePath, image.getOldMemoryAddress()});
                }
                blenderContext.addLoadedFeatures(image.getOldMemoryAddress(), image.getName(), image, result);
            }
        }
        return result;
    }

    protected Texture loadTextureFromFile(String name, BlenderContext blenderContext) {
        AssetManager assetManager = blenderContext.getAssetManager();
        name = name.replaceAll("\\\\", "\\/");
        Texture result = null;
        ArrayList<String> assetNames = new ArrayList<String>();
        if (name.startsWith("//")) {
            String relativePath = name.substring(2);
            BlenderKey blenderKey = blenderContext.getBlenderKey();
            int idx = blenderKey.getName().lastIndexOf(47);
            String blenderAssetFolder = blenderKey.getName().substring(0, idx != -1 ? idx : 0);
            assetNames.add(blenderAssetFolder + '/' + relativePath);
        } else {
            String[] paths = name.split("\\/");
            StringBuilder sb = new StringBuilder(paths[paths.length - 1]);
            assetNames.add(paths[paths.length - 1]);
            for (int i = paths.length - 2; i >= 0; --i) {
                sb.insert(0, '/');
                sb.insert(0, paths[i]);
                assetNames.add(0, sb.toString());
            }
        }
        for (String assetName : assetNames) {
            try {
                TextureKey key = new TextureKey(assetName);
                key.setGenerateMips(true);
                key.setAsCube(false);
                result = assetManager.loadTexture(key);
                break;
            }
            catch (AssetNotFoundException e) {
                LOGGER.fine(e.getLocalizedMessage());
            }
        }
        return result;
    }

    @Override
    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return (blenderContext.getBlenderKey().getFeaturesToLoad() & 1) != 0;
    }
}

